/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.util.Collection;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataDelta;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataImage;
import org.apache.kafka.coordinator.common.runtime.KRaftCoordinatorMetadataImage;
import org.apache.kafka.image.MetadataDelta;

public class KRaftCoordinatorMetadataDelta
implements CoordinatorMetadataDelta {
    final MetadataDelta metadataDelta;

    public KRaftCoordinatorMetadataDelta(MetadataDelta metadataDelta) {
        this.metadataDelta = metadataDelta;
    }

    @Override
    public Collection<Uuid> createdTopicIds() {
        if (this.metadataDelta == null || this.metadataDelta.topicsDelta() == null) {
            return Set.of();
        }
        return this.metadataDelta.topicsDelta().createdTopicIds();
    }

    @Override
    public Collection<Uuid> changedTopicIds() {
        if (this.metadataDelta == null || this.metadataDelta.topicsDelta() == null) {
            return Set.of();
        }
        return this.metadataDelta.topicsDelta().changedTopics().keySet();
    }

    @Override
    public Set<Uuid> deletedTopicIds() {
        if (this.metadataDelta == null || this.metadataDelta.topicsDelta() == null) {
            return Set.of();
        }
        return this.metadataDelta.topicsDelta().deletedTopicIds();
    }

    @Override
    public CoordinatorMetadataImage image() {
        return new KRaftCoordinatorMetadataImage(this.metadataDelta.image());
    }

    public String toString() {
        return this.metadataDelta.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        KRaftCoordinatorMetadataDelta other = (KRaftCoordinatorMetadataDelta)o;
        return this.metadataDelta.equals(other.metadataDelta);
    }

    public int hashCode() {
        return this.metadataDelta.hashCode();
    }
}

