/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRecordStateException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.group.share.GroupTopicPartitionData;
import org.apache.kafka.server.group.share.PartitionAllData;
import org.apache.kafka.server.group.share.PartitionErrorData;
import org.apache.kafka.server.group.share.PartitionFactory;
import org.apache.kafka.server.group.share.Persister;
import org.apache.kafka.server.group.share.PersisterStateBatch;
import org.apache.kafka.server.group.share.ReadShareGroupStateParameters;
import org.apache.kafka.server.group.share.ReadShareGroupStateResult;
import org.apache.kafka.server.group.share.TopicData;
import org.apache.kafka.server.group.share.WriteShareGroupStateParameters;
import org.apache.kafka.server.group.share.WriteShareGroupStateResult;
import org.apache.kafka.server.share.ShareAcknowledgementBatch;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.server.util.timer.TimerTask;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharePartition {
    private static final Logger log = LoggerFactory.getLogger(SharePartition.class);
    static final String EMPTY_MEMBER_ID = Uuid.ZERO_UUID.toString();
    private final String groupId;
    private final TopicIdPartition topicIdPartition;
    private final NavigableMap<Long, InFlightBatch> cachedState;
    private final ReadWriteLock lock;
    private final AtomicBoolean findNextFetchOffset;
    private final AtomicBoolean fetchLock;
    private final int maxInFlightMessages;
    private final int maxDeliveryCount;
    private final int recordLockDurationMs;
    private final Timer timer;
    private final Time time;
    private final Persister persister;
    private long startOffset;
    private long endOffset;
    private int stateEpoch;

    SharePartition(String groupId, TopicIdPartition topicIdPartition, int maxInFlightMessages, int maxDeliveryCount, int recordLockDurationMs, Timer timer, Time time, Persister persister) {
        this.groupId = groupId;
        this.topicIdPartition = topicIdPartition;
        this.maxInFlightMessages = maxInFlightMessages;
        this.maxDeliveryCount = maxDeliveryCount;
        this.cachedState = new ConcurrentSkipListMap<Long, InFlightBatch>();
        this.lock = new ReentrantReadWriteLock();
        this.findNextFetchOffset = new AtomicBoolean(false);
        this.fetchLock = new AtomicBoolean(false);
        this.recordLockDurationMs = recordLockDurationMs;
        this.timer = timer;
        this.time = time;
        this.persister = persister;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextFetchOffset() {
        this.lock.writeLock().lock();
        try {
            if (!this.findNextFetchOffset.get()) {
                if (this.cachedState.isEmpty() || this.startOffset > this.cachedState.lastEntry().getValue().lastOffset()) {
                    long l = this.endOffset;
                    return l;
                }
                long l = this.endOffset + 1L;
                return l;
            }
            if (this.cachedState.isEmpty() || this.startOffset > this.cachedState.lastEntry().getValue().lastOffset()) {
                this.findNextFetchOffset.set(false);
                long l = this.endOffset;
                return l;
            }
            long nextFetchOffset = -1L;
            for (Map.Entry entry : this.cachedState.entrySet()) {
                if (((InFlightBatch)entry.getValue()).offsetState() == null) {
                    if (((InFlightBatch)entry.getValue()).batchState() != RecordState.AVAILABLE) continue;
                    nextFetchOffset = ((InFlightBatch)entry.getValue()).firstOffset();
                    break;
                }
                for (Map.Entry offsetState : ((InFlightBatch)entry.getValue()).offsetState().entrySet()) {
                    if (((InFlightState)offsetState.getValue()).state != RecordState.AVAILABLE) continue;
                    nextFetchOffset = (Long)offsetState.getKey();
                    break;
                }
                if (nextFetchOffset == -1L) continue;
                break;
            }
            if (nextFetchOffset == -1L) {
                this.findNextFetchOffset.set(false);
                nextFetchOffset = this.endOffset + 1L;
            }
            long l = nextFetchOffset;
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<List<ShareFetchResponseData.AcquiredRecords>> acquire(String memberId, FetchPartitionData fetchPartitionData) {
        log.trace("Received acquire request for share partition: {}-{}", (Object)memberId, (Object)fetchPartitionData);
        RecordBatch lastBatch = fetchPartitionData.records.lastBatch().orElse(null);
        if (lastBatch == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        RecordBatch firstBatch = (RecordBatch)fetchPartitionData.records.batches().iterator().next();
        this.lock.writeLock().lock();
        try {
            NavigableMap<Long, InFlightBatch> subMap;
            long baseOffset = firstBatch.baseOffset();
            Map.Entry<Long, InFlightBatch> floorOffset = this.cachedState.floorEntry(baseOffset);
            if (floorOffset != null && floorOffset.getValue().lastOffset() >= baseOffset) {
                baseOffset = floorOffset.getKey();
            }
            if ((subMap = this.cachedState.subMap(baseOffset, true, lastBatch.lastOffset(), true)).isEmpty()) {
                log.trace("No cached data exists for the share partition for requested fetch batch: {}-{}", (Object)this.groupId, (Object)this.topicIdPartition);
                CompletableFuture<List<ShareFetchResponseData.AcquiredRecords>> completableFuture = CompletableFuture.completedFuture(Collections.singletonList(this.acquireNewBatchRecords(memberId, firstBatch.baseOffset(), lastBatch.lastOffset())));
                return completableFuture;
            }
            log.trace("Overlap exists with in-flight records. Acquire the records if available for the share group: {}-{}", (Object)this.groupId, (Object)this.topicIdPartition);
            ArrayList<ShareFetchResponseData.AcquiredRecords> result = new ArrayList<ShareFetchResponseData.AcquiredRecords>();
            for (Map.Entry entry : subMap.entrySet()) {
                InFlightBatch inFlightBatch = (InFlightBatch)entry.getValue();
                boolean fullMatch = this.checkForFullMatch(inFlightBatch, firstBatch.baseOffset(), lastBatch.lastOffset());
                if (!fullMatch || inFlightBatch.offsetState() != null) {
                    log.trace("Subset or offset tracked batch record found for share partition, batch: {} request offsets - first: {}, last: {} for the share group: {}-{}", new Object[]{inFlightBatch, firstBatch.baseOffset(), lastBatch.lastOffset(), this.groupId, this.topicIdPartition});
                    if (inFlightBatch.offsetState() == null) {
                        if (inFlightBatch.batchState() != RecordState.AVAILABLE) {
                            log.trace("The batch is not available to acquire in share group: {}-{}, skipping: {} skipping offset tracking for batch as well.", new Object[]{this.groupId, this.topicIdPartition, inFlightBatch});
                            continue;
                        }
                        inFlightBatch.maybeInitializeOffsetStateUpdate();
                    }
                    this.acquireSubsetBatchRecords(memberId, firstBatch.baseOffset(), lastBatch.lastOffset(), inFlightBatch, result);
                    continue;
                }
                if (inFlightBatch.batchState() != RecordState.AVAILABLE) {
                    log.trace("The batch is not available to acquire in share group: {}-{}, skipping: {}", new Object[]{this.groupId, this.topicIdPartition, inFlightBatch});
                    continue;
                }
                InFlightState updateResult = inFlightBatch.tryUpdateBatchState(RecordState.ACQUIRED, true, this.maxDeliveryCount, memberId);
                if (updateResult == null) {
                    log.info("Unable to acquire records for the batch: {} in share group: {}-{}", new Object[]{inFlightBatch, this.groupId, this.topicIdPartition});
                    continue;
                }
                AcquisitionLockTimerTask acquisitionLockTimeoutTask = this.scheduleAcquisitionLockTimeout(memberId, inFlightBatch.firstOffset(), inFlightBatch.lastOffset());
                inFlightBatch.updateAcquisitionLockTimeout(acquisitionLockTimeoutTask);
                result.add(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(inFlightBatch.firstOffset()).setLastOffset(inFlightBatch.lastOffset()).setDeliveryCount((short)inFlightBatch.batchDeliveryCount()));
            }
            if (subMap.lastEntry().getValue().lastOffset() < lastBatch.lastOffset()) {
                log.trace("There exists another batch which needs to be acquired as well");
                result.add(this.acquireNewBatchRecords(memberId, subMap.lastEntry().getValue().lastOffset() + 1L, lastBatch.lastOffset()));
            }
            CompletableFuture completableFuture = CompletableFuture.completedFuture(result);
            return completableFuture;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Optional<Throwable>> acknowledge(String memberId, List<ShareAcknowledgementBatch> acknowledgementBatch) {
        log.trace("Acknowledgement batch request for share partition: {}-{}", (Object)this.groupId, (Object)this.topicIdPartition);
        Throwable throwable = null;
        this.lock.writeLock().lock();
        ArrayList<InFlightState> updatedStates = new ArrayList<InFlightState>();
        ArrayList<PersisterStateBatch> stateBatches = new ArrayList<PersisterStateBatch>();
        try {
            for (int i = 0; i < acknowledgementBatch.size(); ++i) {
                NavigableMap<Long, InFlightBatch> subMap;
                Map<Long, RecordState> recordStateMap;
                ShareAcknowledgementBatch batch = acknowledgementBatch.get(i);
                try {
                    recordStateMap = this.fetchRecordStateMapForAcknowledgementBatch(batch);
                }
                catch (IllegalArgumentException e) {
                    log.debug("Invalid acknowledge type: {} for share partition: {}-{}", new Object[]{batch.acknowledgeTypes(), this.groupId, this.topicIdPartition});
                    throwable = new InvalidRequestException("Invalid acknowledge type: " + batch.acknowledgeTypes());
                    break;
                }
                if (batch.lastOffset() < this.startOffset) {
                    log.trace("All offsets in the acknowledgement batch {} are already archived: {}-{}", new Object[]{batch, this.groupId, this.topicIdPartition});
                    continue;
                }
                try {
                    subMap = this.fetchSubMapForAcknowledgementBatch(batch, i == acknowledgementBatch.size() - 1);
                }
                catch (InvalidRecordStateException | InvalidRequestException e) {
                    throwable = e;
                    break;
                }
                Optional<Throwable> ackThrowable = this.acknowledgementBatchRecords(memberId, batch, recordStateMap, subMap, updatedStates, stateBatches);
                if (!ackThrowable.isPresent()) continue;
                throwable = ackThrowable.get();
                break;
            }
            this.rollbackOrProcessStateUpdates(throwable, updatedStates, stateBatches);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return CompletableFuture.completedFuture(Optional.ofNullable(throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Optional<Throwable>> releaseAcquiredRecords(String memberId) {
        log.trace("Release acquired records request for share partition: {}-{} memberId: {}", new Object[]{this.groupId, this.topicIdPartition, memberId});
        Throwable throwable = null;
        this.lock.writeLock().lock();
        ArrayList<InFlightState> updatedStates = new ArrayList<InFlightState>();
        ArrayList<PersisterStateBatch> stateBatches = new ArrayList<PersisterStateBatch>();
        try {
            RecordState recordState = RecordState.AVAILABLE;
            for (Map.Entry entry : this.cachedState.entrySet()) {
                Optional<Throwable> releaseAcquiredRecordsThrowable;
                InFlightBatch inFlightBatch = (InFlightBatch)entry.getValue();
                if (inFlightBatch.offsetState() == null && inFlightBatch.batchState() == RecordState.ACQUIRED && inFlightBatch.batchMemberId().equals(memberId) && this.checkForStartOffsetWithinBatch(inFlightBatch.firstOffset(), inFlightBatch.lastOffset())) {
                    inFlightBatch.maybeInitializeOffsetStateUpdate();
                }
                if (inFlightBatch.offsetState() != null) {
                    releaseAcquiredRecordsThrowable = this.releaseAcquiredRecordsForPerOffsetBatch(memberId, inFlightBatch, recordState, updatedStates, stateBatches);
                    if (!releaseAcquiredRecordsThrowable.isPresent()) continue;
                    throwable = releaseAcquiredRecordsThrowable.get();
                    break;
                }
                releaseAcquiredRecordsThrowable = this.releaseAcquiredRecordsForCompleteBatch(memberId, inFlightBatch, recordState, updatedStates, stateBatches);
                if (!releaseAcquiredRecordsThrowable.isPresent()) continue;
                throwable = releaseAcquiredRecordsThrowable.get();
                break;
            }
            this.rollbackOrProcessStateUpdates(throwable, updatedStates, stateBatches);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return CompletableFuture.completedFuture(Optional.ofNullable(throwable));
    }

    private Optional<Throwable> releaseAcquiredRecordsForPerOffsetBatch(String memberId, InFlightBatch inFlightBatch, RecordState recordState, List<InFlightState> updatedStates, List<PersisterStateBatch> stateBatches) {
        log.trace("Offset tracked batch record found, batch: {} for the share partition: {}-{}", new Object[]{inFlightBatch, this.groupId, this.topicIdPartition});
        for (Map.Entry offsetState : inFlightBatch.offsetState.entrySet()) {
            if (!((InFlightState)offsetState.getValue()).memberId().equals(memberId) && !((InFlightState)offsetState.getValue()).memberId().equals(EMPTY_MEMBER_ID)) {
                log.debug("Member {} is not the owner of offset: {} in batch: {} for the share partition: {}-{}. Skipping offset.", new Object[]{memberId, offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition});
                return Optional.empty();
            }
            if (((InFlightState)offsetState.getValue()).state != RecordState.ACQUIRED) continue;
            InFlightState updateResult = ((InFlightState)offsetState.getValue()).startStateTransition((Long)offsetState.getKey() < this.startOffset ? RecordState.ARCHIVED : recordState, false, this.maxDeliveryCount, SharePartition.EMPTY_MEMBER_ID);
            if (updateResult == null) {
                log.debug("Unable to release records from acquired state for the offset: {} in batch: {} for the share partition: {}-{}", new Object[]{offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition});
                return Optional.of(new InvalidRecordStateException("Unable to release acquired records for the offset"));
            }
            updatedStates.add(updateResult);
            stateBatches.add(new PersisterStateBatch(((Long)offsetState.getKey()).longValue(), ((Long)offsetState.getKey()).longValue(), ((InFlightState)updateResult).state.id, (short)updateResult.deliveryCount));
            if (updateResult.state == RecordState.ARCHIVED) continue;
            this.findNextFetchOffset.set(true);
        }
        return Optional.empty();
    }

    private Optional<Throwable> releaseAcquiredRecordsForCompleteBatch(String memberId, InFlightBatch inFlightBatch, RecordState recordState, List<InFlightState> updatedStates, List<PersisterStateBatch> stateBatches) {
        if (!inFlightBatch.batchMemberId().equals(memberId) && !inFlightBatch.batchMemberId().equals(EMPTY_MEMBER_ID)) {
            log.debug("Member {} is not the owner of batch record {} for share partition: {}-{}. Skipping batch.", new Object[]{memberId, inFlightBatch, this.groupId, this.topicIdPartition});
            return Optional.empty();
        }
        log.trace("Releasing acquired records for complete batch {} for the share partition: {}-{}", new Object[]{inFlightBatch, this.groupId, this.topicIdPartition});
        if (inFlightBatch.batchState() == RecordState.ACQUIRED) {
            InFlightState updateResult = inFlightBatch.startBatchStateTransition(inFlightBatch.lastOffset() < this.startOffset ? RecordState.ARCHIVED : recordState, false, this.maxDeliveryCount, SharePartition.EMPTY_MEMBER_ID);
            if (updateResult == null) {
                log.debug("Unable to release records from acquired state for the batch: {} for the share partition: {}-{}", new Object[]{inFlightBatch, this.groupId, this.topicIdPartition});
                return Optional.of(new InvalidRecordStateException("Unable to release acquired records for the batch"));
            }
            updatedStates.add(updateResult);
            stateBatches.add(new PersisterStateBatch(inFlightBatch.firstOffset(), inFlightBatch.lastOffset(), ((InFlightState)updateResult).state.id, (short)updateResult.deliveryCount));
            if (updateResult.state != RecordState.ARCHIVED) {
                this.findNextFetchOffset.set(true);
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCacheAndOffsets(long logStartOffset) {
        this.lock.writeLock().lock();
        try {
            if (logStartOffset <= this.startOffset) {
                log.error("The log start offset: {} is not greater than the start offset: {} for the share partition: {}-{}", new Object[]{logStartOffset, this.startOffset, this.groupId, this.topicIdPartition});
                return;
            }
            log.debug("Updating start offset for share partition: {}-{} from: {} to: {} since LSO has moved to: {}", new Object[]{this.groupId, this.topicIdPartition, this.startOffset, logStartOffset, logStartOffset});
            if (this.cachedState.isEmpty()) {
                this.startOffset = logStartOffset;
                this.endOffset = logStartOffset;
                return;
            }
            boolean anyRecordArchived = this.archiveAvailableRecordsOnLsoMovement(logStartOffset);
            if (anyRecordArchived) {
                this.findNextFetchOffset.set(true);
            }
            this.startOffset = logStartOffset;
            if (this.endOffset < this.startOffset) {
                this.endOffset = this.startOffset;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean archiveAvailableRecordsOnLsoMovement(long logStartOffset) {
        this.lock.writeLock().lock();
        try {
            Map.Entry entry;
            long batchStartOffset;
            boolean isAnyOffsetArchived = false;
            boolean isAnyBatchArchived = false;
            Iterator iterator = this.cachedState.entrySet().iterator();
            while (iterator.hasNext() && (batchStartOffset = ((Long)(entry = iterator.next()).getKey()).longValue()) < logStartOffset) {
                InFlightBatch inFlightBatch = (InFlightBatch)entry.getValue();
                boolean fullMatch = this.checkForFullMatch(inFlightBatch, this.startOffset, logStartOffset - 1L);
                if (!fullMatch || inFlightBatch.offsetState() != null) {
                    log.debug("Subset or offset tracked batch record found while trying to update offsets and cached state map due to LSO movement, batch: {}, offsets to update - first: {}, last: {} for the share partition: {}-{}", new Object[]{inFlightBatch, this.startOffset, logStartOffset - 1L, this.groupId, this.topicIdPartition});
                    if (inFlightBatch.offsetState() == null) {
                        if (inFlightBatch.batchState() != RecordState.AVAILABLE) continue;
                        inFlightBatch.maybeInitializeOffsetStateUpdate();
                    }
                    isAnyOffsetArchived = isAnyOffsetArchived || this.archivePerOffsetBatchRecords(inFlightBatch, this.startOffset, logStartOffset - 1L);
                    continue;
                }
                isAnyBatchArchived = isAnyBatchArchived || this.archiveCompleteBatch(inFlightBatch);
            }
            boolean bl = isAnyOffsetArchived || isAnyBatchArchived;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean archivePerOffsetBatchRecords(InFlightBatch inFlightBatch, long startOffsetToArchive, long endOffsetToArchive) {
        this.lock.writeLock().lock();
        try {
            boolean isAnyOffsetArchived = false;
            log.trace("Archiving offset tracked batch: {} for the share partition: {}-{}", new Object[]{inFlightBatch, this.groupId, this.topicIdPartition});
            for (Map.Entry offsetState : inFlightBatch.offsetState().entrySet()) {
                if ((Long)offsetState.getKey() < startOffsetToArchive) continue;
                if ((Long)offsetState.getKey() > endOffsetToArchive) break;
                if (((InFlightState)offsetState.getValue()).state != RecordState.AVAILABLE) continue;
                ((InFlightState)offsetState.getValue()).archive(SharePartition.EMPTY_MEMBER_ID);
                isAnyOffsetArchived = true;
            }
            boolean bl = isAnyOffsetArchived;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean archiveCompleteBatch(InFlightBatch inFlightBatch) {
        this.lock.writeLock().lock();
        try {
            log.trace("Archiving complete batch: {} for the share partition: {}-{}", new Object[]{inFlightBatch, this.groupId, this.topicIdPartition});
            if (inFlightBatch.batchState() == RecordState.AVAILABLE) {
                inFlightBatch.archiveBatch(SharePartition.EMPTY_MEMBER_ID);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return false;
    }

    boolean canAcquireRecords() {
        long numRecords;
        if (this.nextFetchOffset() != this.endOffset() + 1L) {
            return true;
        }
        this.lock.readLock().lock();
        try {
            numRecords = this.cachedState.isEmpty() ? 0L : this.endOffset - this.startOffset + 1L;
        }
        finally {
            this.lock.readLock().unlock();
        }
        return numRecords < (long)this.maxInFlightMessages;
    }

    boolean maybeAcquireFetchLock() {
        return this.fetchLock.compareAndSet(false, true);
    }

    void releaseFetchLock() {
        this.fetchLock.set(false);
    }

    private void initialize() {
        ReadShareGroupStateResult response;
        log.debug("Initializing share partition: {}-{}", (Object)this.groupId, (Object)this.topicIdPartition);
        try {
            response = (ReadShareGroupStateResult)this.persister.readState(new ReadShareGroupStateParameters.Builder().setGroupTopicPartitionData(new GroupTopicPartitionData.Builder().setGroupId(this.groupId).setTopicsData(Collections.singletonList(new TopicData(this.topicIdPartition.topicId(), Collections.singletonList(PartitionFactory.newPartitionIdLeaderEpochData((int)this.topicIdPartition.partition(), (int)0))))).build()).build()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Failed to initialize the share partition: {}-{}", new Object[]{this.groupId, this.topicIdPartition, e});
            throw new IllegalStateException(String.format("Failed to initialize the share partition %s-%s", this.groupId, this.topicIdPartition), e);
        }
        if (response == null || response.topicsData() == null || response.topicsData().size() != 1) {
            log.error("Failed to initialize the share partition: {}-{}. Invalid state found: {}.", new Object[]{this.groupId, this.topicIdPartition, response});
            throw new IllegalStateException(String.format("Failed to initialize the share partition %s-%s", this.groupId, this.topicIdPartition));
        }
        TopicData state = (TopicData)response.topicsData().get(0);
        if (state.topicId() != this.topicIdPartition.topicId() || state.partitions().size() != 1 || ((PartitionAllData)state.partitions().get(0)).partition() != this.topicIdPartition.partition()) {
            log.error("Failed to initialize the share partition: {}-{}. Invalid topic partition response: {}.", new Object[]{this.groupId, this.topicIdPartition, response});
            throw new IllegalStateException(String.format("Failed to initialize the share partition %s-%s", this.groupId, this.topicIdPartition));
        }
        PartitionAllData partitionData = (PartitionAllData)state.partitions().get(0);
        this.startOffset = partitionData.startOffset() != -1L ? partitionData.startOffset() : 0L;
        this.stateEpoch = partitionData.stateEpoch();
        List stateBatches = partitionData.stateBatches();
        for (PersisterStateBatch stateBatch : stateBatches) {
            if (stateBatch.firstOffset() < this.startOffset) {
                log.error("Invalid state batch found for the share partition: {}-{}. The base offset: {} is less than the start offset: {}.", new Object[]{this.groupId, this.topicIdPartition, stateBatch.firstOffset(), this.startOffset});
                throw new IllegalStateException(String.format("Failed to initialize the share partition %s-%s", this.groupId, this.topicIdPartition));
            }
            InFlightBatch inFlightBatch = new InFlightBatch(EMPTY_MEMBER_ID, stateBatch.firstOffset(), stateBatch.lastOffset(), RecordState.forId(stateBatch.deliveryState()), stateBatch.deliveryCount(), null);
            this.cachedState.put(stateBatch.firstOffset(), inFlightBatch);
        }
        if (!this.cachedState.isEmpty()) {
            this.findNextFetchOffset.set(true);
            this.endOffset = this.cachedState.lastEntry().getValue().lastOffset();
            this.maybeUpdateCachedStateAndOffsets();
        } else {
            this.endOffset = partitionData.startOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShareFetchResponseData.AcquiredRecords acquireNewBatchRecords(String memberId, long firstOffset, long lastOffset) {
        this.lock.writeLock().lock();
        try {
            AcquisitionLockTimerTask timerTask = this.scheduleAcquisitionLockTimeout(memberId, firstOffset, lastOffset);
            this.cachedState.put(firstOffset, new InFlightBatch(memberId, firstOffset, lastOffset, RecordState.ACQUIRED, 1, timerTask));
            if ((Long)this.cachedState.firstKey() == firstOffset) {
                this.startOffset = firstOffset;
            }
            this.endOffset = lastOffset;
            ShareFetchResponseData.AcquiredRecords acquiredRecords = new ShareFetchResponseData.AcquiredRecords().setFirstOffset(firstOffset).setLastOffset(lastOffset).setDeliveryCount((short)1);
            return acquiredRecords;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireSubsetBatchRecords(String memberId, long requestFirstOffset, long requestLastOffset, InFlightBatch inFlightBatch, List<ShareFetchResponseData.AcquiredRecords> result) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry offsetState : inFlightBatch.offsetState.entrySet()) {
                if ((Long)offsetState.getKey() < requestFirstOffset) continue;
                if ((Long)offsetState.getKey() > requestLastOffset) {
                    break;
                }
                if (((InFlightState)offsetState.getValue()).state != RecordState.AVAILABLE) {
                    log.trace("The offset is not available skipping, offset: {} batch: {} for the share group: {}-{}", new Object[]{offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition});
                    continue;
                }
                InFlightState updateResult = ((InFlightState)offsetState.getValue()).tryUpdateState(RecordState.ACQUIRED, true, this.maxDeliveryCount, memberId);
                if (updateResult == null) {
                    log.trace("Unable to acquire records for the offset: {} in batch: {} for the share group: {}-{}", new Object[]{offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition});
                    continue;
                }
                AcquisitionLockTimerTask acquisitionLockTimeoutTask = this.scheduleAcquisitionLockTimeout(memberId, (Long)offsetState.getKey(), (Long)offsetState.getKey());
                ((InFlightState)offsetState.getValue()).updateAcquisitionLockTimeoutTask(acquisitionLockTimeoutTask);
                result.add(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(((Long)offsetState.getKey()).longValue()).setLastOffset(((Long)offsetState.getKey()).longValue()).setDeliveryCount((short)((InFlightState)offsetState.getValue()).deliveryCount));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean checkForFullMatch(InFlightBatch inFlightBatch, long firstOffsetToCompare, long lastOffsetToCompare) {
        return inFlightBatch.firstOffset() >= firstOffsetToCompare && inFlightBatch.lastOffset() <= lastOffsetToCompare;
    }

    private boolean checkForStartOffsetWithinBatch(long batchFirstOffset, long batchLastOffset) {
        long localStartOffset = this.startOffset();
        return batchFirstOffset < localStartOffset && batchLastOffset >= localStartOffset;
    }

    private Map<Long, RecordState> fetchRecordStateMapForAcknowledgementBatch(ShareAcknowledgementBatch batch) {
        HashMap<Long, RecordState> recordStateMap = new HashMap<Long, RecordState>();
        for (int index = 0; index < batch.acknowledgeTypes().size(); ++index) {
            recordStateMap.put(batch.firstOffset() + (long)index, SharePartition.fetchRecordState((Byte)batch.acknowledgeTypes().get(index)));
        }
        return recordStateMap;
    }

    private static RecordState fetchRecordState(byte acknowledgeType) {
        switch (acknowledgeType) {
            case 1: {
                return RecordState.ACKNOWLEDGED;
            }
            case 2: {
                return RecordState.AVAILABLE;
            }
            case 0: 
            case 3: {
                return RecordState.ARCHIVED;
            }
        }
        throw new IllegalArgumentException("Invalid acknowledge type: " + acknowledgeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NavigableMap<Long, InFlightBatch> fetchSubMapForAcknowledgementBatch(ShareAcknowledgementBatch batch, boolean isLastBatch) {
        this.lock.writeLock().lock();
        try {
            NavigableMap<Long, InFlightBatch> subMap;
            Map.Entry<Long, InFlightBatch> floorOffset = this.cachedState.floorEntry(batch.firstOffset());
            if (floorOffset == null) {
                boolean hasStartOffsetMoved = this.checkForStartOffsetWithinBatch(batch.firstOffset(), batch.lastOffset());
                if (hasStartOffsetMoved) {
                    floorOffset = this.cachedState.floorEntry(this.startOffset);
                } else {
                    log.debug("Batch record {} not found for share partition: {}-{}", new Object[]{batch, this.groupId, this.topicIdPartition});
                    throw new InvalidRecordStateException("Batch record not found. The request batch offsets are not found in the cache.");
                }
            }
            if ((subMap = this.cachedState.subMap(floorOffset.getKey(), true, batch.lastOffset(), true)).lastEntry().getValue().lastOffset < batch.firstOffset()) {
                log.debug("Request batch: {} has offsets which are not found for share partition: {}-{}", new Object[]{batch, this.groupId, this.topicIdPartition});
                throw new InvalidRequestException("Batch record not found. The first offset in request is past acquired records.");
            }
            if (isLastBatch && batch.lastOffset() > subMap.lastEntry().getValue().lastOffset) {
                log.debug("Request batch: {} has offsets which are not found for share partition: {}-{}", new Object[]{batch, this.groupId, this.topicIdPartition});
                throw new InvalidRequestException("Batch record not found. The last offset in request is past acquired records.");
            }
            NavigableMap<Long, InFlightBatch> navigableMap = subMap;
            return navigableMap;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Throwable> acknowledgementBatchRecords(String memberId, ShareAcknowledgementBatch batch, Map<Long, RecordState> recordStateMap, NavigableMap<Long, InFlightBatch> subMap, List<InFlightState> updatedStates, List<PersisterStateBatch> stateBatches) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry entry : subMap.entrySet()) {
                Optional<Throwable> throwable;
                InFlightBatch inFlightBatch = (InFlightBatch)entry.getValue();
                if (inFlightBatch.lastOffset() < this.startOffset) {
                    log.trace("All offsets in the inflight batch {} are already archived: {}-{}", new Object[]{inFlightBatch, this.groupId, this.topicIdPartition});
                    continue;
                }
                if (inFlightBatch.offsetState() == null && (throwable = this.validateAcknowledgementBatchMemberId(memberId, inFlightBatch)).isPresent()) {
                    Optional<Throwable> optional = throwable;
                    return optional;
                }
                boolean fullMatch = this.checkForFullMatch(inFlightBatch, batch.firstOffset(), batch.lastOffset());
                boolean isPerOffsetClientAck = batch.acknowledgeTypes().size() > 1;
                boolean hasStartOffsetMoved = this.checkForStartOffsetWithinBatch(inFlightBatch.firstOffset(), inFlightBatch.lastOffset());
                if (!fullMatch || inFlightBatch.offsetState() != null || isPerOffsetClientAck || hasStartOffsetMoved) {
                    log.debug("Subset or offset tracked batch record found for acknowledgement, batch: {}, request offsets - first: {}, last: {}, client per offsetstate {} for the share partition: {}-{}", new Object[]{inFlightBatch, batch.firstOffset(), batch.lastOffset(), isPerOffsetClientAck, this.groupId, this.topicIdPartition});
                    if (inFlightBatch.offsetState() == null) {
                        if (inFlightBatch.batchState() != RecordState.ACQUIRED) {
                            log.debug("The batch is not in the acquired state: {} for share partition: {}-{}", new Object[]{inFlightBatch, this.groupId, this.topicIdPartition});
                            Optional<Throwable> optional = Optional.of(new InvalidRecordStateException("The batch cannot be acknowledged. The subset batch is not in the acquired state."));
                            return optional;
                        }
                        inFlightBatch.maybeInitializeOffsetStateUpdate();
                    }
                    throwable = this.acknowledgePerOffsetBatchRecords(memberId, batch, inFlightBatch, recordStateMap, updatedStates, stateBatches);
                } else {
                    throwable = this.acknowledgeCompleteBatch(batch, inFlightBatch, recordStateMap.get(batch.firstOffset()), updatedStates, stateBatches);
                }
                if (!throwable.isPresent()) continue;
                Optional<Throwable> optional = throwable;
                return optional;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return Optional.empty();
    }

    private Optional<Throwable> validateAcknowledgementBatchMemberId(String memberId, InFlightBatch inFlightBatch) {
        if (inFlightBatch.batchMemberId().equals(EMPTY_MEMBER_ID)) {
            log.debug("The batch is not in the acquired state: {} for share partition: {}-{}. Empty member id for batch.", new Object[]{inFlightBatch, this.groupId, this.topicIdPartition});
            return Optional.of(new InvalidRecordStateException("The batch cannot be acknowledged. The batch is not in the acquired state."));
        }
        if (!inFlightBatch.batchMemberId().equals(memberId)) {
            log.debug("Member {} is not the owner of batch record {} for share partition: {}-{}", new Object[]{memberId, inFlightBatch, this.groupId, this.topicIdPartition});
            return Optional.of(new InvalidRecordStateException("Member is not the owner of batch record"));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Throwable> acknowledgePerOffsetBatchRecords(String memberId, ShareAcknowledgementBatch batch, InFlightBatch inFlightBatch, Map<Long, RecordState> recordStateMap, List<InFlightState> updatedStates, List<PersisterStateBatch> stateBatches) {
        this.lock.writeLock().lock();
        try {
            RecordState recordStateDefault = recordStateMap.get(batch.firstOffset());
            for (Map.Entry offsetState : inFlightBatch.offsetState.entrySet()) {
                Optional<Throwable> optional;
                if ((Long)offsetState.getKey() < batch.firstOffset() || (Long)offsetState.getKey() < this.startOffset) continue;
                if ((Long)offsetState.getKey() > batch.lastOffset()) {
                    break;
                }
                if (((InFlightState)offsetState.getValue()).state != RecordState.ACQUIRED) {
                    log.debug("The offset is not acquired, offset: {} batch: {} for the share partition: {}-{}", new Object[]{offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition});
                    optional = Optional.of(new InvalidRecordStateException("The batch cannot be acknowledged. The offset is not acquired."));
                    return optional;
                }
                if (!((InFlightState)offsetState.getValue()).memberId.equals(memberId)) {
                    log.debug("Member {} is not the owner of offset: {} in batch: {} for the share partition: {}-{}", new Object[]{memberId, offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition});
                    optional = Optional.of(new InvalidRecordStateException("Member is not the owner of offset"));
                    return optional;
                }
                RecordState recordState = recordStateMap.size() > 1 ? recordStateMap.get(offsetState.getKey()) : recordStateDefault;
                InFlightState updateResult = ((InFlightState)offsetState.getValue()).startStateTransition(recordState, false, this.maxDeliveryCount, SharePartition.EMPTY_MEMBER_ID);
                if (updateResult == null) {
                    log.debug("Unable to acknowledge records for the offset: {} in batch: {} for the share partition: {}-{}", new Object[]{offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition});
                    Optional<Throwable> optional2 = Optional.of(new InvalidRecordStateException("Unable to acknowledge records for the batch"));
                    return optional2;
                }
                updatedStates.add(updateResult);
                stateBatches.add(new PersisterStateBatch(((Long)offsetState.getKey()).longValue(), ((Long)offsetState.getKey()).longValue(), ((InFlightState)updateResult).state.id, (short)updateResult.deliveryCount));
                if (recordState != RecordState.AVAILABLE || updateResult.state == RecordState.ARCHIVED) continue;
                this.findNextFetchOffset.set(true);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Throwable> acknowledgeCompleteBatch(ShareAcknowledgementBatch batch, InFlightBatch inFlightBatch, RecordState recordState, List<InFlightState> updatedStates, List<PersisterStateBatch> stateBatches) {
        this.lock.writeLock().lock();
        try {
            log.trace("Acknowledging complete batch record {} for the share partition: {}-{}", new Object[]{batch, this.groupId, this.topicIdPartition});
            if (inFlightBatch.batchState() != RecordState.ACQUIRED) {
                log.debug("The batch is not in the acquired state: {} for share partition: {}-{}", new Object[]{inFlightBatch, this.groupId, this.topicIdPartition});
                Optional<Throwable> optional = Optional.of(new InvalidRecordStateException("The batch cannot be acknowledged. The batch is not in the acquired state."));
                return optional;
            }
            InFlightState updateResult = inFlightBatch.startBatchStateTransition(recordState, false, this.maxDeliveryCount, SharePartition.EMPTY_MEMBER_ID);
            if (updateResult == null) {
                log.debug("Unable to acknowledge records for the batch: {} with state: {} for the share partition: {}-{}", new Object[]{inFlightBatch, recordState, this.groupId, this.topicIdPartition});
                Optional<Throwable> optional = Optional.of(new InvalidRecordStateException("Unable to acknowledge records for the batch"));
                return optional;
            }
            updatedStates.add(updateResult);
            stateBatches.add(new PersisterStateBatch(inFlightBatch.firstOffset, inFlightBatch.lastOffset, ((InFlightState)updateResult).state.id, (short)updateResult.deliveryCount));
            if (recordState == RecordState.AVAILABLE && updateResult.state != RecordState.ARCHIVED) {
                this.findNextFetchOffset.set(true);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackOrProcessStateUpdates(Throwable throwable, List<InFlightState> updatedStates, List<PersisterStateBatch> stateBatches) {
        if (stateBatches.isEmpty() && updatedStates.isEmpty()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (throwable != null || !this.isWriteShareGroupStateSuccessful(stateBatches)) {
                log.debug("Request failed for updating state, rollback any changed state for the share partition: {}-{}", (Object)this.groupId, (Object)this.topicIdPartition);
                updatedStates.forEach(state -> ((InFlightState)state).completeStateTransition(false));
            } else {
                log.trace("State change request successful for share partition: {}-{}", (Object)this.groupId, (Object)this.topicIdPartition);
                updatedStates.forEach(state -> {
                    ((InFlightState)state).completeStateTransition(true);
                    state.cancelAndClearAcquisitionLockTimeoutTask();
                });
                this.maybeUpdateCachedStateAndOffsets();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeUpdateCachedStateAndOffsets() {
        this.lock.writeLock().lock();
        try {
            long lastKeyToRemove;
            if (!this.canMoveStartOffset()) {
                return;
            }
            long lastOffsetAcknowledged = this.findLastOffsetAcknowledged();
            if (lastOffsetAcknowledged == -1L) {
                return;
            }
            long lastCachedOffset = this.cachedState.lastEntry().getValue().lastOffset();
            if (lastOffsetAcknowledged == lastCachedOffset) {
                this.startOffset = lastCachedOffset + 1L;
                this.endOffset = lastCachedOffset + 1L;
                this.cachedState.clear();
                return;
            }
            long firstKeyToRemove = (Long)this.cachedState.firstKey();
            Map.Entry<Long, InFlightBatch> entry = this.cachedState.floorEntry(lastOffsetAcknowledged);
            if (lastOffsetAcknowledged == entry.getValue().lastOffset()) {
                this.startOffset = this.cachedState.higherKey(lastOffsetAcknowledged);
                lastKeyToRemove = entry.getKey();
            } else {
                this.startOffset = lastOffsetAcknowledged + 1L;
                lastKeyToRemove = entry.getKey().equals(this.cachedState.firstKey()) ? -1L : this.cachedState.lowerKey(entry.getKey());
            }
            if (lastKeyToRemove != -1L) {
                NavigableMap<Long, InFlightBatch> subMap = this.cachedState.subMap(firstKeyToRemove, true, lastKeyToRemove, true);
                for (Long key : subMap.keySet()) {
                    this.cachedState.remove(key);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean canMoveStartOffset() {
        if (this.cachedState.isEmpty()) {
            return false;
        }
        Map.Entry<Long, InFlightBatch> entry = this.cachedState.floorEntry(this.startOffset);
        if (entry == null) {
            log.error("The start offset: {} is not found in the cached state for share partition: {}-{}. Cannot move the start offset.", new Object[]{this.startOffset, this.groupId, this.topicIdPartition});
            return false;
        }
        RecordState startOffsetState = entry.getValue().offsetState == null ? entry.getValue().batchState() : ((InFlightState)entry.getValue().offsetState().get(this.startOffset)).state();
        return this.isRecordStateAcknowledged(startOffsetState);
    }

    private boolean isRecordStateAcknowledged(RecordState recordState) {
        return recordState == RecordState.ACKNOWLEDGED || recordState == RecordState.ARCHIVED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findLastOffsetAcknowledged() {
        this.lock.readLock().lock();
        long lastOffsetAcknowledged = -1L;
        try {
            for (Map.Entry entry : this.cachedState.entrySet()) {
                InFlightBatch inFlightBatch = (InFlightBatch)entry.getValue();
                if (inFlightBatch.offsetState() == null) {
                    if (!this.isRecordStateAcknowledged(inFlightBatch.batchState())) {
                        long l = lastOffsetAcknowledged;
                        return l;
                    }
                    lastOffsetAcknowledged = inFlightBatch.lastOffset();
                    continue;
                }
                for (Map.Entry offsetState : inFlightBatch.offsetState.entrySet()) {
                    if (!this.isRecordStateAcknowledged(((InFlightState)offsetState.getValue()).state())) {
                        long l = lastOffsetAcknowledged;
                        return l;
                    }
                    lastOffsetAcknowledged = (Long)offsetState.getKey();
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return lastOffsetAcknowledged;
    }

    boolean isWriteShareGroupStateSuccessful(List<PersisterStateBatch> stateBatches) {
        WriteShareGroupStateResult response;
        try {
            response = (WriteShareGroupStateResult)this.persister.writeState(new WriteShareGroupStateParameters.Builder().setGroupTopicPartitionData(new GroupTopicPartitionData.Builder().setGroupId(this.groupId).setTopicsData(Collections.singletonList(new TopicData(this.topicIdPartition.topicId(), Collections.singletonList(PartitionFactory.newPartitionStateBatchData((int)this.topicIdPartition.partition(), (int)this.stateEpoch, (long)this.startOffset, (int)0, stateBatches))))).build()).build()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Failed to write the share group state for share partition: {}-{}", new Object[]{this.groupId, this.topicIdPartition, e});
            throw new IllegalStateException(String.format("Failed to write the share group state for share partition %s-%s", this.groupId, this.topicIdPartition), e);
        }
        if (response == null || response.topicsData() == null || response.topicsData().size() != 1) {
            log.error("Failed to write the share group state for share partition: {}-{}. Invalid state found: {}", new Object[]{this.groupId, this.topicIdPartition, response});
            throw new IllegalStateException(String.format("Failed to write the share group state for share partition %s-%s", this.groupId, this.topicIdPartition));
        }
        TopicData state = (TopicData)response.topicsData().get(0);
        if (state.topicId() != this.topicIdPartition.topicId() || state.partitions().size() != 1 || ((PartitionErrorData)state.partitions().get(0)).partition() != this.topicIdPartition.partition()) {
            log.error("Failed to write the share group state for share partition: {}-{}. Invalid topic partition response: {}", new Object[]{this.groupId, this.topicIdPartition, response});
            throw new IllegalStateException(String.format("Failed to write the share group state for share partition %s-%s", this.groupId, this.topicIdPartition));
        }
        PartitionErrorData partitionData = (PartitionErrorData)state.partitions().get(0);
        if (partitionData.errorCode() != Errors.NONE.code()) {
            ApiException exception = Errors.forCode((short)partitionData.errorCode()).exception(partitionData.errorMessage());
            log.error("Failed to write the share group state for share partition: {}-{} due to exception", new Object[]{this.groupId, this.topicIdPartition, exception});
            return false;
        }
        return true;
    }

    private AcquisitionLockTimerTask scheduleAcquisitionLockTimeout(String memberId, long firstOffset, long lastOffset) {
        return this.scheduleAcquisitionLockTimeout(memberId, firstOffset, lastOffset, this.recordLockDurationMs);
    }

    private AcquisitionLockTimerTask scheduleAcquisitionLockTimeout(String memberId, long firstOffset, long lastOffset, long delayMs) {
        AcquisitionLockTimerTask acquistionLockTimerTask = this.acquisitionLockTimerTask(memberId, firstOffset, lastOffset, delayMs);
        this.timer.add((TimerTask)acquistionLockTimerTask);
        return acquistionLockTimerTask;
    }

    private AcquisitionLockTimerTask acquisitionLockTimerTask(String memberId, long firstOffset, long lastOffset, long delayMs) {
        return new AcquisitionLockTimerTask(delayMs, memberId, firstOffset, lastOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAcquisitionLockOnTimeout(String memberId, long firstOffset, long lastOffset) {
        this.lock.writeLock().lock();
        try {
            Map.Entry<Long, InFlightBatch> floorOffset = this.cachedState.floorEntry(firstOffset);
            if (floorOffset == null) {
                log.error("Base offset {} not found for share partition: {}-{}", new Object[]{firstOffset, this.groupId, this.topicIdPartition});
                return;
            }
            ArrayList<PersisterStateBatch> stateBatches = new ArrayList<PersisterStateBatch>();
            NavigableMap<Long, InFlightBatch> subMap = this.cachedState.subMap(floorOffset.getKey(), true, lastOffset, true);
            for (Map.Entry entry : subMap.entrySet()) {
                InFlightBatch inFlightBatch = (InFlightBatch)entry.getValue();
                if (inFlightBatch.offsetState() == null && inFlightBatch.batchState() == RecordState.ACQUIRED && this.checkForStartOffsetWithinBatch(inFlightBatch.firstOffset(), inFlightBatch.lastOffset())) {
                    inFlightBatch.maybeInitializeOffsetStateUpdate();
                }
                if (inFlightBatch.offsetState() == null) {
                    this.releaseAcquisitionLockOnTimeoutForCompleteBatch(inFlightBatch, stateBatches, memberId);
                    continue;
                }
                this.releaseAcquisitionLockOnTimeoutForPerOffsetBatch(inFlightBatch, stateBatches, memberId, firstOffset, lastOffset);
            }
            if (!stateBatches.isEmpty() && !this.isWriteShareGroupStateSuccessful(stateBatches)) {
                log.error("Failed to write the share group state on acquisition lock timeout for share partition: {}-{} memberId {}. Proceeding with state transition.", new Object[]{this.groupId, this.topicIdPartition, memberId});
            }
            this.maybeUpdateCachedStateAndOffsets();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void releaseAcquisitionLockOnTimeoutForCompleteBatch(InFlightBatch inFlightBatch, List<PersisterStateBatch> stateBatches, String memberId) {
        if (inFlightBatch.batchState() == RecordState.ACQUIRED) {
            InFlightState updateResult = inFlightBatch.tryUpdateBatchState(inFlightBatch.lastOffset() < this.startOffset ? RecordState.ARCHIVED : RecordState.AVAILABLE, false, this.maxDeliveryCount, SharePartition.EMPTY_MEMBER_ID);
            if (updateResult == null) {
                log.error("Unable to release acquisition lock on timeout for the batch: {} for the share partition: {}-{} memberId: {}", new Object[]{inFlightBatch, this.groupId, this.topicIdPartition, memberId});
                return;
            }
            stateBatches.add(new PersisterStateBatch(inFlightBatch.firstOffset(), inFlightBatch.lastOffset(), ((InFlightState)updateResult).state.id, (short)updateResult.deliveryCount));
            updateResult.updateAcquisitionLockTimeoutTask(null);
            if (updateResult.state != RecordState.ARCHIVED) {
                this.findNextFetchOffset.set(true);
            }
            return;
        }
        log.debug("The batch is not in acquired state while release of acquisition lock on timeout, skipping, batch: {} for the share group: {}-{}-{}", new Object[]{inFlightBatch, this.groupId, memberId, this.topicIdPartition});
    }

    private void releaseAcquisitionLockOnTimeoutForPerOffsetBatch(InFlightBatch inFlightBatch, List<PersisterStateBatch> stateBatches, String memberId, long firstOffset, long lastOffset) {
        for (Map.Entry offsetState : inFlightBatch.offsetState().entrySet()) {
            if ((Long)offsetState.getKey() < firstOffset) continue;
            if ((Long)offsetState.getKey() > lastOffset) break;
            if (((InFlightState)offsetState.getValue()).state != RecordState.ACQUIRED) {
                log.debug("The offset is not in acquired state while release of acquisition lock on timeout, skipping, offset: {} batch: {} for the share group: {}-{} memberId: {}", new Object[]{offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition, memberId});
                continue;
            }
            InFlightState updateResult = ((InFlightState)offsetState.getValue()).tryUpdateState((Long)offsetState.getKey() < this.startOffset ? RecordState.ARCHIVED : RecordState.AVAILABLE, false, this.maxDeliveryCount, SharePartition.EMPTY_MEMBER_ID);
            if (updateResult == null) {
                log.error("Unable to release acquisition lock on timeout for the offset: {} in batch: {} for the share group: {}-{} memberId: {}", new Object[]{offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition, memberId});
                continue;
            }
            stateBatches.add(new PersisterStateBatch(((Long)offsetState.getKey()).longValue(), ((Long)offsetState.getKey()).longValue(), ((InFlightState)updateResult).state.id, (short)updateResult.deliveryCount));
            updateResult.updateAcquisitionLockTimeoutTask(null);
            if (updateResult.state == RecordState.ARCHIVED) continue;
            this.findNextFetchOffset.set(true);
        }
    }

    NavigableMap<Long, InFlightBatch> cachedState() {
        return new ConcurrentSkipListMap<Long, InFlightBatch>((SortedMap<Long, InFlightBatch>)this.cachedState);
    }

    boolean findNextFetchOffset() {
        return this.findNextFetchOffset.get();
    }

    void findNextFetchOffset(boolean findNextOffset) {
        this.findNextFetchOffset.getAndSet(findNextOffset);
    }

    long startOffset() {
        this.lock.readLock().lock();
        try {
            long l = this.startOffset;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    long endOffset() {
        this.lock.readLock().lock();
        try {
            long l = this.endOffset;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    int stateEpoch() {
        return this.stateEpoch;
    }

    Timer timer() {
        return this.timer;
    }

    static final class InFlightState {
        private RecordState state;
        private int deliveryCount;
        private String memberId;
        private InFlightState rollbackState;
        private AcquisitionLockTimerTask acquisitionLockTimeoutTask;

        InFlightState(RecordState state, int deliveryCount, String memberId) {
            this(state, deliveryCount, memberId, null);
        }

        InFlightState(RecordState state, int deliveryCount, String memberId, AcquisitionLockTimerTask acquisitionLockTimeoutTask) {
            this.state = state;
            this.deliveryCount = deliveryCount;
            this.memberId = memberId;
            this.acquisitionLockTimeoutTask = acquisitionLockTimeoutTask;
        }

        RecordState state() {
            return this.state;
        }

        String memberId() {
            return this.memberId;
        }

        TimerTask acquisitionLockTimeoutTask() {
            return this.acquisitionLockTimeoutTask;
        }

        void updateAcquisitionLockTimeoutTask(AcquisitionLockTimerTask acquisitionLockTimeoutTask) {
            this.acquisitionLockTimeoutTask = acquisitionLockTimeoutTask;
        }

        void cancelAndClearAcquisitionLockTimeoutTask() {
            this.acquisitionLockTimeoutTask.cancel();
            this.acquisitionLockTimeoutTask = null;
        }

        private InFlightState tryUpdateState(RecordState newState, boolean incrementDeliveryCount, int maxDeliveryCount, String newMemberId) {
            try {
                if (newState == RecordState.AVAILABLE && this.deliveryCount >= maxDeliveryCount) {
                    newState = RecordState.ARCHIVED;
                }
                this.state = this.state.validateTransition(newState);
                if (incrementDeliveryCount && newState != RecordState.ARCHIVED) {
                    ++this.deliveryCount;
                }
                this.memberId = newMemberId;
                return this;
            }
            catch (IllegalStateException e) {
                log.error("Failed to update state of the records", (Throwable)e);
                return null;
            }
        }

        private void archive(String newMemberId) {
            this.state = RecordState.ARCHIVED;
            this.memberId = newMemberId;
        }

        private InFlightState startStateTransition(RecordState newState, boolean incrementDeliveryCount, int maxDeliveryCount, String newMemberId) {
            this.rollbackState = new InFlightState(this.state, this.deliveryCount, this.memberId, this.acquisitionLockTimeoutTask);
            return this.tryUpdateState(newState, incrementDeliveryCount, maxDeliveryCount, newMemberId);
        }

        private void completeStateTransition(boolean commit) {
            if (commit) {
                this.rollbackState = null;
                return;
            }
            this.state = this.rollbackState.state;
            this.deliveryCount = this.rollbackState.deliveryCount;
            this.memberId = this.rollbackState.memberId;
            this.rollbackState = null;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state, this.deliveryCount, this.memberId});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InFlightState that = (InFlightState)o;
            return this.state == that.state && this.deliveryCount == that.deliveryCount && this.memberId.equals(that.memberId);
        }

        public String toString() {
            return "InFlightState(state=" + this.state.toString() + ", deliveryCount=" + this.deliveryCount + ", memberId=" + this.memberId + ")";
        }
    }

    final class InFlightBatch {
        private final long firstOffset;
        private final long lastOffset;
        private InFlightState batchState;
        private NavigableMap<Long, InFlightState> offsetState;

        InFlightBatch(String memberId, long firstOffset, long lastOffset, RecordState state, int deliveryCount, AcquisitionLockTimerTask acquisitionLockTimeoutTask) {
            this.firstOffset = firstOffset;
            this.lastOffset = lastOffset;
            this.batchState = new InFlightState(state, deliveryCount, memberId, acquisitionLockTimeoutTask);
        }

        long firstOffset() {
            return this.firstOffset;
        }

        long lastOffset() {
            return this.lastOffset;
        }

        RecordState batchState() {
            if (this.batchState == null) {
                throw new IllegalStateException("The batch state is not available as the offset state is maintained");
            }
            return this.batchState.state;
        }

        String batchMemberId() {
            if (this.batchState == null) {
                throw new IllegalStateException("The batch member id is not available as the offset state is maintained");
            }
            return this.batchState.memberId;
        }

        int batchDeliveryCount() {
            if (this.batchState == null) {
                throw new IllegalStateException("The batch delivery count is not available as the offset state is maintained");
            }
            return this.batchState.deliveryCount;
        }

        AcquisitionLockTimerTask batchAcquisitionLockTimeoutTask() {
            if (this.batchState == null) {
                throw new IllegalStateException("The batch state is not available as the offset state is maintained");
            }
            return this.batchState.acquisitionLockTimeoutTask;
        }

        NavigableMap<Long, InFlightState> offsetState() {
            return this.offsetState;
        }

        private void archiveBatch(String newMemberId) {
            if (this.batchState == null) {
                throw new IllegalStateException("The batch state is not available as the offset state is maintained");
            }
            this.batchState.archive(newMemberId);
        }

        private InFlightState tryUpdateBatchState(RecordState newState, boolean incrementDeliveryCount, int maxDeliveryCount, String newMemberId) {
            if (this.batchState == null) {
                throw new IllegalStateException("The batch state update is not available as the offset state is maintained");
            }
            return this.batchState.tryUpdateState(newState, incrementDeliveryCount, maxDeliveryCount, newMemberId);
        }

        private InFlightState startBatchStateTransition(RecordState newState, boolean incrementDeliveryCount, int maxDeliveryCount, String newMemberId) {
            if (this.batchState == null) {
                throw new IllegalStateException("The batch state update is not available as the offset state is maintained");
            }
            return this.batchState.startStateTransition(newState, incrementDeliveryCount, maxDeliveryCount, newMemberId);
        }

        private void maybeInitializeOffsetStateUpdate() {
            if (this.offsetState == null) {
                this.offsetState = new ConcurrentSkipListMap<Long, InFlightState>();
                for (long offset = this.firstOffset; offset <= this.lastOffset; ++offset) {
                    if (this.batchState.acquisitionLockTimeoutTask != null) {
                        long delayMs = this.batchState.acquisitionLockTimeoutTask.expirationMs() - SharePartition.this.time.hiResClockMs();
                        AcquisitionLockTimerTask timerTask = SharePartition.this.acquisitionLockTimerTask(this.batchState.memberId, offset, offset, delayMs);
                        this.offsetState.put(offset, new InFlightState(this.batchState.state, this.batchState.deliveryCount, this.batchState.memberId, timerTask));
                        SharePartition.this.timer.add((TimerTask)timerTask);
                        continue;
                    }
                    this.offsetState.put(offset, new InFlightState(this.batchState.state, this.batchState.deliveryCount, this.batchState.memberId));
                }
                if (this.batchState.acquisitionLockTimeoutTask != null) {
                    this.batchState.cancelAndClearAcquisitionLockTimeoutTask();
                }
                this.batchState = null;
            }
        }

        private void updateAcquisitionLockTimeout(AcquisitionLockTimerTask acquisitionLockTimeoutTask) {
            if (this.batchState == null) {
                throw new IllegalStateException("The batch state is not available as the offset state is maintained");
            }
            this.batchState.acquisitionLockTimeoutTask = acquisitionLockTimeoutTask;
        }

        public String toString() {
            return "InFlightBatch(firstOffset=" + this.firstOffset + ", lastOffset=" + this.lastOffset + ", inFlightState=" + this.batchState + ", offsetState=" + (this.offsetState == null ? "null" : this.offsetState) + ")";
        }
    }

    private final class AcquisitionLockTimerTask
    extends TimerTask {
        private final long expirationMs;
        private final String memberId;
        private final long firstOffset;
        private final long lastOffset;

        AcquisitionLockTimerTask(long delayMs, String memberId, long firstOffset, long lastOffset) {
            super(delayMs);
            this.expirationMs = SharePartition.this.time.hiResClockMs() + delayMs;
            this.memberId = memberId;
            this.firstOffset = firstOffset;
            this.lastOffset = lastOffset;
        }

        long expirationMs() {
            return this.expirationMs;
        }

        public void run() {
            SharePartition.this.releaseAcquisitionLockOnTimeout(this.memberId, this.firstOffset, this.lastOffset);
        }
    }

    static enum RecordState {
        AVAILABLE(0),
        ACQUIRED(1),
        ACKNOWLEDGED(2),
        ARCHIVED(4);

        public final byte id;

        private RecordState(byte id) {
            this.id = id;
        }

        public RecordState validateTransition(RecordState newState) throws IllegalStateException {
            Objects.requireNonNull(newState, "newState cannot be null");
            if (this == newState) {
                throw new IllegalStateException("The state transition is invalid as the new state isthe same as the current state");
            }
            if (this == ACKNOWLEDGED || this == ARCHIVED) {
                throw new IllegalStateException("The state transition is invalid from the current state: " + (Object)((Object)this));
            }
            if (this == AVAILABLE && newState != ACQUIRED) {
                throw new IllegalStateException("The state can only be transitioned to ACQUIRED from AVAILABLE");
            }
            return newState;
        }

        public static RecordState forId(byte id) {
            switch (id) {
                case 0: {
                    return AVAILABLE;
                }
                case 1: {
                    return ACQUIRED;
                }
                case 2: {
                    return ACKNOWLEDGED;
                }
                case 4: {
                    return ARCHIVED;
                }
            }
            throw new IllegalArgumentException("Unknown record state id: " + id);
        }
    }
}

