/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.rest.arg.CookieList;
import org.apache.juneau.rest.arg.SimpleRestOperationArg;

public class HttpServletRequestArgs
extends SimpleRestOperationArg {
    public static HttpServletRequestArgs create(ParameterInfo paramInfo) {
        if (paramInfo.isType(AsyncContext.class)) {
            return new HttpServletRequestArgs(ServletRequest::getAsyncContext);
        }
        if (paramInfo.isType(CookieList.class)) {
            return new HttpServletRequestArgs(x -> CookieList.of(x.getCookies()));
        }
        if (paramInfo.isType(DispatcherType.class)) {
            return new HttpServletRequestArgs(ServletRequest::getDispatcherType);
        }
        if (paramInfo.isType(HttpServletRequest.class)) {
            return new HttpServletRequestArgs(x -> x);
        }
        if (paramInfo.isType(Principal.class)) {
            return new HttpServletRequestArgs(HttpServletRequest::getUserPrincipal);
        }
        return null;
    }

    protected <T> HttpServletRequestArgs(ThrowingFunction<HttpServletRequest, T> function) {
        super(session -> function.apply((Object)session.getRequest().getHttpServletRequest()));
    }
}

