/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.openapi3.Callback;
import org.apache.juneau.bean.openapi3.ExternalDocumentation;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.bean.openapi3.Parameter;
import org.apache.juneau.bean.openapi3.RequestBodyInfo;
import org.apache.juneau.bean.openapi3.Response;
import org.apache.juneau.bean.openapi3.SecurityRequirement;
import org.apache.juneau.bean.openapi3.Server;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Operation
extends OpenApiElement {
    private List<String> tags = CollectionUtils.list((Object[])new String[0]);
    private String summary;
    private String description;
    private String operationId;
    private ExternalDocumentation externalDocs;
    private List<Parameter> parameters = CollectionUtils.list((Object[])new Parameter[0]);
    private RequestBodyInfo requestBody;
    private Map<String, Response> responses = CollectionUtils.map();
    private Map<String, Callback> callbacks = CollectionUtils.map();
    private Boolean deprecated;
    private List<SecurityRequirement> security = CollectionUtils.list((Object[])new SecurityRequirement[0]);
    private List<Server> servers = CollectionUtils.list((Object[])new Server[0]);

    public Operation() {
    }

    public Operation(Operation copyFrom) {
        super(copyFrom);
        if (Utils.nn(copyFrom.tags)) {
            this.tags.addAll(copyFrom.tags);
        }
        this.summary = copyFrom.summary;
        this.description = copyFrom.description;
        this.operationId = copyFrom.operationId;
        this.externalDocs = copyFrom.externalDocs;
        if (Utils.nn(copyFrom.parameters)) {
            this.parameters.addAll(CollectionUtils.copyOf(copyFrom.parameters, Parameter::copy));
        }
        this.requestBody = copyFrom.requestBody;
        if (Utils.nn(copyFrom.responses)) {
            this.responses.putAll(copyFrom.responses);
        }
        if (Utils.nn(copyFrom.callbacks)) {
            this.callbacks.putAll(copyFrom.callbacks);
        }
        this.deprecated = copyFrom.deprecated;
        if (Utils.nn(copyFrom.security)) {
            this.security.addAll(CollectionUtils.copyOf(copyFrom.security, SecurityRequirement::copy));
        }
        if (Utils.nn(copyFrom.servers)) {
            this.servers.addAll(CollectionUtils.copyOf(copyFrom.servers, Server::copy));
        }
    }

    public Operation addCallback(String name, Callback callback) {
        AssertionUtils.assertArgNotNull((String)"name", (Object)name);
        AssertionUtils.assertArgNotNull((String)"callback", (Object)callback);
        this.callbacks.put(name, callback);
        return this;
    }

    public Operation addParameters(Collection<Parameter> values) {
        if (Utils.nn(values)) {
            this.parameters.addAll(values);
        }
        return this;
    }

    public Operation addParameters(Parameter ... values) {
        if (Utils.nn((Object)values)) {
            for (Parameter v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.parameters.add(v);
            }
        }
        return this;
    }

    public Operation addResponse(String statusCode, Response response) {
        AssertionUtils.assertArgNotNull((String)"statusCode", (Object)statusCode);
        AssertionUtils.assertArgNotNull((String)"response", (Object)response);
        this.responses.put(statusCode, response);
        return this;
    }

    public Operation addSecurity(Collection<SecurityRequirement> values) {
        if (Utils.nn(values)) {
            this.security.addAll(values);
        }
        return this;
    }

    public Operation addSecurity(SecurityRequirement ... values) {
        if (Utils.nn((Object)values)) {
            for (SecurityRequirement v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.security.add(v);
            }
        }
        return this;
    }

    public Operation addServers(Collection<Server> values) {
        if (Utils.nn(values)) {
            this.servers.addAll(values);
        }
        return this;
    }

    public Operation addServers(Server ... values) {
        if (Utils.nn((Object)values)) {
            for (Server v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.servers.add(v);
            }
        }
        return this;
    }

    public Operation addTags(Collection<String> values) {
        if (Utils.nn(values)) {
            this.tags.addAll(values);
        }
        return this;
    }

    public Operation addTags(String ... values) {
        if (Utils.nn((Object)values)) {
            for (String v : values) {
                if (!Utils.nn((Object)v)) continue;
                this.tags.add(v);
            }
        }
        return this;
    }

    public Operation copy() {
        return new Operation(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "tags" -> ConverterUtils.toType(this.getTags(), type);
            case "summary" -> ConverterUtils.toType((Object)this.getSummary(), type);
            case "description" -> ConverterUtils.toType((Object)this.getDescription(), type);
            case "operationId" -> ConverterUtils.toType((Object)this.getOperationId(), type);
            case "externalDocs" -> ConverterUtils.toType((Object)this.getExternalDocs(), type);
            case "parameters" -> ConverterUtils.toType(this.getParameters(), type);
            case "requestBody" -> ConverterUtils.toType((Object)this.getRequestBody(), type);
            case "responses" -> ConverterUtils.toType(this.getResponses(), type);
            case "callbacks" -> ConverterUtils.toType(this.getCallbacks(), type);
            case "deprecated" -> ConverterUtils.toType((Object)this.getDeprecated(), type);
            case "security" -> ConverterUtils.toType(this.getSecurity(), type);
            case "servers" -> ConverterUtils.toType(this.getServers(), type);
            default -> super.get(property, type);
        });
    }

    public Map<String, Callback> getCallbacks() {
        return Utils.nullIfEmpty(this.callbacks);
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public Parameter getParameter(String in, String name) {
        AssertionUtils.assertArgNotNull((String)"in", (Object)in);
        AssertionUtils.assertArgNotNull((String)"name", (Object)name);
        for (Parameter p : this.parameters) {
            if (!Utils.eq((Object)p.getIn(), (Object)in) || !Utils.eq((Object)p.getName(), (Object)name)) continue;
            return p;
        }
        return null;
    }

    public List<Parameter> getParameters() {
        return Utils.nullIfEmpty(this.parameters);
    }

    public RequestBodyInfo getRequestBody() {
        return this.requestBody;
    }

    public Response getResponse(int status) {
        return this.getResponse(String.valueOf(status));
    }

    public Response getResponse(String status) {
        AssertionUtils.assertArgNotNull((String)"status", (Object)status);
        return this.responses.get(status);
    }

    public Map<String, Response> getResponses() {
        return Utils.nullIfEmpty(this.responses);
    }

    public List<SecurityRequirement> getSecurity() {
        return Utils.nullIfEmpty(this.security);
    }

    public List<Server> getServers() {
        return Utils.nullIfEmpty(this.servers);
    }

    public String getSummary() {
        return this.summary;
    }

    public List<String> getTags() {
        return Utils.nullIfEmpty(this.tags);
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.ne(this.callbacks), (Object)"callbacks").addIf(Utils.nn((Object)this.deprecated), (Object)"deprecated").addIf(Utils.nn((Object)this.description), (Object)"description").addIf(Utils.nn((Object)this.externalDocs), (Object)"externalDocs").addIf(Utils.nn((Object)this.operationId), (Object)"operationId").addIf(Utils.ne(this.parameters), (Object)"parameters").addIf(Utils.nn((Object)this.requestBody), (Object)"requestBody").addIf(Utils.ne(this.responses), (Object)"responses").addIf(Utils.ne(this.security), (Object)"security").addIf(Utils.ne(this.servers), (Object)"servers").addIf(Utils.nn((Object)this.summary), (Object)"summary").addIf(Utils.ne(this.tags), (Object)"tags").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public Operation set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "callbacks" -> this.setCallbacks(ConverterUtils.toMapBuilder((Object)value, String.class, Callback.class).sparse().build());
            case "deprecated" -> this.setDeprecated((Boolean)ConverterUtils.toType((Object)value, Boolean.class));
            case "description" -> this.setDescription(Utils.s((Object)value));
            case "externalDocs" -> this.setExternalDocs((ExternalDocumentation)ConverterUtils.toType((Object)value, ExternalDocumentation.class));
            case "operationId" -> this.setOperationId(Utils.s((Object)value));
            case "parameters" -> this.setParameters(ConverterUtils.toListBuilder((Object)value, Parameter.class).sparse().build());
            case "requestBody" -> this.setRequestBody((RequestBodyInfo)ConverterUtils.toType((Object)value, RequestBodyInfo.class));
            case "responses" -> this.setResponses(ConverterUtils.toMapBuilder((Object)value, String.class, Response.class).sparse().build());
            case "security" -> this.setSecurity(ConverterUtils.toListBuilder((Object)value, SecurityRequirement.class).sparse().build());
            case "servers" -> this.setServers(ConverterUtils.toListBuilder((Object)value, Server.class).sparse().build());
            case "summary" -> this.setSummary(Utils.s((Object)value));
            case "tags" -> this.setTags(ConverterUtils.toListBuilder((Object)value, String.class).sparse().build());
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Operation setCallbacks(Map<String, Callback> value) {
        this.callbacks.clear();
        if (Utils.nn(value)) {
            this.callbacks.putAll(value);
        }
        return this;
    }

    public Operation setDeprecated(Boolean value) {
        this.deprecated = value;
        return this;
    }

    public Operation setDescription(String value) {
        this.description = value;
        return this;
    }

    public Operation setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public Operation setOperationId(String value) {
        this.operationId = value;
        return this;
    }

    public Operation setParameters(List<Parameter> value) {
        this.parameters.clear();
        if (Utils.nn(value)) {
            this.parameters.addAll(value);
        }
        return this;
    }

    public Operation setParameters(Parameter ... value) {
        this.setParameters(ConverterUtils.toListBuilder((Object)value, Parameter.class).sparse().build());
        return this;
    }

    public Operation setRequestBody(RequestBodyInfo value) {
        this.requestBody = value;
        return this;
    }

    public Operation setResponses(Map<String, Response> value) {
        this.responses.clear();
        if (Utils.nn(value)) {
            this.responses.putAll(value);
        }
        return this;
    }

    public Operation setSecurity(List<SecurityRequirement> value) {
        this.security.clear();
        if (Utils.nn(value)) {
            this.security.addAll(value);
        }
        return this;
    }

    public Operation setSecurity(SecurityRequirement ... value) {
        this.setSecurity(ConverterUtils.toListBuilder((Object)value, SecurityRequirement.class).sparse().build());
        return this;
    }

    public Operation setServers(List<Server> value) {
        this.servers.clear();
        if (Utils.nn(value)) {
            this.servers.addAll(value);
        }
        return this;
    }

    public Operation setServers(Server ... value) {
        this.setServers(ConverterUtils.toListBuilder((Object)value, Server.class).sparse().build());
        return this;
    }

    public Operation setSummary(String value) {
        this.summary = value;
        return this;
    }

    public Operation setTags(List<String> value) {
        this.tags.clear();
        if (Utils.nn(value)) {
            this.tags.addAll(value);
        }
        return this;
    }

    public Operation setTags(String ... value) {
        this.setTags(ConverterUtils.toListBuilder((Object)value, String.class).sparse().build());
        return this;
    }

    @Override
    public Operation strict() {
        super.strict();
        return this;
    }

    @Override
    public Operation strict(Object value) {
        super.strict(value);
        return this;
    }
}

