/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BasicPropertyNamer;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.InvalidDataConversionException;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.annotation.BeanAnnotation;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.annotation.MarshalledAnnotation;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.function.OptionalSupplier;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.PackageInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.reflect.TypeVariables;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.swap.FunctionalSwap;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.swap.Surrogate;
import org.apache.juneau.swap.SurrogateSwap;

public class BeanContext
extends Context {
    private static final List<String> DEFAULT_NOTBEAN_PACKAGES = CollectionUtils.l("java.lang", "java.lang.annotation", "java.lang.ref", "java.lang.reflect", "java.io", "java.net", "java.nio.*", "java.util.*");
    private static final List<ClassInfo> DEFAULT_NOTBEAN_CLASSES = CollectionUtils.l(ReflectionUtils.info(Map.class), ReflectionUtils.info(Collection.class), ReflectionUtils.info(Reader.class), ReflectionUtils.info(Writer.class), ReflectionUtils.info(InputStream.class), ReflectionUtils.info(OutputStream.class), ReflectionUtils.info(Throwable.class));
    public static final BeanContext DEFAULT = BeanContext.create().build();
    public static final BeanContext DEFAULT_SORTED = BeanContext.create().sortProperties().build();
    public static final BeanSession DEFAULT_SESSION = DEFAULT.createSession().unmodifiable().build();
    private final OptionalSupplier<WriterSerializer> beanToStringSerializer;
    private final BeanRegistry beanRegistry;
    private final BeanSession defaultSession;
    private final boolean beanMapPutReturnsOldValue;
    private final boolean beansRequireDefaultConstructor;
    private final boolean beansRequireSerializable;
    private final boolean beansRequireSettersForGetters;
    private final boolean beansRequireSomeProperties;
    private final boolean findFluentSetters;
    private final boolean ignoreInvocationExceptionsOnGetters;
    private final boolean ignoreInvocationExceptionsOnSetters;
    private final boolean ignoreMissingSetters;
    private final boolean ignoreTransientFields;
    private final boolean ignoreUnknownBeanProperties;
    private final boolean ignoreUnknownEnumValues;
    private final boolean ignoreUnknownNullBeanProperties;
    private final boolean sortProperties;
    private final boolean useEnumNames;
    private final boolean useInterfaceProxies;
    private final boolean useJavaBeanIntrospector;
    private final Class<? extends PropertyNamer> propertyNamer;
    private final ClassMeta<Object> cmObject;
    private final ClassMeta<String> cmString;
    private final HashKey hashKey;
    private final List<ClassInfo> beanDictionary;
    private final List<ClassInfo> notBeanClasses;
    private final List<Object> swaps;
    private final List<String> notBeanPackages;
    private final Locale locale;
    private final Cache<Class, ClassMeta> cmCache;
    private final MediaType mediaType;
    private final List<ObjectSwap<?, ?>> objectSwaps;
    private final PropertyNamer propertyNamerBean;
    private final String typePropertyName;
    private final Set<String> notBeanPackageNames;
    private final List<String> notBeanPackagePrefixes;
    private final TimeZone timeZone;
    private final Visibility beanClassVisibility;
    private final Visibility beanConstructorVisibility;
    private final Visibility beanFieldVisibility;
    private final Visibility beanMethodVisibility;

    public static Builder create() {
        return new Builder();
    }

    private static boolean isCacheable(Class<?> c) {
        String n = c.getName();
        char x = n.charAt(n.length() - 1);
        return x < '0' || x > '9' || n.indexOf("$$") == -1 && !n.startsWith("sun") && !n.startsWith("com.sun") && n.indexOf("$Proxy") == -1;
    }

    public BeanContext(Builder builder) {
        super(builder);
        this.beanClassVisibility = builder.beanClassVisibility;
        this.beanConstructorVisibility = builder.beanConstructorVisibility;
        this.beanDictionary = CollectionUtils.u(CollectionUtils.copyOf(builder.beanDictionary));
        this.beanFieldVisibility = builder.beanFieldVisibility;
        this.beanMapPutReturnsOldValue = builder.beanMapPutReturnsOldValue;
        this.beanMethodVisibility = builder.beanMethodVisibility;
        this.beansRequireDefaultConstructor = builder.beansRequireDefaultConstructor;
        this.beansRequireSerializable = builder.beansRequireSerializable;
        this.beansRequireSettersForGetters = builder.beansRequireSettersForGetters;
        this.beansRequireSomeProperties = !builder.disableBeansRequireSomeProperties;
        this.findFluentSetters = builder.findFluentSetters;
        this.hashKey = builder.hashKey();
        this.ignoreInvocationExceptionsOnGetters = builder.ignoreInvocationExceptionsOnGetters;
        this.ignoreInvocationExceptionsOnSetters = builder.ignoreInvocationExceptionsOnSetters;
        this.ignoreMissingSetters = !builder.disableIgnoreMissingSetters;
        this.ignoreTransientFields = !builder.disableIgnoreTransientFields;
        this.ignoreUnknownBeanProperties = builder.ignoreUnknownBeanProperties;
        this.ignoreUnknownEnumValues = builder.ignoreUnknownEnumValues;
        this.ignoreUnknownNullBeanProperties = !builder.disableIgnoreUnknownNullBeanProperties;
        this.locale = Utils.opt(builder.locale).orElse(Locale.getDefault());
        this.mediaType = builder.mediaType;
        this.notBeanPackages = CollectionUtils.u(new ArrayList<String>(builder.notBeanPackages));
        this.propertyNamer = Utils.nn(builder.propertyNamer) ? builder.propertyNamer : BasicPropertyNamer.class;
        this.sortProperties = builder.sortProperties;
        this.swaps = CollectionUtils.u(CollectionUtils.copyOf(builder.swaps));
        this.timeZone = builder.timeZone;
        this.typePropertyName = Utils.opt(builder.typePropertyName).orElse("_type");
        this.useEnumNames = builder.useEnumNames;
        this.useInterfaceProxies = !builder.disableInterfaceProxies;
        this.useJavaBeanIntrospector = builder.useJavaBeanIntrospector;
        ArrayList<ClassInfo> builderNotBeanClasses = new ArrayList<ClassInfo>(builder.notBeanClasses);
        this.notBeanClasses = builderNotBeanClasses.isEmpty() ? DEFAULT_NOTBEAN_CLASSES : Stream.concat(builderNotBeanClasses.stream(), DEFAULT_NOTBEAN_CLASSES.stream()).distinct().toList();
        List<String> _notBeanPackages = this.notBeanPackages.isEmpty() ? DEFAULT_NOTBEAN_PACKAGES : Stream.concat(this.notBeanPackages.stream(), DEFAULT_NOTBEAN_PACKAGES.stream()).toList();
        LinkedHashSet _notBeanPackageNames = _notBeanPackages.stream().filter(x -> !x.endsWith(".*")).collect(Collectors.toCollection(LinkedHashSet::new));
        this.notBeanPackageNames = CollectionUtils.u(_notBeanPackageNames);
        this.notBeanPackagePrefixes = _notBeanPackages.stream().filter(x -> x.endsWith(".*")).map(x -> x.substring(0, x.length() - 2)).toList();
        this.propertyNamerBean = Utils.safe(() -> this.propertyNamer.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        LinkedList _objectSwaps = new LinkedList();
        this.swaps.forEach(x -> {
            if (x instanceof ObjectSwap) {
                ObjectSwap os = (ObjectSwap)x;
                _objectSwaps.add(os);
            } else {
                ClassInfoTyped ci = ReflectionUtils.info((Class)x);
                if (ci.isChildOf(ObjectSwap.class)) {
                    _objectSwaps.add(BeanCreator.of(ObjectSwap.class).type(ci).run());
                } else if (ci.isChildOf(Surrogate.class)) {
                    _objectSwaps.addAll(SurrogateSwap.findObjectSwaps(ci.inner(), this));
                } else {
                    throw ThrowableUtils.rex("Invalid class {0} specified in BeanContext.swaps property.  Must be a subclass of ObjectSwap or Surrogate.", Utils.cn(ci.inner()));
                }
            }
        });
        this.objectSwaps = CollectionUtils.u(_objectSwaps);
        this.cmCache = Cache.create().supplier(type -> new ClassMeta(type, this)).build();
        this.cmString = this.cmCache.get(String.class);
        this.cmObject = this.cmCache.get(Object.class);
        this.beanRegistry = new BeanRegistry(this, null, CollectionUtils.list(new ClassInfo[0]));
        this.defaultSession = this.createSession().unmodifiable().build();
        this.beanToStringSerializer = Utils.mem(() -> JsonSerializer.create().beanContext(this).sq().simpleAttrs().build());
    }

    public final <T> T convertToType(Object value, Class<T> type) throws InvalidDataConversionException {
        return this.defaultSession.convertToType(value, type);
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public BeanSession.Builder createSession() {
        return BeanSession.create(this);
    }

    public final Visibility getBeanClassVisibility() {
        return this.beanClassVisibility;
    }

    public final Visibility getBeanConstructorVisibility() {
        return this.beanConstructorVisibility;
    }

    public final List<ClassInfo> getBeanDictionary() {
        return this.beanDictionary;
    }

    public final Visibility getBeanFieldVisibility() {
        return this.beanFieldVisibility;
    }

    public final <T> BeanMeta<T> getBeanMeta(Class<T> c) {
        AssertionUtils.assertArgNotNull("c", c);
        return this.getClassMeta(c).getBeanMeta();
    }

    public final Visibility getBeanMethodVisibility() {
        return this.beanMethodVisibility;
    }

    public final String getBeanTypePropertyName() {
        return this.typePropertyName;
    }

    public final <T> ClassMeta<T> getClassMeta(Class<T> type) {
        if (!BeanContext.isCacheable(type)) {
            return new ClassMeta<T>(type, this);
        }
        return this.cmCache.get(type);
    }

    public final <T> ClassMeta<T> getClassMeta(Type type, Type ... args) {
        if (type == null) {
            return null;
        }
        ClassMeta<T> cm = null;
        if (type instanceof Class) {
            Class type2 = (Class)type;
            cm = this.getClassMeta(type2);
        } else {
            cm = this.resolveClassMeta(type, null);
        }
        if (args.length == 0) {
            return cm;
        }
        ClassMeta[] cma = new ClassMeta[args.length + 1];
        cma[0] = cm;
        for (int i = 0; i < CollectionUtils.length(args); ++i) {
            Type arg = (Type)Array.get(args, i);
            if (arg instanceof Class) {
                Class arg2 = (Class)arg;
                cma[i + 1] = this.getClassMeta(arg2);
                continue;
            }
            cma[i + 1] = this.resolveClassMeta(arg, null);
        }
        return this.getTypedClassMeta(cma, 0);
    }

    public final <T> ClassMeta<T> getClassMetaForObject(T o) {
        AssertionUtils.assertArgNotNull("o", o);
        return this.getClassMeta(o.getClass());
    }

    public final Locale getDefaultLocale() {
        return this.locale;
    }

    public final MediaType getDefaultMediaType() {
        return this.mediaType;
    }

    public final TimeZone getDefaultTimeZone() {
        return this.timeZone;
    }

    public final Set<String> getNotBeanPackagesNames() {
        return this.notBeanPackageNames;
    }

    public final PropertyNamer getPropertyNamer() {
        return this.propertyNamerBean;
    }

    @Override
    public BeanSession getSession() {
        return this.defaultSession;
    }

    public final List<ObjectSwap<?, ?>> getSwaps() {
        return this.objectSwaps;
    }

    public final boolean hasSameCache(BeanContext bc) {
        AssertionUtils.assertArgNotNull("bc", bc);
        return bc.getCmCache() == this.getCmCache();
    }

    public final boolean isBeanMapPutReturnsOldValue() {
        return this.beanMapPutReturnsOldValue;
    }

    public final boolean isBeansRequireDefaultConstructor() {
        return this.beansRequireDefaultConstructor;
    }

    public final boolean isBeansRequireSerializable() {
        return this.beansRequireSerializable;
    }

    public final boolean isBeansRequireSettersForGetters() {
        return this.beansRequireSettersForGetters;
    }

    public final boolean isBeansRequireSomeProperties() {
        return this.beansRequireSomeProperties;
    }

    public final boolean isFindFluentSetters() {
        return this.findFluentSetters;
    }

    public final boolean isIgnoreInvocationExceptionsOnGetters() {
        return this.ignoreInvocationExceptionsOnGetters;
    }

    public final boolean isIgnoreInvocationExceptionsOnSetters() {
        return this.ignoreInvocationExceptionsOnSetters;
    }

    public final boolean isIgnoreMissingSetters() {
        return this.ignoreMissingSetters;
    }

    public final boolean isIgnoreUnknownBeanProperties() {
        return this.ignoreUnknownBeanProperties;
    }

    public final boolean isIgnoreUnknownEnumValues() {
        return this.ignoreUnknownEnumValues;
    }

    public final boolean isIgnoreUnknownNullBeanProperties() {
        return this.ignoreUnknownNullBeanProperties;
    }

    public final boolean isSortProperties() {
        return this.sortProperties;
    }

    public final boolean isUseEnumNames() {
        return this.useEnumNames;
    }

    public final boolean isUseInterfaceProxies() {
        return this.useInterfaceProxies;
    }

    public final boolean isUseJavaBeanIntrospector() {
        return this.useJavaBeanIntrospector;
    }

    public <T> BeanMap<T> newBeanMap(Class<T> c) {
        AssertionUtils.assertArgNotNull("c", c);
        return this.defaultSession.newBeanMap(c);
    }

    public <T> BeanMap<T> toBeanMap(T object) {
        AssertionUtils.assertArgNotNull("object", object);
        return this.defaultSession.toBeanMap(object);
    }

    protected final BeanRegistry getBeanRegistry() {
        return this.beanRegistry;
    }

    protected WriterSerializer getBeanToStringSerializer() {
        return (WriterSerializer)this.beanToStringSerializer.get();
    }

    protected final Cache<Class, ClassMeta> getCmCache() {
        return this.cmCache;
    }

    protected final HashKey getHashKey() {
        return this.hashKey;
    }

    protected final Locale getLocale() {
        return this.locale;
    }

    protected final MediaType getMediaType() {
        return this.mediaType;
    }

    protected final List<ClassInfo> getNotBeanClasses() {
        return this.notBeanClasses;
    }

    protected final TimeZone getTimeZone() {
        return this.timeZone;
    }

    protected final boolean isIgnoreTransientFields() {
        return this.ignoreTransientFields;
    }

    protected final boolean isNotABean(ClassInfo ci) {
        if (ci.isArray() || ci.isPrimitive() || ci.isEnum() || ci.isAnnotation()) {
            return true;
        }
        PackageInfo p = ci.getPackage();
        if (Utils.nn(p)) {
            String pn = p.getName();
            for (String p2 : this.notBeanPackageNames) {
                if (!pn.equals(p2)) continue;
                return true;
            }
            for (String p2 : this.notBeanPackagePrefixes) {
                if (!pn.startsWith(p2)) continue;
                return true;
            }
        }
        for (ClassInfo exclude : this.notBeanClasses) {
            if (!ci.isChildOf(exclude)) continue;
            return true;
        }
        return false;
    }

    protected final ClassMeta<Object> object() {
        return this.cmObject;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a("beanClassVisibility", (Object)this.beanClassVisibility).a("beanConstructorVisibility", (Object)this.beanConstructorVisibility).a("beanDictionary", this.beanDictionary).a("beanFieldVisibility", (List<ClassInfo>)((Object)this.beanFieldVisibility)).a("beanMethodVisibility", (List<ClassInfo>)((Object)this.beanMethodVisibility)).a("beansRequireDefaultConstructor", (List<ClassInfo>)this.beansRequireDefaultConstructor).a("beansRequireSerializable", (List<ClassInfo>)this.beansRequireSerializable).a("beansRequireSettersForGetters", (List<ClassInfo>)this.beansRequireSettersForGetters).a("beansRequireSomeProperties", (List<ClassInfo>)this.beansRequireSomeProperties).a("id", (List<ClassInfo>)System.identityHashCode(this)).a("ignoreInvocationExceptionsOnGetters", (List<ClassInfo>)this.ignoreInvocationExceptionsOnGetters).a("ignoreInvocationExceptionsOnSetters", (List<ClassInfo>)this.ignoreInvocationExceptionsOnSetters).a("ignoreTransientFields", (List<ClassInfo>)this.ignoreTransientFields).a("ignoreUnknownBeanProperties", (List<ClassInfo>)this.ignoreUnknownBeanProperties).a("ignoreUnknownNullBeanProperties", (List<ClassInfo>)this.ignoreUnknownNullBeanProperties).a("notBeanClasses", this.notBeanClasses).a("notBeanPackageNames", (List<ClassInfo>)((Object)this.notBeanPackageNames)).a("notBeanPackagePrefixes", (Set<String>)((Object)this.notBeanPackagePrefixes)).a("sortProperties", (List<String>)this.sortProperties).a("swaps", this.swaps).a("useEnumNames", (List<Object>)this.useEnumNames).a("useInterfaceProxies", (List<Object>)this.useInterfaceProxies).a("useJavaBeanIntrospector", (List<Object>)this.useJavaBeanIntrospector);
    }

    protected final <T> ClassMeta<T> resolveClassMeta(AnnotationInfo<Beanp> p, ClassInfo ci, TypeVariables typeVarImpls) {
        ClassMeta cm;
        ClassMeta cm2 = cm = this.resolveClassMeta(ci, typeVarImpls);
        if (Utils.nn(p)) {
            Beanp beanp = p.inner();
            if (ClassUtils.isNotVoid(beanp.type())) {
                cm2 = this.resolveClassMeta(beanp.type(), typeVarImpls);
            }
            if (cm2.isMap()) {
                Class<?>[] pParams;
                Class<Object>[] classArray = pParams = beanp.params().length == 0 ? CollectionUtils.a(Object.class, Object.class) : beanp.params();
                if (pParams.length != 2) {
                    throw ThrowableUtils.rex("Invalid number of parameters specified for Map (must be 2): {0}", pParams.length);
                }
                ClassMeta<?> keyType = this.resolveType(pParams[0], cm2.getKeyType(), cm.getKeyType());
                ClassMeta<?> valueType = this.resolveType(pParams[1], cm2.getValueType(), cm.getValueType());
                if (keyType.isObject() && valueType.isObject()) {
                    return cm2;
                }
                return new ClassMeta(cm2, keyType, valueType, null);
            }
            if (cm2.isCollection() || cm2.isOptional()) {
                Class<?>[] pParams;
                Class<Object>[] classArray = pParams = beanp.params().length == 0 ? CollectionUtils.a(Object.class) : beanp.params();
                if (pParams.length != 1) {
                    throw ThrowableUtils.rex("Invalid number of parameters specified for {1} (must be 1): {0}", pParams.length, cm2.isCollection() ? "Collection" : (cm2.isOptional() ? "Optional" : "Array"));
                }
                ClassMeta<?> elementType = this.resolveType(pParams[0], cm2.getElementType(), cm.getElementType());
                if (elementType.isObject()) {
                    return cm2;
                }
                return new ClassMeta(cm2, null, null, elementType);
            }
            return cm2;
        }
        return cm;
    }

    protected final ClassMeta<String> string() {
        return this.cmString;
    }

    final ClassMeta[] findParameters(Type o, Class c) {
        ParameterizedType o2;
        if (o == null) {
            o = c;
        }
        if (!(o instanceof ParameterizedType)) {
            block0: while (!((o = c.getGenericSuperclass()) instanceof ParameterizedType)) {
                for (Type t : c.getGenericInterfaces()) {
                    o = t;
                    if (o instanceof ParameterizedType) break block0;
                }
                if (Utils.nn(c = c.getSuperclass())) continue;
            }
        }
        if (o instanceof ParameterizedType && !(o2 = (ParameterizedType)o).getRawType().equals(Enum.class)) {
            LinkedList<ClassMeta> l = new LinkedList<ClassMeta>();
            for (Type pt2 : o2.getActualTypeArguments()) {
                if (pt2 instanceof WildcardType || pt2 instanceof TypeVariable) {
                    return null;
                }
                l.add(this.resolveClassMeta(pt2, null));
            }
            if (l.isEmpty()) {
                return null;
            }
            return l.toArray(new ClassMeta[l.size()]);
        }
        return null;
    }

    final ClassMeta resolveClassMeta(Type o, TypeVariables typeVars) {
        if (o == null) {
            return null;
        }
        if (o instanceof ClassMeta) {
            ClassMeta cm = (ClassMeta)o;
            if (cm.getBeanContext() == this) {
                return cm;
            }
            if (cm.isMap()) {
                return this.getClassMeta(cm.inner(), cm.getKeyType(), cm.getValueType());
            }
            if (cm.isCollection() || cm.isOptional()) {
                return this.getClassMeta(cm.inner(), cm.getElementType());
            }
            return this.getClassMeta(cm.inner());
        }
        if (o instanceof ClassInfo) {
            ClassInfo ci = (ClassInfo)o;
            return this.resolveClassMeta(ci.innerType(), typeVars);
        }
        Class<?> c = TypeVariables.resolve(o, typeVars);
        if (c == null) {
            return this.object();
        }
        ClassMeta<?> rawType = this.getClassMeta(c);
        if (rawType.isMap() || rawType.isCollection() || rawType.isOptional()) {
            ClassMeta[] params = this.findParameters(o, c);
            if (params == null) {
                return rawType;
            }
            if (rawType.isMap()) {
                if (params.length != 2 || params[0].isObject() && params[1].isObject()) {
                    return rawType;
                }
                return new ClassMeta(rawType, params[0], params[1], null);
            }
            if (rawType.isCollection() || rawType.isOptional()) {
                if (params.length != 1 || params[0].isObject()) {
                    return rawType;
                }
                return new ClassMeta(rawType, null, null, params[0]);
            }
        }
        if (rawType.isArray() && o instanceof GenericArrayType) {
            GenericArrayType o2 = (GenericArrayType)o;
            ClassMeta elementType = this.resolveClassMeta(o2.getGenericComponentType(), typeVars);
            return new ClassMeta(rawType, null, null, elementType);
        }
        return rawType;
    }

    private ClassMeta<?> getTypedClassMeta(ClassMeta<?>[] c, int pos) {
        ClassMeta cm;
        if ((cm = c[pos++]).isCollection() || cm.isOptional()) {
            ClassMeta<Object> ce = c.length == pos ? this.object() : this.getTypedClassMeta(c, pos);
            return ce.isObject() ? cm : new ClassMeta(cm, null, null, ce);
        }
        if (cm.isMap()) {
            ClassMeta<Object> ck = c.length == pos ? this.object() : c[pos++];
            ClassMeta<Object> cv = c.length == pos ? this.object() : this.getTypedClassMeta(c, pos);
            return ck.isObject() && cv.isObject() ? cm : new ClassMeta(cm, ck, cv, null);
        }
        return cm;
    }

    private ClassMeta<?> resolveType(Type ... t) {
        for (Type tt : t) {
            if (!Utils.nn(tt)) continue;
            ClassMeta cm = this.getClassMeta(tt, new Type[0]);
            if (tt == this.cmObject) continue;
            return cm;
        }
        return this.cmObject;
    }

    public static class Builder
    extends Context.Builder {
        private static final Cache<HashKey, BeanContext> CACHE = Cache.of(HashKey.class, BeanContext.class).build();
        private Visibility beanClassVisibility;
        private Visibility beanConstructorVisibility;
        private Visibility beanMethodVisibility;
        private Visibility beanFieldVisibility;
        private boolean disableBeansRequireSomeProperties;
        private boolean beanMapPutReturnsOldValue;
        private boolean beansRequireDefaultConstructor;
        private boolean beansRequireSerializable;
        private boolean beansRequireSettersForGetters;
        private boolean disableIgnoreTransientFields;
        private boolean disableIgnoreUnknownNullBeanProperties;
        private boolean disableIgnoreMissingSetters;
        private boolean disableInterfaceProxies;
        private boolean findFluentSetters;
        private boolean ignoreInvocationExceptionsOnGetters;
        private boolean ignoreInvocationExceptionsOnSetters;
        private boolean ignoreUnknownBeanProperties;
        private boolean ignoreUnknownEnumValues;
        private boolean sortProperties;
        private boolean useEnumNames;
        private boolean useJavaBeanIntrospector;
        private String typePropertyName;
        private MediaType mediaType;
        private Locale locale;
        private TimeZone timeZone;
        private Class<? extends PropertyNamer> propertyNamer;
        private List<ClassInfo> beanDictionary;
        private List<Object> swaps;
        private Set<ClassInfo> notBeanClasses;
        private Set<String> notBeanPackages;

        private static int integer(boolean ... values) {
            int n = 0;
            for (boolean b : values) {
                n = n << 1 | (b ? 1 : 0);
            }
            return n;
        }

        protected Builder() {
            this.beanClassVisibility = Utils.env("BeanContext.beanClassVisibility", Visibility.PUBLIC);
            this.beanConstructorVisibility = Utils.env("BeanContext.beanConstructorVisibility", Visibility.PUBLIC);
            this.beanDictionary = CollectionUtils.list(new ClassInfo[0]);
            this.beanFieldVisibility = Utils.env("BeanContext.beanFieldVisibility", Visibility.PUBLIC);
            this.beanMapPutReturnsOldValue = Utils.env("BeanContext.beanMapPutReturnsOldValue", false);
            this.beanMethodVisibility = Utils.env("BeanContext.beanMethodVisibility", Visibility.PUBLIC);
            this.beansRequireDefaultConstructor = Utils.env("BeanContext.beansRequireDefaultConstructor", false);
            this.beansRequireSerializable = Utils.env("BeanContext.beansRequireSerializable", false);
            this.beansRequireSettersForGetters = Utils.env("BeanContext.beansRequireSettersForGetters", false);
            this.disableBeansRequireSomeProperties = Utils.env("BeanContext.disableBeansRequireSomeProperties", false);
            this.disableIgnoreMissingSetters = Utils.env("BeanContext.disableIgnoreMissingSetters", false);
            this.disableIgnoreTransientFields = Utils.env("BeanContext.disableIgnoreTransientFields", false);
            this.disableIgnoreUnknownNullBeanProperties = Utils.env("BeanContext.disableIgnoreUnknownNullBeanProperties", false);
            this.disableInterfaceProxies = Utils.env("BeanContext.disableInterfaceProxies", false);
            this.findFluentSetters = Utils.env("BeanContext.findFluentSetters", false);
            this.ignoreInvocationExceptionsOnGetters = Utils.env("BeanContext.ignoreInvocationExceptionsOnGetters", false);
            this.ignoreInvocationExceptionsOnSetters = Utils.env("BeanContext.ignoreInvocationExceptionsOnSetters", false);
            this.ignoreUnknownBeanProperties = Utils.env("BeanContext.ignoreUnknownBeanProperties", false);
            this.ignoreUnknownEnumValues = Utils.env("BeanContext.ignoreUnknownEnumValues", false);
            this.locale = Utils.env("BeanContext.locale").map(x -> Locale.forLanguageTag(x)).orElse(Locale.getDefault());
            this.mediaType = Utils.env("BeanContext.mediaType").map(x -> MediaType.of(x)).orElse(null);
            this.notBeanClasses = new TreeSet<ClassInfo>();
            this.notBeanPackages = new TreeSet<String>();
            this.propertyNamer = null;
            this.sortProperties = Utils.env("BeanContext.sortProperties", false);
            this.swaps = CollectionUtils.list(new Object[0]);
            this.timeZone = Utils.env("BeanContext.timeZone").map(x -> TimeZone.getTimeZone(x)).orElse(null);
            this.typePropertyName = Utils.env("BeanContext.typePropertyName", "_type");
            this.useEnumNames = Utils.env("BeanContext.useEnumNames", false);
            this.useJavaBeanIntrospector = Utils.env("BeanContext.useJavaBeanIntrospector", false);
        }

        protected Builder(BeanContext copyFrom) {
            super(copyFrom);
            this.beanClassVisibility = copyFrom.beanClassVisibility;
            this.beanConstructorVisibility = copyFrom.beanConstructorVisibility;
            this.beanDictionary = CollectionUtils.copyOf(copyFrom.beanDictionary);
            this.beanFieldVisibility = copyFrom.beanFieldVisibility;
            this.beanMapPutReturnsOldValue = copyFrom.beanMapPutReturnsOldValue;
            this.beanMethodVisibility = copyFrom.beanMethodVisibility;
            this.beansRequireDefaultConstructor = copyFrom.beansRequireDefaultConstructor;
            this.beansRequireSerializable = copyFrom.beansRequireSerializable;
            this.beansRequireSettersForGetters = copyFrom.beansRequireSettersForGetters;
            this.disableBeansRequireSomeProperties = !copyFrom.beansRequireSomeProperties;
            this.disableIgnoreMissingSetters = !copyFrom.ignoreMissingSetters;
            this.disableIgnoreTransientFields = !copyFrom.ignoreTransientFields;
            this.disableIgnoreUnknownNullBeanProperties = !copyFrom.ignoreUnknownNullBeanProperties;
            this.disableInterfaceProxies = !copyFrom.useInterfaceProxies;
            this.findFluentSetters = copyFrom.findFluentSetters;
            this.ignoreInvocationExceptionsOnGetters = copyFrom.ignoreInvocationExceptionsOnGetters;
            this.ignoreInvocationExceptionsOnSetters = copyFrom.ignoreInvocationExceptionsOnSetters;
            this.ignoreUnknownBeanProperties = copyFrom.ignoreUnknownBeanProperties;
            this.ignoreUnknownEnumValues = copyFrom.ignoreUnknownEnumValues;
            this.locale = copyFrom.locale;
            this.mediaType = copyFrom.mediaType;
            this.notBeanClasses = new TreeSet<ClassInfo>(copyFrom.notBeanClasses);
            this.notBeanPackages = CollectionUtils.toSortedSet(copyFrom.notBeanPackages, false);
            this.propertyNamer = copyFrom.propertyNamer;
            this.sortProperties = copyFrom.sortProperties;
            this.swaps = CollectionUtils.copyOf(copyFrom.swaps);
            this.timeZone = copyFrom.timeZone;
            this.typePropertyName = copyFrom.typePropertyName;
            this.useEnumNames = copyFrom.useEnumNames;
            this.useJavaBeanIntrospector = copyFrom.useJavaBeanIntrospector;
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.beanClassVisibility = copyFrom.beanClassVisibility;
            this.beanConstructorVisibility = copyFrom.beanConstructorVisibility;
            this.beanDictionary = CollectionUtils.copyOf(copyFrom.beanDictionary);
            this.beanFieldVisibility = copyFrom.beanFieldVisibility;
            this.beanMapPutReturnsOldValue = copyFrom.beanMapPutReturnsOldValue;
            this.beanMethodVisibility = copyFrom.beanMethodVisibility;
            this.beansRequireDefaultConstructor = copyFrom.beansRequireDefaultConstructor;
            this.beansRequireSerializable = copyFrom.beansRequireSerializable;
            this.beansRequireSettersForGetters = copyFrom.beansRequireSettersForGetters;
            this.disableBeansRequireSomeProperties = copyFrom.disableBeansRequireSomeProperties;
            this.disableIgnoreMissingSetters = copyFrom.disableIgnoreMissingSetters;
            this.disableIgnoreTransientFields = copyFrom.disableIgnoreTransientFields;
            this.disableIgnoreUnknownNullBeanProperties = copyFrom.disableIgnoreUnknownNullBeanProperties;
            this.disableInterfaceProxies = copyFrom.disableInterfaceProxies;
            this.findFluentSetters = copyFrom.findFluentSetters;
            this.ignoreInvocationExceptionsOnGetters = copyFrom.ignoreInvocationExceptionsOnGetters;
            this.ignoreInvocationExceptionsOnSetters = copyFrom.ignoreInvocationExceptionsOnSetters;
            this.ignoreUnknownBeanProperties = copyFrom.ignoreUnknownBeanProperties;
            this.ignoreUnknownEnumValues = copyFrom.ignoreUnknownEnumValues;
            this.locale = copyFrom.locale;
            this.mediaType = copyFrom.mediaType;
            this.notBeanClasses = new TreeSet<ClassInfo>(copyFrom.notBeanClasses);
            this.notBeanPackages = CollectionUtils.toSortedSet(copyFrom.notBeanPackages);
            this.propertyNamer = copyFrom.propertyNamer;
            this.sortProperties = copyFrom.sortProperties;
            this.swaps = CollectionUtils.copyOf(copyFrom.swaps);
            this.timeZone = copyFrom.timeZone;
            this.typePropertyName = copyFrom.typePropertyName;
            this.useEnumNames = copyFrom.useEnumNames;
            this.useJavaBeanIntrospector = copyFrom.useJavaBeanIntrospector;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations(from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        public Builder beanClassVisibility(Visibility value) {
            this.beanClassVisibility = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        public Builder beanConstructorVisibility(Visibility value) {
            this.beanConstructorVisibility = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        public List<ClassInfo> beanDictionary() {
            return this.beanDictionary;
        }

        public Builder beanDictionary(Class<?> ... values) {
            AssertionUtils.assertArgNoNulls("values", values);
            return this.beanDictionary((ClassInfo[])Stream.of(values).map(ReflectionUtils::info).toArray(ClassInfo[]::new));
        }

        public Builder beanDictionary(ClassInfo ... values) {
            AssertionUtils.assertArgNoNulls("values", values);
            return this.beanDictionary(CollectionUtils.l(values));
        }

        public Builder beanDictionary(Collection<ClassInfo> values) {
            AssertionUtils.assertArgNoNulls("values", values);
            this.beanDictionary().addAll(0, values);
            return this;
        }

        public Builder beanFieldVisibility(Visibility value) {
            this.beanFieldVisibility = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            AssertionUtils.assertArgNotNull("on", on);
            AssertionUtils.assertArgNotNull("value", value);
            return this.annotations(BeanAnnotation.create(on).interceptor(value).build());
        }

        public Builder beanMapPutReturnsOldValue() {
            return this.beanMapPutReturnsOldValue(true);
        }

        public Builder beanMapPutReturnsOldValue(boolean value) {
            this.beanMapPutReturnsOldValue = value;
            return this;
        }

        public Builder beanMethodVisibility(Visibility value) {
            this.beanMethodVisibility = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        public Builder beanProperties(Class<?> beanClass, String properties) {
            AssertionUtils.assertArgNotNull("beanClass", beanClass);
            AssertionUtils.assertArgNotNull("properties", properties);
            return this.annotations(BeanAnnotation.create(beanClass).p(properties).build());
        }

        public Builder beanProperties(Map<String, Object> values) {
            AssertionUtils.assertArgNotNull("values", values);
            values.forEach((k, v) -> this.annotations(BeanAnnotation.create(k).p(Utils.s(v)).build()));
            return this;
        }

        public Builder beanProperties(String beanClassName, String properties) {
            AssertionUtils.assertArgNotNull("beanClassName", beanClassName);
            AssertionUtils.assertArgNotNull("properties", properties);
            return this.annotations(BeanAnnotation.create(beanClassName).p(properties).build());
        }

        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            AssertionUtils.assertArgNotNull("beanClass", beanClass);
            AssertionUtils.assertArgNotNull("properties", properties);
            return this.annotations(BeanAnnotation.create(beanClass).xp(properties).build());
        }

        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            AssertionUtils.assertArgNotNull("values", values);
            values.forEach((k, v) -> this.annotations(BeanAnnotation.create(k).xp(Utils.s(v)).build()));
            return this;
        }

        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            AssertionUtils.assertArgNotNull("beanClassName", beanClassName);
            AssertionUtils.assertArgNotNull("properties", properties);
            return this.annotations(BeanAnnotation.create(beanClassName).xp(properties).build());
        }

        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            AssertionUtils.assertArgNotNull("beanClass", beanClass);
            AssertionUtils.assertArgNotNull("properties", properties);
            return this.annotations(BeanAnnotation.create(beanClass).ro(properties).build());
        }

        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            AssertionUtils.assertArgNotNull("values", values);
            values.forEach((k, v) -> this.annotations(BeanAnnotation.create(k).ro(Utils.s(v)).build()));
            return this;
        }

        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            AssertionUtils.assertArgNotNull("beanClassName", beanClassName);
            AssertionUtils.assertArgNotNull("properties", properties);
            return this.annotations(BeanAnnotation.create(beanClassName).ro(properties).build());
        }

        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            AssertionUtils.assertArgNotNull("beanClass", beanClass);
            AssertionUtils.assertArgNotNull("properties", properties);
            return this.annotations(BeanAnnotation.create(beanClass).wo(properties).build());
        }

        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            AssertionUtils.assertArgNotNull("values", values);
            values.forEach((k, v) -> this.annotations(BeanAnnotation.create(k).wo(Utils.s(v)).build()));
            return this;
        }

        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            AssertionUtils.assertArgNotNull("beanClassName", beanClassName);
            AssertionUtils.assertArgNotNull("properties", properties);
            return this.annotations(BeanAnnotation.create(beanClassName).wo(properties).build());
        }

        public Builder beansRequireDefaultConstructor() {
            return this.beansRequireDefaultConstructor(true);
        }

        public Builder beansRequireDefaultConstructor(boolean value) {
            this.beansRequireDefaultConstructor = value;
            return this;
        }

        public Builder beansRequireSerializable() {
            return this.beansRequireSerializable(true);
        }

        public Builder beansRequireSerializable(boolean value) {
            this.beansRequireSerializable = value;
            return this;
        }

        public Builder beansRequireSettersForGetters() {
            return this.beansRequireSettersForGetters(true);
        }

        public Builder beansRequireSettersForGetters(boolean value) {
            this.beansRequireSettersForGetters = value;
            return this;
        }

        @Override
        public BeanContext build() {
            return this.cache(CACHE).build(BeanContext.class);
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            AssertionUtils.assertArgNotNull("on", on);
            AssertionUtils.assertArgNoNulls("values", values);
            return this.annotations(BeanAnnotation.create(on).dictionary(values).build());
        }

        public Builder disableBeansRequireSomeProperties() {
            return this.disableBeansRequireSomeProperties(true);
        }

        public Builder disableBeansRequireSomeProperties(boolean value) {
            this.disableBeansRequireSomeProperties = value;
            return this;
        }

        public Builder disableIgnoreMissingSetters() {
            return this.disableIgnoreMissingSetters(true);
        }

        public Builder disableIgnoreMissingSetters(boolean value) {
            this.disableIgnoreMissingSetters = value;
            return this;
        }

        public Builder disableIgnoreTransientFields() {
            return this.disableIgnoreTransientFields(true);
        }

        public Builder disableIgnoreTransientFields(boolean value) {
            this.disableIgnoreTransientFields = value;
            return this;
        }

        public Builder disableIgnoreUnknownNullBeanProperties() {
            return this.disableIgnoreUnknownNullBeanProperties(true);
        }

        public Builder disableIgnoreUnknownNullBeanProperties(boolean value) {
            this.disableIgnoreUnknownNullBeanProperties = value;
            return this;
        }

        public Builder disableInterfaceProxies() {
            return this.disableInterfaceProxies(true);
        }

        public Builder disableInterfaceProxies(boolean value) {
            this.disableInterfaceProxies = value;
            return this;
        }

        public <T> Builder example(Class<T> pojoClass, String json) {
            return this.annotations(MarshalledAnnotation.create(AssertionUtils.assertArgNotNull("pojoClass", pojoClass)).example(json).build());
        }

        public <T> Builder example(Class<T> pojoClass, T o) {
            return this.annotations(MarshalledAnnotation.create(AssertionUtils.assertArgNotNull("pojoClass", pojoClass)).example(Json5.of(o)).build());
        }

        public Builder findFluentSetters() {
            return this.findFluentSetters(true);
        }

        public Builder findFluentSetters(boolean value) {
            this.findFluentSetters = value;
            return this;
        }

        public Builder findFluentSetters(Class<?> on) {
            AssertionUtils.assertArgNotNull("on", on);
            return this.annotations(BeanAnnotation.create(on).findFluentSetters(true).build());
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of(new Object[]{super.hashKey(), this.beanClassVisibility, this.beanConstructorVisibility, this.beanMethodVisibility, this.beanFieldVisibility, this.beanDictionary, this.swaps, this.notBeanClasses, this.notBeanPackages, Builder.integer(this.disableBeansRequireSomeProperties, this.beanMapPutReturnsOldValue, this.beansRequireDefaultConstructor, this.beansRequireSerializable, this.beansRequireSettersForGetters, this.disableIgnoreTransientFields, this.disableIgnoreUnknownNullBeanProperties, this.disableIgnoreMissingSetters, this.disableInterfaceProxies, this.findFluentSetters, this.ignoreInvocationExceptionsOnGetters, this.ignoreInvocationExceptionsOnSetters, this.ignoreUnknownBeanProperties, this.ignoreUnknownEnumValues, this.sortProperties, this.useEnumNames, this.useJavaBeanIntrospector), this.typePropertyName, this.mediaType, this.timeZone, this.locale, this.propertyNamer});
        }

        public Builder ignoreInvocationExceptionsOnGetters() {
            return this.ignoreInvocationExceptionsOnGetters(true);
        }

        public Builder ignoreInvocationExceptionsOnGetters(boolean value) {
            this.ignoreInvocationExceptionsOnGetters = value;
            return this;
        }

        public Builder ignoreInvocationExceptionsOnSetters() {
            return this.ignoreInvocationExceptionsOnSetters(true);
        }

        public Builder ignoreInvocationExceptionsOnSetters(boolean value) {
            this.ignoreInvocationExceptionsOnSetters = value;
            return this;
        }

        public Builder ignoreUnknownBeanProperties() {
            return this.ignoreUnknownBeanProperties(true);
        }

        public Builder ignoreUnknownBeanProperties(boolean value) {
            this.ignoreUnknownBeanProperties = value;
            return this;
        }

        public Builder ignoreUnknownEnumValues() {
            return this.ignoreUnknownEnumValues(true);
        }

        public Builder ignoreUnknownEnumValues(boolean value) {
            this.ignoreUnknownEnumValues = value;
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            AssertionUtils.assertArgNotNull("interfaceClass", interfaceClass);
            AssertionUtils.assertArgNotNull("implClass", implClass);
            return this.annotations(MarshalledAnnotation.create(interfaceClass).implClass(implClass).build());
        }

        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            AssertionUtils.assertArgNotNull("values", values);
            values.forEach((k, v) -> this.annotations(MarshalledAnnotation.create(k).implClass((Class<?>)v).build()));
            return this;
        }

        public Builder interfaceClass(Class<?> on, Class<?> value) {
            AssertionUtils.assertArgNotNull("on", on);
            AssertionUtils.assertArgNotNull("value", value);
            return this.annotations(BeanAnnotation.create(on).interfaceClass(value).build());
        }

        public Builder interfaces(Class<?> ... value) {
            AssertionUtils.assertArgNoNulls("value", value);
            for (Class<?> v : value) {
                this.annotations(BeanAnnotation.create(v).interfaceClass(v).build());
            }
            return this;
        }

        public Builder locale(Locale value) {
            this.locale = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        public Builder mediaType(MediaType value) {
            this.mediaType = value;
            return this;
        }

        public Set<ClassInfo> notBeanClasses() {
            return this.notBeanClasses;
        }

        public Builder notBeanClasses(Class<?> ... values) {
            AssertionUtils.assertArgNoNulls("values", values);
            return this.notBeanClasses((ClassInfo[])Stream.of(values).map(ReflectionUtils::info).toArray(ClassInfo[]::new));
        }

        public Builder notBeanClasses(ClassInfo ... values) {
            AssertionUtils.assertArgNoNulls("values", values);
            this.notBeanClasses().addAll(CollectionUtils.l(values));
            return this;
        }

        public Builder notBeanClasses(Collection<ClassInfo> values) {
            AssertionUtils.assertArgNoNulls("values", values);
            this.notBeanClasses().addAll(values);
            return this;
        }

        public Set<String> notBeanPackages() {
            return this.notBeanPackages;
        }

        public Builder notBeanPackages(Collection<String> values) {
            AssertionUtils.assertArgNoNulls("values", values);
            this.notBeanPackages().addAll(values);
            return this;
        }

        public Builder notBeanPackages(String ... values) {
            AssertionUtils.assertArgNoNulls("values", values);
            return this.notBeanPackages(CollectionUtils.l(values));
        }

        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            AssertionUtils.assertArgNotNull("on", on);
            AssertionUtils.assertArgNotNull("value", value);
            return this.annotations(BeanAnnotation.create(on).propertyNamer(value).build());
        }

        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            this.propertyNamer = value;
            return this;
        }

        public Builder sortProperties() {
            this.sortProperties = true;
            return this.sortProperties(true);
        }

        public Builder sortProperties(boolean value) {
            this.sortProperties = value;
            return this;
        }

        public Builder sortProperties(Class<?> ... on) {
            AssertionUtils.assertArgNoNulls("on", on);
            for (Class<?> c : on) {
                this.annotations(BeanAnnotation.create(c).sort(true).build());
            }
            return this;
        }

        public Builder stopClass(Class<?> on, Class<?> value) {
            AssertionUtils.assertArgNotNull("on", on);
            AssertionUtils.assertArgNotNull("value", value);
            return this.annotations(BeanAnnotation.create(on).stopClass(value).build());
        }

        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            return this.swap(normalClass, swappedClass, swapFunction, null);
        }

        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            AssertionUtils.assertArgNotNull("normalClass", normalClass);
            AssertionUtils.assertArgNotNull("swappedClass", swappedClass);
            AssertionUtils.assertArgNotNull("swapFunction", swapFunction);
            AssertionUtils.assertArgNotNull("unswapFunction", unswapFunction);
            this.swaps().add(0, new FunctionalSwap<T, S>(normalClass, swappedClass, swapFunction, unswapFunction));
            return this;
        }

        public List<Object> swaps() {
            return this.swaps;
        }

        public Builder swaps(Class<?> ... values) {
            AssertionUtils.assertArgNoNulls("values", values);
            this.swaps().addAll(0, CollectionUtils.accumulate(values));
            return this;
        }

        public Builder swaps(Object ... values) {
            AssertionUtils.assertArgNoNulls("values", values);
            this.swaps().addAll(0, CollectionUtils.accumulate(values));
            return this;
        }

        public Builder timeZone(TimeZone value) {
            this.timeZone = value;
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            AssertionUtils.assertArgNotNull("value", value);
            super.type(value);
            return this;
        }

        public Builder typeName(Class<?> on, String value) {
            AssertionUtils.assertArgNotNull("on", on);
            AssertionUtils.assertArgNotNull("value", value);
            return this.annotations(BeanAnnotation.create(on).typeName(value).build());
        }

        public Builder typePropertyName(Class<?> on, String value) {
            AssertionUtils.assertArgNotNull("on", on);
            AssertionUtils.assertArgNotNull("value", value);
            return this.annotations(BeanAnnotation.create(on).typePropertyName(value).build());
        }

        public Builder typePropertyName(String value) {
            this.typePropertyName = AssertionUtils.assertArgNotNull("value", value);
            return this;
        }

        public Builder useEnumNames() {
            return this.useEnumNames(true);
        }

        public Builder useEnumNames(boolean value) {
            this.useEnumNames = value;
            return this;
        }

        public Builder useJavaBeanIntrospector() {
            return this.useJavaBeanIntrospector(true);
        }

        public Builder useJavaBeanIntrospector(boolean value) {
            this.useJavaBeanIntrospector = value;
            return this;
        }
    }
}

