/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.part.BasicPart;

public class BasicCsvArrayPart
extends BasicPart {
    private static final String[] EMPTY = new String[0];
    private final String[] value;
    private final Supplier<String[]> supplier;
    private String stringValue;

    public static BasicCsvArrayPart of(String name, String ... value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicCsvArrayPart(name, value);
    }

    public static BasicCsvArrayPart of(String name, Supplier<String[]> value) {
        if (StringUtils.isEmpty(name) || value == null) {
            return null;
        }
        return new BasicCsvArrayPart(name, value);
    }

    public BasicCsvArrayPart(String name, String ... value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
        this.stringValue = null;
    }

    public BasicCsvArrayPart(String name, String value) {
        super(name, value);
        this.value = StringUtils.splita(value);
        this.supplier = null;
        this.stringValue = value;
    }

    public BasicCsvArrayPart(String name, Supplier<String[]> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
        this.stringValue = null;
    }

    public Optional<String[]> asArray() {
        return Utils.opt(CollectionUtils.copyOf(this.value()));
    }

    public Optional<List<String>> asList() {
        return Utils.opt(this.toList());
    }

    public FluentListAssertion<String, BasicCsvArrayPart> assertList() {
        return new FluentListAssertion<String, BasicCsvArrayPart>(CollectionUtils.u(CollectionUtils.l(this.value())), this);
    }

    public boolean contains(String val) {
        if (Utils.nn(val)) {
            for (String v : this.value()) {
                if (!Utils.eq(v, val)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsIgnoreCase(String val) {
        if (Utils.nn(val)) {
            for (String v : this.value()) {
                if (!Utils.eqic(v, val)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getValue() {
        if (Utils.nn(this.supplier)) {
            return StringUtils.join((Object[])this.supplier.get(), ',');
        }
        if (Utils.nn(this.stringValue)) {
            this.stringValue = StringUtils.join((Object[])this.value, ',');
        }
        return this.stringValue;
    }

    public String[] orElse(String[] other) {
        String[] x = this.value();
        return Utils.nn(x) ? x : other;
    }

    public String[] toArray() {
        return CollectionUtils.copyOf(this.value());
    }

    public List<String> toList() {
        return CollectionUtils.u(CollectionUtils.l(this.value()));
    }

    private String[] value() {
        if (Utils.nn(this.supplier)) {
            String[] v = this.supplier.get();
            return Utils.nn(v) ? v : EMPTY;
        }
        return this.value;
    }
}

