/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanMetaFiltered;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.annotation.Swap;
import org.apache.juneau.annotation.Uri;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.lang.Flag;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.BeanRuntimeException;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.reflect.TypeVariables;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.internal.DelegateList;
import org.apache.juneau.internal.FilteredKeyMap;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.swap.Surrogate;
import org.apache.juneau.swaps.StringFormatSwap;

public class BeanPropertyMeta
implements Comparable<BeanPropertyMeta> {
    private final AnnotationProvider ap;
    private final Supplier<List<AnnotationInfo<?>>> annotations = Utils.mem(() -> this.findAnnotations());
    private final BeanContext bc;
    private final BeanMeta<?> beanMeta;
    private final BeanRegistry beanRegistry;
    private final boolean canRead;
    private final boolean canWrite;
    private final BeanPropertyMeta delegateFor;
    private final MethodInfo extraKeys;
    private final FieldInfo field;
    private final MethodInfo getter;
    private final int hashCode;
    private final FieldInfo innerField;
    private final boolean isDyna;
    private final boolean isDynaGetterMap;
    private final boolean isUri;
    private final String name;
    private final Object overrideValue;
    private final List<String> properties;
    private final ClassMeta<?> rawTypeMeta;
    private final boolean readOnly;
    private final MethodInfo setter;
    private final ObjectSwap swap;
    private final ClassMeta<?> typeMeta;
    private final boolean writeOnly;

    public static Builder builder(BeanMeta<?> beanMeta, String name) {
        return new Builder(beanMeta, name);
    }

    protected BeanPropertyMeta(Builder b) {
        this.bc = b.bc;
        this.beanMeta = b.beanMeta;
        this.beanRegistry = b.beanRegistry;
        this.canRead = b.canRead;
        this.canWrite = b.canWrite;
        this.delegateFor = b.delegateFor;
        this.extraKeys = b.extraKeys;
        this.field = b.field;
        this.getter = b.getter;
        this.innerField = b.innerField;
        this.isDyna = b.isDyna;
        this.isDynaGetterMap = b.isDynaGetterMap;
        this.isUri = b.isUri;
        this.name = b.name;
        this.overrideValue = b.overrideValue;
        this.properties = CollectionUtils.u(b.properties);
        this.rawTypeMeta = b.rawTypeMeta;
        this.readOnly = b.readOnly;
        this.setter = b.setter;
        this.swap = b.swap;
        this.typeMeta = b.typeMeta;
        this.writeOnly = b.writeOnly;
        this.ap = this.bc.getAnnotationProvider();
        this.hashCode = Utils.h((Object[])new Object[]{this.beanMeta, this.name});
    }

    public void add(BeanMap<?> m, String pName, Object value) throws BeanRuntimeException {
        if (m.bean == null) {
            if (!m.propertyCache.containsKey(this.name)) {
                m.propertyCache.put(this.name, new JsonList(m.getBeanSession()));
            }
            ((JsonList)m.propertyCache.get(this.name)).add(value);
            return;
        }
        BeanSession session = m.getBeanSession();
        boolean isCollection = this.rawTypeMeta.isCollection();
        boolean isArray = this.rawTypeMeta.isArray();
        if (!isCollection && !isArray) {
            throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Attempt to add element to property ''{0}'' which is not a collection or array", (Object[])new Object[]{this.name});
        }
        Object bean = m.getBean(true);
        ClassMeta<?> elementType = this.rawTypeMeta.getElementType();
        try {
            Object v = session.convertToType(value, elementType);
            if (isCollection) {
                Collection c = (Collection)this.invokeGetter(bean, pName);
                Collection c2 = null;
                if (Utils.nn((Object)c)) {
                    if (ClassUtils.canAddTo((Collection)c)) {
                        c.add(v);
                        return;
                    }
                    c2 = c;
                }
                c = this.rawTypeMeta.canCreateNewInstance() ? (Collection)this.rawTypeMeta.newInstance() : new JsonList(session);
                if (c2 != null) {
                    c.addAll(c2);
                }
                c.add(v);
                this.invokeSetter(bean, pName, c);
            } else {
                List<?> l;
                if (m.arrayPropertyCache == null) {
                    m.arrayPropertyCache = new TreeMap();
                }
                if ((l = m.arrayPropertyCache.get(this.name)) == null) {
                    l = new LinkedList();
                    m.arrayPropertyCache.put(this.name, l);
                    Object oldArray = this.invokeGetter(bean, pName);
                    CollectionUtils.copyArrayToList((Object)oldArray, l);
                }
                l.add(v);
            }
        }
        catch (BeanRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ThrowableUtils.bex((Throwable)e);
        }
    }

    public void add(BeanMap<?> m, String pName, String key, Object value) throws BeanRuntimeException {
        if (m.bean == null) {
            if (!m.propertyCache.containsKey(this.name)) {
                m.propertyCache.put(this.name, new JsonMap(m.getBeanSession()));
            }
            ((JsonMap)m.propertyCache.get(this.name)).append(key.toString(), value);
            return;
        }
        BeanSession session = m.getBeanSession();
        boolean isMap = this.rawTypeMeta.isMap();
        boolean isBean = this.rawTypeMeta.isBean();
        if (!isBean && !isMap) {
            throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Attempt to add key/value to property ''{0}'' which is not a map or bean", (Object[])new Object[]{this.name});
        }
        Object bean = m.getBean(true);
        try {
            Object v = session.convertToType(value, this.rawTypeMeta.getElementType());
            if (isMap) {
                Map map = (Map)this.invokeGetter(bean, pName);
                if (Utils.nn((Object)map)) {
                    map.put(key, v);
                    return;
                }
                map = this.rawTypeMeta.canCreateNewInstance() ? (Map)this.rawTypeMeta.newInstance() : new JsonMap(session);
                map.put(key, v);
                this.invokeSetter(bean, pName, map);
            } else {
                Object b = this.invokeGetter(bean, pName);
                if (Utils.nn((Object)b)) {
                    session.toBeanMap(b).put(key, v);
                    return;
                }
                if (this.rawTypeMeta.canCreateNewInstance(m.getBean(false))) {
                    b = this.rawTypeMeta.newInstance();
                    session.toBeanMap(b).put(key, v);
                }
                this.invokeSetter(bean, pName, b);
            }
        }
        catch (BeanRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ThrowableUtils.bex((Throwable)e);
        }
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    @Override
    public int compareTo(BeanPropertyMeta o) {
        return Utils.cmp((Object)this.name, (Object)o.name);
    }

    public boolean equals(Object o) {
        BeanPropertyMeta o2;
        return o instanceof BeanPropertyMeta && Utils.eq((Object)this, (Object)(o2 = (BeanPropertyMeta)o), (x, y) -> Utils.eq((Object)x.name, (Object)y.name) && Utils.eq(x.beanMeta, y.beanMeta));
    }

    public List<AnnotationInfo> getAnnotations() {
        return this.annotations.get();
    }

    public <A extends Annotation> Stream<AnnotationInfo<A>> getAnnotations(Class<A> a) {
        if (a == null) {
            return Stream.empty();
        }
        return this.annotations.get().stream().filter(x -> x.isType(a)).map(x -> x);
    }

    private List<AnnotationInfo<?>> findAnnotations() {
        ArrayList result = new ArrayList();
        if (Utils.nn((Object)this.field)) {
            result.addAll(this.ap.find(this.field, new AnnotationTraversal[0]));
        }
        if (Utils.nn((Object)this.getter)) {
            result.addAll(this.ap.find(this.getter, new AnnotationTraversal[]{AnnotationTraversal.SELF, AnnotationTraversal.MATCHING_METHODS, AnnotationTraversal.RETURN_TYPE, AnnotationTraversal.PACKAGE}));
        }
        if (Utils.nn((Object)this.setter)) {
            result.addAll(this.ap.find(this.setter, new AnnotationTraversal[]{AnnotationTraversal.SELF, AnnotationTraversal.MATCHING_METHODS, AnnotationTraversal.RETURN_TYPE, AnnotationTraversal.PACKAGE}));
        }
        if (Utils.nn((Object)this.extraKeys)) {
            result.addAll(this.ap.find(this.extraKeys, new AnnotationTraversal[]{AnnotationTraversal.SELF, AnnotationTraversal.MATCHING_METHODS, AnnotationTraversal.RETURN_TYPE, AnnotationTraversal.PACKAGE}));
        }
        return CollectionUtils.u(result);
    }

    public Object get(BeanMap<?> m, String pName) {
        return m.meta.onReadProperty(m.bean, pName, this.getInner(m, pName));
    }

    public BeanMeta<?> getBeanMeta() {
        return this.beanMeta;
    }

    public BeanRegistry getBeanRegistry() {
        return this.beanRegistry;
    }

    public ClassMeta<?> getClassMeta() {
        return this.typeMeta;
    }

    public BeanPropertyMeta getDelegateFor() {
        return (BeanPropertyMeta)Utils.def((Object)this.delegateFor, (Object)this);
    }

    public Map<String, Object> getDynaMap(Object bean) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.isDyna) {
            if (Utils.nn((Object)this.extraKeys) && Utils.nn((Object)this.getter) && !this.isDynaGetterMap) {
                LinkedHashMap m = CollectionUtils.map();
                ((Collection)this.extraKeys.invoke(bean, new Object[0])).forEach(x -> Utils.safe(() -> m.put(x, this.getter.invoke(bean, new Object[]{x}))));
                return m;
            }
            if (Utils.nn((Object)this.getter) && this.isDynaGetterMap) {
                return (Map)this.getter.invoke(bean, new Object[0]);
            }
            if (Utils.nn((Object)this.field)) {
                return (Map)this.field.get(bean);
            }
            throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Getter or public field not defined on property ''{0}''", (Object[])new Object[]{this.name});
        }
        return CollectionUtils.mape();
    }

    public FieldInfo getField() {
        return this.field;
    }

    public MethodInfo getGetter() {
        return this.getter;
    }

    public FieldInfo getInnerField() {
        return this.innerField;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public Object getRaw(BeanMap<?> m, String pName) {
        try {
            Object bean = m.bean;
            if (bean == null) {
                return m.propertyCache.get(this.name);
            }
            return this.invokeGetter(bean, pName);
        }
        catch (Throwable e) {
            if (this.bc.isIgnoreInvocationExceptionsOnGetters()) {
                if (this.rawTypeMeta.isPrimitive()) {
                    return this.rawTypeMeta.getPrimitiveDefault();
                }
                return null;
            }
            throw ThrowableUtils.bex((Throwable)e, this.beanMeta.getClassMeta(), (String)"Exception occurred while getting property ''{0}''", (Object[])new Object[]{this.name});
        }
    }

    public MethodInfo getSetter() {
        return this.setter;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isDyna() {
        return this.isDyna;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isUri() {
        return this.isUri;
    }

    public Object set(BeanMap<?> m, String pName, Object value) throws BeanRuntimeException {
        Object value1 = m.meta.onWriteProperty(m.bean, pName, value);
        try {
            if (this.readOnly) {
                return null;
            }
            BeanSession session = m.getBeanSession();
            value1 = this.unswap(session, value1);
            if (m.bean == null) {
                if (Utils.nn(m.propertyCache)) {
                    return m.propertyCache.put(this.name, value1);
                }
                throw ThrowableUtils.bex((String)"Non-existent bean instance on bean.", (Object[])new Object[0]);
            }
            boolean isMap = this.rawTypeMeta.isMap();
            boolean isCollection = this.rawTypeMeta.isCollection();
            if (!(this.isDyna || this.field != null || this.setter != null || isMap || isCollection)) {
                if (value1 == null && this.bc.isIgnoreUnknownNullBeanProperties() || this.bc.isIgnoreMissingSetters()) {
                    return null;
                }
                throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Setter or public field not defined on property ''{0}''", (Object[])new Object[]{this.name});
            }
            Object bean = m.getBean(true);
            try {
                Class<?> vc;
                Object r = !(!this.bc.isBeanMapPutReturnsOldValue() && !isMap && !isCollection || !Utils.nn((Object)this.getter) && !Utils.nn((Object)this.field)) ? this.get(m, pName) : null;
                Class propertyClass = this.rawTypeMeta.inner();
                ClassMeta<?> pcInfo = this.rawTypeMeta;
                if (value1 == null && (isMap || isCollection)) {
                    this.invokeSetter(bean, pName, null);
                    return r;
                }
                Class<?> clazz = vc = value1 == null ? null : value1.getClass();
                if (isMap && (this.setter == null || !pcInfo.isParentOf(vc))) {
                    if (!(value1 instanceof Map)) {
                        if (value1 instanceof CharSequence) {
                            CharSequence value21 = (CharSequence)value1;
                            value1 = JsonMap.ofJson(value21).session(session);
                        } else {
                            throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}''", (Object[])new Object[]{this.name, propertyClass.getName(), Utils.cn((Object)value1)});
                        }
                    }
                    Map valueMap = (Map)value1;
                    Map propMap = (Map)r;
                    ClassMeta<?> valueType = this.rawTypeMeta.getValueType();
                    if (!this.rawTypeMeta.canCreateNewInstance()) {
                        if (propMap == null) {
                            if (this.setter == null && this.field == null) {
                                throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because no setter or public field is defined, and the current value is null", (Object[])new Object[]{this.name, propertyClass.getName(), Utils.cn((Object)value1)});
                            }
                            if (propertyClass.isInstance(valueMap)) {
                                if (!valueType.isObject()) {
                                    Flag needsConversion = Flag.create();
                                    valueMap.forEach((k, v2) -> {
                                        if (Utils.nn((Object)v2) && !valueType.isInstance(v2)) {
                                            needsConversion.set();
                                        }
                                    });
                                    if (needsConversion.isSet()) {
                                        valueMap = (Map)session.convertToType((Object)valueMap, this.rawTypeMeta);
                                    }
                                }
                                this.invokeSetter(bean, pName, valueMap);
                                return r;
                            }
                            throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Cannot set property ''{0}'' of type ''{2}'' to object of type ''{2}'' because the assigned map cannot be converted to the specified type because the property type is abstract, and the property value is currently null", (Object[])new Object[]{this.name, propertyClass.getName(), Utils.cn((Object)value1)});
                        }
                    } else if (propMap == null) {
                        propMap = BeanCreator.of(Map.class).type((ClassInfo)this.rawTypeMeta).run();
                    } else {
                        propMap.clear();
                    }
                    Map propMap2 = propMap;
                    valueMap.forEach((k1, v1) -> {
                        if (!valueType.isObject()) {
                            v1 = session.convertToType(v1, valueType);
                        }
                        propMap2.put(k1, v1);
                    });
                    if (Utils.nn((Object)this.setter) || Utils.nn((Object)this.field)) {
                        this.invokeSetter(bean, pName, propMap);
                    }
                } else if (isCollection && (this.setter == null || !pcInfo.isParentOf(vc))) {
                    if (!(value1 instanceof Collection)) {
                        if (value1 instanceof CharSequence) {
                            CharSequence value2 = (CharSequence)value1;
                            value1 = new JsonList(value2).setBeanSession(session);
                        } else {
                            throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}''", (Object[])new Object[]{this.name, propertyClass.getName(), Utils.cn((Object)value1)});
                        }
                    }
                    Collection valueList = (Collection)value1;
                    Collection propList = (Collection)r;
                    ClassMeta<?> elementType = this.rawTypeMeta.getElementType();
                    if (!this.rawTypeMeta.canCreateNewInstance()) {
                        if (propList == null) {
                            if (this.setter == null && this.field == null) {
                                throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because no setter or public field is defined, and the current value is null", (Object[])new Object[]{this.name, propertyClass.getName(), Utils.cn((Object)value1)});
                            }
                            if (propertyClass.isInstance(valueList) || Utils.nn((Object)this.setter) && ((ClassInfo)this.setter.getParameterTypes().get(0)).is(Collection.class)) {
                                if (!elementType.isObject()) {
                                    JsonList l = new JsonList((Collection<?>)valueList);
                                    ListIterator<?> i = l.listIterator();
                                    while (i.hasNext()) {
                                        Object v = i.next();
                                        if (!Utils.nn(v) || elementType.isInstance(v)) continue;
                                        i.set(session.convertToType(v, elementType));
                                    }
                                    valueList = l;
                                }
                                this.invokeSetter(bean, pName, valueList);
                                return r;
                            }
                            throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because the assigned map cannot be converted to the specified type because the property type is abstract, and the property value is currently null", (Object[])new Object[]{this.name, propertyClass.getName(), Utils.cn((Object)value1)});
                        }
                        propList.clear();
                    } else if (propList == null) {
                        propList = BeanCreator.of(Collection.class).type((ClassInfo)this.rawTypeMeta).run();
                        this.invokeSetter(bean, pName, propList);
                    } else {
                        propList.clear();
                    }
                    Collection propList2 = propList;
                    valueList.forEach(x -> {
                        if (!elementType.isObject()) {
                            x = session.convertToType(x, elementType);
                        }
                        propList2.add(x);
                    });
                } else {
                    value1 = Utils.nn((Object)this.swap) && value1 != null && this.swap.getSwapClass().isParentOf(value1.getClass()) ? this.swap.unswap(session, value1, this.rawTypeMeta) : session.convertToType(value1, this.rawTypeMeta);
                    this.invokeSetter(bean, pName, value1);
                }
                return r;
            }
            catch (BeanRuntimeException e) {
                throw e;
            }
            catch (Exception e1) {
                if (this.bc.isIgnoreInvocationExceptionsOnSetters()) {
                    if (this.rawTypeMeta.isPrimitive()) {
                        return this.rawTypeMeta.getPrimitiveDefault();
                    }
                    return null;
                }
                throw ThrowableUtils.bex((Throwable)e1, this.beanMeta.getClassMeta(), (String)"Error occurred trying to set property ''{0}''", (Object[])new Object[]{this.name});
            }
        }
        catch (ParseException e2) {
            throw ThrowableUtils.bex((Throwable)e2);
        }
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a((Object)"field", (Object)this.field).a((Object)"getter", (Object)this.getter).a((Object)"name", (Object)this.name).a((Object)"setter", (Object)this.setter).a((Object)"type", (Object)Utils.cn(this.rawTypeMeta));
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    private Object applyChildPropertiesFilter(BeanSession session, ClassMeta cm, Object o) {
        if (o == null) {
            return null;
        }
        if (cm.isBean()) {
            return new BeanMap<Object>(session, o, new BeanMetaFiltered(cm.getBeanMeta(), this.properties));
        }
        if (cm.isMap()) {
            String[] propsArray = this.properties == null ? null : this.properties.toArray(new String[0]);
            return new FilteredKeyMap(cm, (Map)o, propsArray);
        }
        if (cm.isObject()) {
            if (o instanceof Map) {
                Map o2 = (Map)o;
                String[] propsArray = this.properties == null ? null : this.properties.toArray(new String[0]);
                return new FilteredKeyMap(cm, o2, propsArray);
            }
            BeanMeta<?> bm = this.bc.getBeanMeta(o.getClass());
            if (Utils.nn(bm)) {
                return new BeanMap<Object>(session, o, new BeanMetaFiltered(cm.getBeanMeta(), this.properties));
            }
        }
        return o;
    }

    private Object getInner(BeanMap<?> m, String pName) {
        try {
            if (this.writeOnly) {
                return null;
            }
            if (Utils.nn((Object)this.overrideValue)) {
                return this.overrideValue;
            }
            Object bean = m.bean;
            if (bean == null) {
                return m.propertyCache.get(this.name);
            }
            BeanSession session = m.getBeanSession();
            Object o = this.getRaw(m, pName);
            try {
                o = this.swap(session, o);
                if (o == null) {
                    return null;
                }
                if (Utils.nn(this.properties)) {
                    if (this.rawTypeMeta.isArray()) {
                        Object[] a = (Object[])o;
                        DelegateList l1 = new DelegateList(this.rawTypeMeta);
                        ClassMeta<?> childType1 = this.rawTypeMeta.getElementType();
                        for (Object c1 : a) {
                            l1.add(this.applyChildPropertiesFilter(session, childType1, c1));
                        }
                        return l1;
                    }
                    if (this.rawTypeMeta.isCollection()) {
                        Collection c = (Collection)o;
                        ArrayList l = CollectionUtils.listOfSize((int)c.size());
                        ClassMeta<?> childType = this.rawTypeMeta.getElementType();
                        c.forEach(x -> l.add(this.applyChildPropertiesFilter(session, childType, x)));
                        return l;
                    }
                    return this.applyChildPropertiesFilter(session, this.rawTypeMeta, o);
                }
                return o;
            }
            catch (SerializeException e) {
                throw ThrowableUtils.bex((Throwable)e);
            }
        }
        catch (Throwable e) {
            if (this.bc.isIgnoreInvocationExceptionsOnGetters()) {
                if (this.rawTypeMeta.isPrimitive()) {
                    return this.rawTypeMeta.getPrimitiveDefault();
                }
                return null;
            }
            throw ThrowableUtils.bex((Throwable)e, this.beanMeta.getClassMeta(), (String)"Exception occurred while getting property ''{0}''", (Object[])new Object[]{this.name});
        }
    }

    private Object invokeGetter(Object bean, String pName) throws IllegalArgumentException {
        if (this.isDyna) {
            Map m = null;
            if (Utils.nn((Object)this.getter)) {
                if (!this.isDynaGetterMap) {
                    return this.getter.invoke(bean, new Object[]{pName});
                }
                m = (Map)this.getter.invoke(bean, new Object[0]);
            } else if (Utils.nn((Object)this.field)) {
                m = (Map)this.field.get(bean);
            } else {
                throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Getter or public field not defined on property ''{0}''", (Object[])new Object[]{this.name});
            }
            return m == null ? null : m.get(pName);
        }
        if (Utils.nn((Object)this.getter)) {
            return this.getter.invoke(bean, new Object[0]);
        }
        if (Utils.nn((Object)this.field)) {
            return this.field.get(bean);
        }
        throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Getter or public field not defined on property ''{0}''", (Object[])new Object[]{this.name});
    }

    private Object invokeSetter(Object bean, String pName, Object val) throws IllegalArgumentException {
        if (this.isDyna) {
            if (Utils.nn((Object)this.setter)) {
                return this.setter.invoke(bean, new Object[]{pName, val});
            }
            Map m = null;
            if (Utils.nn((Object)this.field)) {
                m = (Map)this.field.get(bean);
            } else if (Utils.nn((Object)this.getter)) {
                m = (Map)this.getter.invoke(bean, new Object[0]);
            } else {
                throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because no setter is defined on this property, and the existing property value is null", (Object[])new Object[]{this.name, this.getClassMeta().getName(), Utils.cn((Object)val)});
            }
            return m == null ? null : m.put(pName, val);
        }
        if (Utils.nn((Object)this.setter)) {
            return this.setter.invoke(bean, new Object[]{val});
        }
        if (Utils.nn((Object)this.field)) {
            this.field.set(bean, val);
            return null;
        }
        throw ThrowableUtils.bex(this.beanMeta.getClassMeta(), (String)"Cannot set property ''{0}'' of type ''{1}'' to object of type ''{2}'' because no setter is defined on this property, and the existing property value is null", (Object[])new Object[]{this.name, this.getClassMeta().getName(), Utils.cn((Object)val)});
    }

    private Object swap(BeanSession session, Object o) throws SerializeException {
        try {
            ObjectSwap<?, ?> f;
            if (Utils.nn((Object)this.swap)) {
                return this.swap.swap(session, o);
            }
            if (o == null) {
                return null;
            }
            if (this.rawTypeMeta.hasChildSwaps() && Utils.nn(f = this.rawTypeMeta.getChildObjectSwapForSwap(o.getClass()))) {
                return f.swap(session, o);
            }
            return o;
        }
        catch (SerializeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializeException(e);
        }
    }

    private Object unswap(BeanSession session, Object o) throws ParseException {
        try {
            ObjectSwap<?, ?> f;
            if (Utils.nn((Object)this.swap)) {
                return this.swap.unswap(session, o, this.rawTypeMeta);
            }
            if (o == null) {
                return null;
            }
            if (this.rawTypeMeta.hasChildSwaps() && Utils.nn(f = this.rawTypeMeta.getChildObjectSwapForUnswap(o.getClass()))) {
                return f.unswap(session, o, this.rawTypeMeta);
            }
            return o;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    protected boolean isWriteOnly() {
        return this.writeOnly;
    }

    protected void setArray(Object bean, List l) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object array = CollectionUtils.toArray((Collection)l, (Class)this.rawTypeMeta.getElementType().inner());
        this.invokeSetter(bean, this.name, array);
    }

    public static class Builder {
        BeanMeta<?> beanMeta;
        BeanContext bc;
        String name;
        FieldInfo field;
        FieldInfo innerField;
        MethodInfo getter;
        MethodInfo setter;
        MethodInfo extraKeys;
        private boolean isConstructorArg;
        private boolean isUri;
        private boolean isDyna;
        private boolean isDynaGetterMap;
        private ClassMeta<?> rawTypeMeta;
        private ClassMeta<?> typeMeta;
        private List<String> properties;
        private ObjectSwap swap;
        private BeanRegistry beanRegistry;
        private Object overrideValue;
        private BeanPropertyMeta delegateFor;
        private boolean canRead;
        private boolean canWrite;
        private boolean readOnly;
        private boolean writeOnly;

        Builder(BeanMeta<?> beanMeta, String name) {
            this.beanMeta = beanMeta;
            this.bc = beanMeta.getBeanContext();
            this.name = name;
        }

        public Builder beanRegistry(BeanRegistry value) {
            this.beanRegistry = (BeanRegistry)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public BeanPropertyMeta build() {
            return new BeanPropertyMeta(this);
        }

        public Builder delegateFor(BeanPropertyMeta value) {
            this.delegateFor = (BeanPropertyMeta)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder overrideValue(Object value) {
            this.overrideValue = value;
            return this;
        }

        public Builder rawMetaType(ClassMeta<?> value) {
            this.rawTypeMeta = (ClassMeta)((Object)AssertionUtils.assertArgNotNull((String)"value", value));
            this.typeMeta = this.rawTypeMeta;
            return this;
        }

        private static ObjectSwap beanpSwap(AnnotationInfo<Beanp> ai) {
            Beanp p = (Beanp)ai.inner();
            if (!p.format().isEmpty()) {
                return BeanCreator.of(ObjectSwap.class).type(StringFormatSwap.class).arg(String.class, p.format()).run();
            }
            return null;
        }

        private static ObjectSwap swapSwap(AnnotationInfo<Swap> ai) throws RuntimeException {
            Swap s = (Swap)ai.inner();
            Class<?> c = s.value();
            if (ClassUtils.isVoid(c)) {
                c = s.impl();
            }
            if (ClassUtils.isVoid(c)) {
                return null;
            }
            ClassInfoTyped ci = ReflectionUtils.info(c);
            if (ci.isChildOf(ObjectSwap.class)) {
                ObjectSwap ps = BeanCreator.of(ObjectSwap.class).type((ClassInfo)ci).run();
                if (Utils.nn((Object)ps.forMediaTypes())) {
                    throw ThrowableUtils.unsupportedOp((String)"TODO - Media types on swaps not yet supported on bean properties.", (Object[])new Object[0]);
                }
                if (Utils.nn((Object)ps.withTemplate())) {
                    throw ThrowableUtils.unsupportedOp((String)"TODO - Templates on swaps not yet supported on bean properties.", (Object[])new Object[0]);
                }
                return ps;
            }
            if (ci.isChildOf(Surrogate.class)) {
                throw ThrowableUtils.unsupportedOp((String)"TODO - Surrogate swaps not yet supported on bean properties.", (Object[])new Object[0]);
            }
            throw ThrowableUtils.rex((String)"Invalid class used in @Swap annotation.  Must be a subclass of ObjectSwap or Surrogate. {0}", (Object[])new Object[]{Utils.cn(c)});
        }

        public Builder canRead() {
            this.canRead = true;
            return this;
        }

        public Builder canWrite() {
            this.canWrite = true;
            return this;
        }

        public Builder setAsConstructorArg() {
            this.isConstructorArg = true;
            return this;
        }

        public Builder setExtraKeys(MethodInfo value) {
            AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            this.extraKeys = value.accessible();
            return this;
        }

        public Builder setField(FieldInfo value) {
            AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            this.innerField = this.field = value.accessible();
            return this;
        }

        public Builder setGetter(MethodInfo value) {
            AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            this.getter = value.accessible();
            return this;
        }

        public Builder setInnerField(FieldInfo value) {
            this.innerField = (FieldInfo)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder setSetter(MethodInfo value) {
            AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            this.setter = value.accessible();
            return this;
        }

        public boolean validate(BeanContext bc, BeanRegistry parentBeanRegistry, TypeVariables typeVarImpls, Set<String> bpro, Set<String> bpwo) throws Exception {
            List pt;
            List lp;
            List bdClasses = CollectionUtils.list((Object[])new Object[0]);
            AnnotationProvider ap = bc.getAnnotationProvider();
            if (this.field == null && this.getter == null && this.setter == null) {
                return false;
            }
            if (this.field == null && this.setter == null && bc.isBeansRequireSettersForGetters() && !this.isConstructorArg) {
                return false;
            }
            this.canRead |= Utils.nn((Object)this.field) || Utils.nn((Object)this.getter);
            this.canWrite |= Utils.nn((Object)this.field) || Utils.nn((Object)this.setter);
            FieldInfo ifi = this.innerField;
            MethodInfo gi = this.getter;
            MethodInfo si = this.setter;
            if (Utils.nn((Object)this.innerField)) {
                lp = ap.find(Beanp.class, ifi, new AnnotationTraversal[0]);
                if (Utils.nn((Object)this.field) || Utils.ne((Collection)lp)) {
                    this.rawTypeMeta = bc.resolveClassMeta((AnnotationInfo<Beanp>)((AnnotationInfo)Utils.opt((Object)((AnnotationInfo)CollectionUtils.last((List)lp))).orElse(null)), this.innerField.getFieldType(), typeVarImpls);
                    this.isUri |= this.rawTypeMeta.isUri();
                }
                lp.forEach(x -> {
                    Beanp beanp = (Beanp)x.inner();
                    if (this.swap == null) {
                        this.swap = Builder.beanpSwap((AnnotationInfo<Beanp>)x);
                    }
                    if (Utils.ne((CharSequence)beanp.properties())) {
                        this.properties = StringUtils.split((String)beanp.properties());
                    }
                    bdClasses.addAll(CollectionUtils.l((Object[])beanp.dictionary()));
                    if (Utils.ne((CharSequence)beanp.ro())) {
                        this.readOnly = Utils.bool((Object)beanp.ro());
                    }
                    if (Utils.ne((CharSequence)beanp.wo())) {
                        this.writeOnly = Utils.bool((Object)beanp.wo());
                    }
                });
                ap.find(Swap.class, ifi, new AnnotationTraversal[0]).stream().findFirst().ifPresent(x -> {
                    this.swap = Builder.swapSwap((AnnotationInfo<Swap>)x);
                });
                this.isUri |= ap.has(Uri.class, ifi, new AnnotationTraversal[0]);
            }
            if (Utils.nn((Object)this.getter)) {
                lp = ap.find(Beanp.class, gi, new AnnotationTraversal[0]);
                if (this.rawTypeMeta == null) {
                    this.rawTypeMeta = bc.resolveClassMeta((AnnotationInfo<Beanp>)((AnnotationInfo)Utils.opt((Object)((AnnotationInfo)CollectionUtils.last((List)lp))).orElse(null)), this.getter.getReturnType(), typeVarImpls);
                }
                this.isUri |= this.rawTypeMeta.isUri() || ap.has(Uri.class, gi, new AnnotationTraversal[0]);
                lp.forEach(x -> {
                    Beanp beanp = (Beanp)x.inner();
                    if (this.swap == null) {
                        this.swap = Builder.beanpSwap((AnnotationInfo<Beanp>)x);
                    }
                    if (Utils.nn(this.properties) && Utils.ne((CharSequence)beanp.properties())) {
                        this.properties = StringUtils.split((String)beanp.properties());
                    }
                    bdClasses.addAll(CollectionUtils.l((Object[])beanp.dictionary()));
                    if (Utils.ne((CharSequence)beanp.ro())) {
                        this.readOnly = Utils.bool((Object)beanp.ro());
                    }
                    if (Utils.ne((CharSequence)beanp.wo())) {
                        this.writeOnly = Utils.bool((Object)beanp.wo());
                    }
                });
                ap.find(Swap.class, gi, new AnnotationTraversal[0]).stream().forEach(x -> {
                    this.swap = Builder.swapSwap((AnnotationInfo<Swap>)x);
                });
            }
            if (Utils.nn((Object)this.setter)) {
                lp = ap.find(Beanp.class, si, new AnnotationTraversal[0]);
                if (this.rawTypeMeta == null) {
                    this.rawTypeMeta = bc.resolveClassMeta((AnnotationInfo<Beanp>)((AnnotationInfo)Utils.opt((Object)((AnnotationInfo)CollectionUtils.last((List)lp))).orElse(null)), (ClassInfo)this.setter.getParameterTypes().get(0), typeVarImpls);
                }
                this.isUri |= this.rawTypeMeta.isUri() || ap.has(Uri.class, si, new AnnotationTraversal[0]);
                lp.forEach(x -> {
                    Beanp beanp = (Beanp)x.inner();
                    if (this.swap == null) {
                        this.swap = Builder.beanpSwap((AnnotationInfo<Beanp>)x);
                    }
                    if (Utils.nn(this.properties) && Utils.ne((CharSequence)beanp.properties())) {
                        this.properties = StringUtils.split((String)beanp.properties());
                    }
                    bdClasses.addAll(CollectionUtils.l((Object[])beanp.dictionary()));
                    if (Utils.ne((CharSequence)beanp.ro())) {
                        this.readOnly = Utils.bool((Object)beanp.ro());
                    }
                    if (Utils.ne((CharSequence)beanp.wo())) {
                        this.writeOnly = Utils.bool((Object)beanp.wo());
                    }
                });
                ap.find(Swap.class, si, new AnnotationTraversal[0]).stream().forEach(x -> {
                    this.swap = Builder.swapSwap((AnnotationInfo<Swap>)x);
                });
            }
            if (this.rawTypeMeta == null) {
                return false;
            }
            this.beanRegistry = new BeanRegistry(bc, parentBeanRegistry, bdClasses.stream().map(ReflectionUtils::info).toList());
            this.isDyna = "*".equals(this.name);
            ClassMeta<?> ci = this.rawTypeMeta;
            if (Utils.nn((Object)this.getter)) {
                pt = this.getter.getParameterTypes();
                if (this.isDyna) {
                    if (ci.isChildOf(Map.class) && Utils.e((Collection)pt)) {
                        this.isDynaGetterMap = true;
                    } else if (pt.size() != 1 || !((ClassInfo)pt.get(0)).is(String.class)) {
                        return false;
                    }
                } else if (!ci.isChildOf(this.getter.getReturnType())) {
                    return false;
                }
            }
            if (Utils.nn((Object)this.setter)) {
                pt = this.setter.getParameterTypes();
                if (this.isDyna) {
                    if (pt.size() != 2 || !((ClassInfo)pt.get(0)).is(String.class)) {
                        return false;
                    }
                } else if (pt.size() != 1 || !ci.isChildOf(((ClassInfo)pt.get(0)).inner())) {
                    return false;
                }
            }
            if (Utils.nn((Object)this.field) && (this.isDyna ? !this.field.getFieldType().isChildOf(Map.class) : !ci.isChildOf(this.field.getFieldType()))) {
                return false;
            }
            if (this.isDyna) {
                this.rawTypeMeta = this.rawTypeMeta.getValueType();
                if (this.rawTypeMeta == null) {
                    this.rawTypeMeta = bc.object();
                }
            }
            if (this.rawTypeMeta == null) {
                return false;
            }
            if (this.typeMeta == null) {
                ClassMeta<Object> classMeta = Utils.nn((Object)this.swap) ? bc.getClassMeta((Type)this.swap.getSwapClass(), new Type[0]) : (this.typeMeta = this.rawTypeMeta == null ? bc.object() : this.rawTypeMeta);
            }
            if (this.typeMeta == null) {
                this.typeMeta = this.rawTypeMeta;
            }
            if (bpro.contains(this.name) || bpro.contains("*")) {
                this.readOnly = true;
            }
            if (bpwo.contains(this.name) || bpwo.contains("*")) {
                this.writeOnly = true;
            }
            return true;
        }
    }
}

