/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.jsonschema;

public enum JsonType {
    ARRAY("array"),
    BOOLEAN("boolean"),
    INTEGER("integer"),
    NULL("null"),
    NUMBER("number"),
    OBJECT("object"),
    STRING("string"),
    ANY("any");

    private final String value;

    public static JsonType fromString(String value) {
        if (value == null || value.length() < 4) {
            return null;
        }
        char c = value.charAt(0);
        if (c == 'a') {
            if (value.equals("array")) {
                return ARRAY;
            }
            if (value.equals("any")) {
                return ANY;
            }
        }
        if (c == 'b' && value.equals("boolean")) {
            return BOOLEAN;
        }
        if (c == 'i' && value.equals("integer")) {
            return INTEGER;
        }
        if (c == 'n') {
            c = value.charAt(2);
            if (c == 'l' && value.equals("null")) {
                return NULL;
            }
            if (c == 'm' && value.equals("number")) {
                return NUMBER;
            }
            return null;
        }
        if (c == 'o' && value.equals("object")) {
            return OBJECT;
        }
        if (c == 's' && value.equals("string")) {
            return STRING;
        }
        return null;
    }

    private JsonType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }
}

