/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.nio.charset.Charset;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentPrimitiveArrayAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;

public class FluentByteArrayAssertion<R>
extends FluentPrimitiveArrayAssertion<Byte, byte[], R> {
    public FluentByteArrayAssertion(Assertion creator, byte[] value, R returns) {
        super(creator, value, returns);
    }

    public FluentByteArrayAssertion(byte[] value, R returns) {
        this((Assertion)null, value, returns);
    }

    public FluentStringAssertion<R> asBase64() {
        return new FluentStringAssertion((Assertion)this, this.valueIsNull() ? null : StringUtils.base64Encode((byte[])this.value()), this.returns());
    }

    public FluentStringAssertion<R> asHex() {
        return new FluentStringAssertion((Assertion)this, this.valueIsNull() ? null : StringUtils.toHex((byte[])this.value()), this.returns());
    }

    public FluentStringAssertion<R> asSpacedHex() {
        return new FluentStringAssertion((Assertion)this, this.valueIsNull() ? null : StringUtils.toSpacedHex((byte[])this.value()), this.returns());
    }

    @Override
    public FluentStringAssertion<R> asString() {
        return this.asString(IoUtils.UTF8);
    }

    public FluentStringAssertion<R> asString(Charset cs) {
        return new FluentStringAssertion((Assertion)this, this.valueIsNull() ? null : new String((byte[])this.value(), cs), this.returns());
    }

    @Override
    public FluentByteArrayAssertion<R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentByteArrayAssertion<R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentByteArrayAssertion<R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentByteArrayAssertion<R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentByteArrayAssertion<R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }
}

