/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.IrRowPatternVisitor;

public class IrQuantified
extends IrRowPattern {
    private final IrRowPattern pattern;
    private final IrQuantifier quantifier;

    public IrQuantified(IrRowPattern pattern, IrQuantifier quantifier) {
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.quantifier = Objects.requireNonNull(quantifier, "quantifier is null");
    }

    public IrRowPattern getPattern() {
        return this.pattern;
    }

    public IrQuantifier getQuantifier() {
        return this.quantifier;
    }

    @Override
    public <R, C> R accept(IrRowPatternVisitor<R, C> visitor, C context) {
        return visitor.visitIrQuantified(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrQuantified o = (IrQuantified)obj;
        return Objects.equals(this.pattern, o.pattern) && Objects.equals(this.quantifier, o.quantifier);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.quantifier);
    }

    public String toString() {
        return this.pattern.toString() + this.quantifier;
    }

    public static void serialize(IrQuantified pattern, ByteBuffer byteBuffer) {
        IrRowPattern.serialize(pattern.pattern, byteBuffer);
        IrQuantifier.serialize(pattern.quantifier, byteBuffer);
    }

    public static void serialize(IrQuantified pattern, DataOutputStream stream) throws IOException {
        IrRowPattern.serialize(pattern.pattern, stream);
        IrQuantifier.serialize(pattern.quantifier, stream);
    }

    public static IrQuantified deserialize(ByteBuffer byteBuffer) {
        IrRowPattern pattern = IrRowPattern.deserialize(byteBuffer);
        IrQuantifier quantifier = IrQuantifier.deserialize(byteBuffer);
        return new IrQuantified(pattern, quantifier);
    }
}

