/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.load;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadSingleTsFileNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LoadTsFile;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.PipeEnriched;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.pipe.PipeEnrichedStatement;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.exception.NotImplementedException;

public class LoadTsFileNode
extends WritePlanNode {
    private final List<TsFileResource> resources;
    private final List<Boolean> isTableModel;
    private final String database;

    public LoadTsFileNode(PlanNodeId id, List<TsFileResource> resources, List<Boolean> isTableModel, String database) {
        super(id);
        this.resources = resources;
        this.isTableModel = isTableModel;
        this.database = database;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return null;
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of load TsFile is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return Collections.emptyList();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
    }

    @Override
    public List<WritePlanNode> splitByPartition(IAnalysis analysis) {
        if (analysis instanceof Analysis) {
            return this.splitByPartitionForTreeModel((Analysis)analysis);
        }
        return this.splitByPartitionForTableModel((org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis)analysis);
    }

    private List<WritePlanNode> splitByPartitionForTreeModel(Analysis analysis) {
        ArrayList<WritePlanNode> res = new ArrayList<WritePlanNode>();
        LoadTsFileStatement statement = analysis.getTreeStatement() instanceof PipeEnrichedStatement ? (LoadTsFileStatement)((PipeEnrichedStatement)analysis.getTreeStatement()).getInnerStatement() : (LoadTsFileStatement)analysis.getTreeStatement();
        for (int i = 0; i < this.resources.size(); ++i) {
            res.add(new LoadSingleTsFileNode(this.getPlanNodeId(), this.resources.get(i), this.isTableModel.get(i), this.database, statement.isDeleteAfterLoad(), statement.getWritePointCount(i)));
        }
        return res;
    }

    private List<WritePlanNode> splitByPartitionForTableModel(org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis analysis) {
        ArrayList<WritePlanNode> res = new ArrayList<WritePlanNode>();
        LoadTsFile statement = analysis.getStatement() instanceof PipeEnriched ? (LoadTsFile)((PipeEnriched)analysis.getStatement()).getInnerStatement() : (LoadTsFile)analysis.getStatement();
        for (int i = 0; i < this.resources.size(); ++i) {
            if (statement == null) continue;
            res.add(new LoadSingleTsFileNode(this.getPlanNodeId(), this.resources.get(i), this.isTableModel.get(i), this.database, statement.isDeleteAfterLoad(), statement.getWritePointCount(i)));
        }
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadTsFileNode loadTsFileNode = (LoadTsFileNode)o;
        return Objects.equals(this.resources, loadTsFileNode.resources) && Objects.equals(this.database, loadTsFileNode.database) && Objects.equals(this.isTableModel, loadTsFileNode.isTableModel);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.resources, this.database, this.isTableModel);
    }
}

