/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.util;

import org.apache.iotdb.db.exception.sql.SemanticException;

public class BitwiseUtils {
    private static final long TINYINT_MASK = 255L;
    private static final long TINYINT_SIGNED_BIT = 128L;
    private static final long SMALLINT_MASK = 65535L;
    private static final long SMALLINT_SIGNED_BIT = 32768L;
    private static final int TINYINT_MASK_IN_INT = 255;
    private static final int TINYINT_SIGNED_BIT_IN_INT = 128;
    private static final int SMALLINT_MASK_IN_INT = 65535;
    private static final int SMALLINT_SIGNED_BIT_IN_INT = 32768;
    private static final long INTEGER_MASK = 0xFFFFFFFFL;
    private static final long INTEGER_SIGNED_BIT = 0x80000000L;

    public static void bitCountCheck(long num, long bits) {
        BitwiseUtils.bitCountCheckBits(bits);
        long lowBitsMask = (1L << (int)(bits - 1L)) - 1L;
        if (num > lowBitsMask || num < (lowBitsMask ^ 0xFFFFFFFFFFFFFFFFL)) {
            throw new SemanticException(String.format("Argument exception, the scalar function num must be representable with the bits specified. %s cannot be represented with %s bits.", num, bits));
        }
    }

    public static void bitCountCheckBits(long bits) {
        if (bits <= 1L || bits > 64L) {
            throw new SemanticException("Argument exception, the scalar function bit_count bits must be between 2 and 64.");
        }
    }

    public static long bitCountTransform(long num, long bits) {
        BitwiseUtils.bitCountCheck(num, bits);
        if (bits == 64L) {
            return Long.bitCount(num);
        }
        long mask = (1L << (int)bits) - 1L;
        return Long.bitCount(num & mask);
    }

    public static long bitwiseAndTransform(long leftValue, long rightValue) {
        return leftValue & rightValue;
    }

    public static long bitwiseNotTransform(long leftValue) {
        return leftValue ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long bitwiseOrTransform(long leftValue, long rightValue) {
        return leftValue | rightValue;
    }

    public static long bitwiseXorTransform(long leftValue, long rightValue) {
        return leftValue ^ rightValue;
    }

    public static int bitwiseLeftShiftTransform(int value, long shift) {
        if (shift >= 32L) {
            return 0;
        }
        int shifted = value << (int)shift;
        if (BitwiseUtils.isTinyInt(value)) {
            return BitwiseUtils.preserveSign(shifted, 255, 128);
        }
        if (BitwiseUtils.isSmallInt(value)) {
            return BitwiseUtils.preserveSign(shifted, 65535, 32768);
        }
        return shifted;
    }

    public static long bitwiseLeftShiftTransform(long value, long shift) {
        if (shift >= 64L) {
            return 0L;
        }
        long shifted = value << (int)shift;
        if (BitwiseUtils.isTinyInt(value)) {
            return BitwiseUtils.preserveSign(shifted, 255L, 128L);
        }
        if (BitwiseUtils.isSmallInt(value)) {
            return BitwiseUtils.preserveSign(shifted, 65535L, 32768L);
        }
        if (BitwiseUtils.isInt32(value)) {
            return BitwiseUtils.preserveSign(shifted, 0xFFFFFFFFL, 0x80000000L);
        }
        return shifted;
    }

    public static int bitwiseRightShiftTransform(int value, long shift) {
        if (shift >= 32L) {
            return 0;
        }
        if (shift == 0L) {
            return value;
        }
        if (BitwiseUtils.isTinyInt(value)) {
            return (value & 0xFF) >>> (int)shift;
        }
        if (BitwiseUtils.isSmallInt(value)) {
            return (value & 0xFFFF) >>> (int)shift;
        }
        return value >>> (int)shift;
    }

    public static long bitwiseRightShiftTransform(long value, long shift) {
        if (shift >= 64L) {
            return 0L;
        }
        if (shift == 0L) {
            return value;
        }
        if (BitwiseUtils.isTinyInt(value)) {
            return (value & 0xFFL) >>> (int)shift;
        }
        if (BitwiseUtils.isSmallInt(value)) {
            return (value & 0xFFFFL) >>> (int)shift;
        }
        if (BitwiseUtils.isInt32(value)) {
            return (value & 0xFFFFFFFFL) >>> (int)shift;
        }
        return value >>> (int)shift;
    }

    public static int bitwiseRightShiftArithmeticTransform(int value, long shift) {
        if (shift >= 32L) {
            if (value >= 0) {
                return 0;
            }
            return -1;
        }
        if (BitwiseUtils.isTinyInt(value)) {
            return BitwiseUtils.preserveSign(value, 255, 128) >> (int)shift;
        }
        if (BitwiseUtils.isSmallInt(value)) {
            return BitwiseUtils.preserveSign(value, 65535, 32768) >> (int)shift;
        }
        return value >> (int)shift;
    }

    public static long bitwiseRightShiftArithmeticTransform(long value, long shift) {
        if (shift >= 64L) {
            if (value >= 0L) {
                return 0L;
            }
            return -1L;
        }
        if (BitwiseUtils.isTinyInt(value)) {
            return BitwiseUtils.preserveSign(value, 255L, 128L) >> (int)shift;
        }
        if (BitwiseUtils.isSmallInt(value)) {
            return BitwiseUtils.preserveSign(value, 65535L, 32768L) >> (int)shift;
        }
        if (BitwiseUtils.isInt32(value)) {
            return BitwiseUtils.preserveSign(value, 0xFFFFFFFFL, 0x80000000L) >> (int)shift;
        }
        return value >> (int)shift;
    }

    private static long preserveSign(long shiftedValue, long mask, long signedBit) {
        if ((shiftedValue & signedBit) != 0L) {
            return shiftedValue | mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return shiftedValue & mask;
    }

    private static int preserveSign(int shiftedValue, int mask, int signedBit) {
        if ((shiftedValue & signedBit) != 0) {
            return shiftedValue | ~mask;
        }
        return shiftedValue & mask;
    }

    private static boolean isTinyInt(long value) {
        return (value + 128L & 0xFFFFFFFFFFFFFF00L) == 0L;
    }

    private static boolean isSmallInt(long value) {
        return (value + 32768L & 0xFFFFFFFFFFFF0000L) == 0L;
    }

    private static boolean isInt32(long value) {
        return (value + 0x80000000L & 0xFFFFFFFF00000000L) == 0L;
    }
}

