/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class LoadModel
extends Statement {
    private final String modelId;
    private final List<String> deviceIdList;

    public LoadModel(String modelId, List<String> deviceIdList) {
        super(null);
        this.modelId = modelId;
        this.deviceIdList = deviceIdList;
    }

    public String getModelId() {
        return this.modelId;
    }

    public List<String> getDeviceIdList() {
        return this.deviceIdList;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLoadModel(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadModel loadModel = (LoadModel)o;
        return Objects.equals(this.modelId, loadModel.modelId) && Objects.equals(this.deviceIdList, loadModel.deviceIdList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.modelId, this.deviceIdList);
    }

    @Override
    public String toString() {
        return "LoadModel{modelId='" + this.modelId + '\'' + ", deviceIdList=" + this.deviceIdList + '}';
    }
}

