/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.query.timegenerator.node;

import java.io.IOException;
import java.util.function.BiPredicate;
import org.apache.tsfile.read.query.timegenerator.node.Node;
import org.apache.tsfile.read.query.timegenerator.node.NodeType;

public class AndNode
implements Node {
    private Node leftChild;
    private Node rightChild;
    private long cachedTime;
    private boolean hasCachedTime;
    private boolean ascending = true;

    public AndNode(Node leftChild, Node rightChild) {
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.hasCachedTime = false;
    }

    public AndNode(Node leftChild, Node rightChild, boolean ascending) {
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.hasCachedTime = false;
        this.ascending = ascending;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.hasCachedTime) {
            return true;
        }
        if (this.leftChild.hasNext() && this.rightChild.hasNext()) {
            if (this.ascending) {
                return this.fillNextCache((l, r) -> l > r);
            }
            return this.fillNextCache((l, r) -> l < r);
        }
        return false;
    }

    private boolean fillNextCache(BiPredicate<Long, Long> seekRight) throws IOException {
        long leftValue = this.leftChild.next();
        long rightValue = this.rightChild.next();
        while (true) {
            if (leftValue == rightValue) {
                this.hasCachedTime = true;
                this.cachedTime = leftValue;
                return true;
            }
            if (seekRight.test(leftValue, rightValue)) {
                if (this.rightChild.hasNext()) {
                    rightValue = this.rightChild.next();
                    continue;
                }
                return false;
            }
            if (!this.leftChild.hasNext()) break;
            leftValue = this.leftChild.next();
        }
        return false;
    }

    @Override
    public long next() throws IOException {
        if (this.hasNext()) {
            this.hasCachedTime = false;
            return this.cachedTime;
        }
        throw new IOException("no more data");
    }

    @Override
    public NodeType getType() {
        return NodeType.AND;
    }
}

