/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.listener.PipeInsertionDataNodeListener;
import org.apache.iotdb.db.queryengine.common.DeviceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.QueryExecutionMetricSet;
import org.apache.iotdb.db.queryengine.metric.QueryResourceMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeTTLCache;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.service.metrics.WritingMetrics;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.DataRegionInfo;
import org.apache.iotdb.db.storageengine.dataregion.flush.CloseFileListener;
import org.apache.iotdb.db.storageengine.dataregion.flush.CompressionRatio;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushListener;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushManager;
import org.apache.iotdb.db.storageengine.dataregion.flush.MemTableFlushTask;
import org.apache.iotdb.db.storageengine.dataregion.flush.NotifyFlushMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessorInfo;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.IChunkHandle;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.IFileScanHandle;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl.DiskAlignedChunkHandleImpl;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl.DiskChunkHandleImpl;
import org.apache.iotdb.db.storageengine.dataregion.read.filescan.impl.UnclosedFileScanHandleImpl;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndexCacheRecorder;
import org.apache.iotdb.db.storageengine.dataregion.utils.SharedTimeDataBuffer;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.IWALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALFlushListener;
import org.apache.iotdb.db.storageengine.rescon.memory.MemTableManager;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TsFileProcessor.class);
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();
    private final String storageGroupName;
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final DataRegionInfo dataRegionInfo;
    private TsFileProcessorInfo tsFileProcessorInfo;
    private final ConcurrentLinkedDeque<IMemTable> flushingMemTables = new ConcurrentLinkedDeque();
    private final List<Pair<Modification, IMemTable>> modsToMemtable = new ArrayList<Pair<Modification, IMemTable>>();
    private RestorableTsFileIOWriter writer;
    private final TsFileResource tsFileResource;
    private long timeRangeId;
    private volatile boolean managedByFlushManager;
    private final ReadWriteLock flushQueryLock = new ReentrantReadWriteLock();
    private volatile boolean shouldClose;
    private IMemTable workMemTable;
    private final DataRegion.UpdateEndTimeCallBack updateLatestFlushTimeCallback;
    public static final long FLUSH_POINT_COUNT_NOT_SET = -1L;
    private long memTableFlushPointCount = -1L;
    private final IWALNode walNode;
    private final boolean sequence;
    private long totalMemTableSize;
    private final AtomicBoolean isTotallyGeneratedByPipe = new AtomicBoolean(true);
    private static final String FLUSH_QUERY_WRITE_LOCKED = "{}: {} get flushQueryLock write lock";
    private static final String FLUSH_QUERY_WRITE_RELEASE = "{}: {} get flushQueryLock write lock released";
    private final List<CloseFileListener> closeFileListeners = new CopyOnWriteArrayList<CloseFileListener>();
    private final List<FlushListener> flushListeners = new ArrayList<FlushListener>();
    private final QueryExecutionMetricSet QUERY_EXECUTION_METRICS = QueryExecutionMetricSet.getInstance();
    private final QueryResourceMetricSet QUERY_RESOURCE_METRICS = QueryResourceMetricSet.getInstance();
    public static final int MEMTABLE_NOT_EXIST = -1;
    private int walEntryNum = 0;

    public TsFileProcessor(String storageGroupName, File tsfile, DataRegionInfo dataRegionInfo, CloseFileListener closeUnsealedTsFileProcessor, DataRegion.UpdateEndTimeCallBack updateLatestFlushTimeCallback, boolean sequence) throws IOException {
        this.storageGroupName = storageGroupName;
        this.sequence = sequence;
        this.tsFileResource = new TsFileResource(tsfile, this);
        this.dataRegionInfo = dataRegionInfo;
        this.writer = new RestorableTsFileIOWriter(tsfile);
        this.updateLatestFlushTimeCallback = updateLatestFlushTimeCallback;
        this.walNode = WALManager.getInstance().applyForWALNode(WALManager.getApplicantUniqueId(storageGroupName, sequence));
        this.flushListeners.add(FlushListener.DefaultMemTableFLushListener.INSTANCE);
        this.flushListeners.add(this.walNode);
        this.closeFileListeners.add(closeUnsealedTsFileProcessor);
        logger.info("create a new tsfile processor {}", (Object)tsfile.getAbsolutePath());
    }

    public TsFileProcessor(String storageGroupName, DataRegionInfo dataRegionInfo, TsFileResource tsFileResource, CloseFileListener closeUnsealedTsFileProcessor, DataRegion.UpdateEndTimeCallBack updateLatestFlushTimeCallback, boolean sequence, RestorableTsFileIOWriter writer) {
        this.storageGroupName = storageGroupName;
        this.tsFileResource = tsFileResource;
        this.dataRegionInfo = dataRegionInfo;
        this.writer = writer;
        this.updateLatestFlushTimeCallback = updateLatestFlushTimeCallback;
        this.sequence = sequence;
        this.walNode = WALManager.getInstance().applyForWALNode(WALManager.getApplicantUniqueId(storageGroupName, sequence));
        this.flushListeners.add(FlushListener.DefaultMemTableFLushListener.INSTANCE);
        this.flushListeners.add(this.walNode);
        this.closeFileListeners.add(closeUnsealedTsFileProcessor);
        logger.info("reopen a tsfile processor {}", (Object)tsFileResource.getTsFile());
    }

    public void insert(InsertRowNode insertRowNode, long[] costsForMetrics) throws WriteProcessException {
        if (this.workMemTable == null) {
            long startTime = System.nanoTime();
            this.createNewWorkingMemTable();
            costsForMetrics[0] = costsForMetrics[0] + (System.nanoTime() - startTime);
            WritingMetrics.getInstance().recordActiveMemTableCount(this.dataRegionInfo.getDataRegion().getDataRegionIdString(), 1);
        }
        long memControlStartTime = System.nanoTime();
        long[] memIncrements = insertRowNode.isAligned() ? this.checkAlignedMemCostAndAddToTspInfoForRow(insertRowNode.getDeviceID(), insertRowNode.getMeasurements(), insertRowNode.getDataTypes(), insertRowNode.getValues()) : this.checkMemCostAndAddToTspInfoForRow(insertRowNode.getDeviceID(), insertRowNode.getMeasurements(), insertRowNode.getDataTypes(), insertRowNode.getValues());
        costsForMetrics[1] = costsForMetrics[1] + (System.nanoTime() - memControlStartTime);
        long startTime = System.nanoTime();
        try {
            WALFlushListener walFlushListener = this.walNode.log(this.workMemTable.getMemTableId(), insertRowNode);
            if (walFlushListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
                throw walFlushListener.getCause();
            }
        }
        catch (Exception e) {
            this.rollbackMemoryInfo(memIncrements);
            logger.warn("Exception during wal flush", (Throwable)e);
            if (e instanceof IoTDBRuntimeException) {
                throw new WriteProcessException(e.getMessage(), ((IoTDBRuntimeException)e).getErrorCode(), true);
            }
            throw new WriteProcessException(String.format("%s: %s write WAL failed: %s", this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e.getMessage()), e);
        }
        finally {
            costsForMetrics[2] = costsForMetrics[2] + (System.nanoTime() - startTime);
        }
        ++this.walEntryNum;
        startTime = System.nanoTime();
        PipeDataNodeAgent.runtime().assignSimpleProgressIndexIfNeeded(insertRowNode);
        if (!insertRowNode.isGeneratedByPipe()) {
            this.isTotallyGeneratedByPipe.set(false);
        }
        PipeInsertionDataNodeListener.getInstance().listenToInsertNode(this.dataRegionInfo.getDataRegion().getDataRegionIdString(), insertRowNode, this.tsFileResource);
        int pointInserted = insertRowNode.isAligned() ? this.workMemTable.insertAlignedRow(insertRowNode) : this.workMemTable.insert(insertRowNode);
        this.tsFileResource.updateStartTime(insertRowNode.getDeviceID(), insertRowNode.getTime());
        if (!this.sequence) {
            this.tsFileResource.updateEndTime(insertRowNode.getDeviceID(), insertRowNode.getTime());
        }
        this.workMemTable.updateMemtablePointCountMetric(insertRowNode, pointInserted);
        this.tsFileResource.updateProgressIndex(insertRowNode.getProgressIndex());
        costsForMetrics[3] = costsForMetrics[3] + (System.nanoTime() - startTime);
    }

    public void insert(InsertRowsNode insertRowsNode, long[] costsForMetrics) throws WriteProcessException {
        long[] memIncrements;
        if (this.workMemTable == null) {
            long startTime = System.nanoTime();
            this.createNewWorkingMemTable();
            costsForMetrics[0] = costsForMetrics[0] + (System.nanoTime() - startTime);
            WritingMetrics.getInstance().recordActiveMemTableCount(this.dataRegionInfo.getDataRegion().getDataRegionIdString(), 1);
        }
        long memControlStartTime = System.nanoTime();
        if (insertRowsNode.isMixingAlignment()) {
            ArrayList<InsertRowNode> alignedList = new ArrayList<InsertRowNode>();
            ArrayList<InsertRowNode> nonAlignedList = new ArrayList<InsertRowNode>();
            for (InsertRowNode insertRowNode : insertRowsNode.getInsertRowNodeList()) {
                if (insertRowNode.isAligned()) {
                    alignedList.add(insertRowNode);
                    continue;
                }
                nonAlignedList.add(insertRowNode);
            }
            long[] alignedMemIncrements = this.checkAlignedMemCostAndAddToTspInfoForRows(alignedList);
            long[] nonAlignedMemIncrements = this.checkMemCostAndAddToTspInfoForRows(nonAlignedList);
            memIncrements = new long[3];
            for (int i = 0; i < 3; ++i) {
                memIncrements[i] = alignedMemIncrements[i] + nonAlignedMemIncrements[i];
            }
        } else {
            memIncrements = insertRowsNode.isAligned() ? this.checkAlignedMemCostAndAddToTspInfoForRows(insertRowsNode.getInsertRowNodeList()) : this.checkMemCostAndAddToTspInfoForRows(insertRowsNode.getInsertRowNodeList());
        }
        costsForMetrics[1] = costsForMetrics[1] + (System.nanoTime() - memControlStartTime);
        long startTime = System.nanoTime();
        try {
            WALFlushListener walFlushListener = this.walNode.log(this.workMemTable.getMemTableId(), insertRowsNode);
            if (walFlushListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
                throw walFlushListener.getCause();
            }
        }
        catch (Exception e) {
            this.rollbackMemoryInfo(memIncrements);
            logger.warn("Exception during wal flush", (Throwable)e);
            if (e instanceof IoTDBRuntimeException) {
                throw new WriteProcessException(e.getMessage(), ((IoTDBRuntimeException)e).getErrorCode(), true);
            }
            throw new WriteProcessException(String.format("%s: %s write WAL failed: %s", this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e.getMessage()), e);
        }
        finally {
            costsForMetrics[2] = costsForMetrics[2] + (System.nanoTime() - startTime);
        }
        ++this.walEntryNum;
        startTime = System.nanoTime();
        PipeDataNodeAgent.runtime().assignSimpleProgressIndexIfNeeded(insertRowsNode);
        if (!insertRowsNode.isGeneratedByPipe()) {
            this.isTotallyGeneratedByPipe.set(false);
        }
        PipeInsertionDataNodeListener.getInstance().listenToInsertNode(this.dataRegionInfo.getDataRegion().getDataRegionIdString(), insertRowsNode, this.tsFileResource);
        int pointInserted = 0;
        for (InsertRowNode insertRowNode : insertRowsNode.getInsertRowNodeList()) {
            pointInserted = insertRowNode.isAligned() ? (pointInserted += this.workMemTable.insertAlignedRow(insertRowNode)) : (pointInserted += this.workMemTable.insert(insertRowNode));
            this.tsFileResource.updateStartTime(insertRowNode.getDeviceID(), insertRowNode.getTime());
            if (this.sequence) continue;
            this.tsFileResource.updateEndTime(insertRowNode.getDeviceID(), insertRowNode.getTime());
        }
        this.workMemTable.updateMemtablePointCountMetric(insertRowsNode, pointInserted);
        this.tsFileResource.updateProgressIndex(insertRowsNode.getProgressIndex());
        costsForMetrics[3] = costsForMetrics[3] + (System.nanoTime() - startTime);
    }

    private void createNewWorkingMemTable() {
        this.workMemTable = MemTableManager.getInstance().getAvailableMemTable(this.dataRegionInfo.getDataRegion().getDatabaseName(), this.dataRegionInfo.getDataRegion().getDataRegionIdString());
        this.walNode.onMemTableCreated(this.workMemTable, this.tsFileResource.getTsFilePath());
    }

    public void insertTablet(InsertTabletNode insertTabletNode, int start, int end, TSStatus[] results) throws WriteProcessException {
        int pointInserted;
        long[] memIncrements;
        long startTime;
        if (this.workMemTable == null) {
            long startTime2 = System.nanoTime();
            this.createNewWorkingMemTable();
            PERFORMANCE_OVERVIEW_METRICS.recordCreateMemtableBlockCost(System.nanoTime() - startTime2);
            WritingMetrics.getInstance().recordActiveMemTableCount(this.dataRegionInfo.getDataRegion().getDataRegionIdString(), 1);
        }
        try {
            startTime = System.nanoTime();
            memIncrements = insertTabletNode.isAligned() ? this.checkAlignedMemCostAndAddToTspForTablet(insertTabletNode.getDeviceID(), insertTabletNode.getMeasurements(), insertTabletNode.getDataTypes(), insertTabletNode.getColumns(), start, end) : this.checkMemCostAndAddToTspInfoForTablet(insertTabletNode.getDeviceID(), insertTabletNode.getMeasurements(), insertTabletNode.getDataTypes(), insertTabletNode.getColumns(), start, end);
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleMemoryBlockCost(System.nanoTime() - startTime);
        }
        catch (WriteProcessException e) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_REJECT, (String)e.getMessage());
            }
            throw new WriteProcessException((Exception)((Object)e));
        }
        startTime = System.nanoTime();
        try {
            WALFlushListener walFlushListener = this.walNode.log(this.workMemTable.getMemTableId(), insertTabletNode, start, end);
            if (walFlushListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
                throw walFlushListener.getCause();
            }
        }
        catch (Exception e) {
            for (int i = start; i < end; ++i) {
                results[i] = e instanceof IoTDBRuntimeException ? RpcUtils.getStatus((int)((IoTDBRuntimeException)e).getErrorCode(), (String)e.getMessage()) : RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            }
            this.rollbackMemoryInfo(memIncrements);
            throw new WriteProcessException(e);
        }
        finally {
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleWalCost(System.nanoTime() - startTime);
        }
        ++this.walEntryNum;
        startTime = System.nanoTime();
        PipeDataNodeAgent.runtime().assignSimpleProgressIndexIfNeeded(insertTabletNode);
        if (!insertTabletNode.isGeneratedByPipe()) {
            this.isTotallyGeneratedByPipe.set(false);
        }
        PipeInsertionDataNodeListener.getInstance().listenToInsertNode(this.dataRegionInfo.getDataRegion().getDataRegionIdString(), insertTabletNode, this.tsFileResource);
        try {
            pointInserted = insertTabletNode.isAligned() ? this.workMemTable.insertAlignedTablet(insertTabletNode, start, end) : this.workMemTable.insertTablet(insertTabletNode, start, end);
        }
        catch (WriteProcessException e) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            }
            throw new WriteProcessException((Exception)((Object)e));
        }
        for (int i = start; i < end; ++i) {
            results[i] = RpcUtils.SUCCESS_STATUS;
        }
        this.tsFileResource.updateStartTime(insertTabletNode.getDeviceID(), insertTabletNode.getTimes()[start]);
        if (!this.sequence) {
            this.tsFileResource.updateEndTime(insertTabletNode.getDeviceID(), insertTabletNode.getTimes()[end - 1]);
        }
        this.workMemTable.updateMemtablePointCountMetric(insertTabletNode, pointInserted);
        this.tsFileResource.updateProgressIndex(insertTabletNode.getProgressIndex());
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleMemTableCost(System.nanoTime() - startTime);
    }

    private long[] checkMemCostAndAddToTspInfoForRow(IDeviceID deviceId, String[] measurements, TSDataType[] dataTypes, Object[] values) throws WriteProcessException {
        long memTableIncrement = 0L;
        long textDataIncrement = 0L;
        long chunkMetadataIncrement = 0L;
        for (int i = 0; i < dataTypes.length; ++i) {
            if (dataTypes[i] == null || measurements[i] == null) continue;
            IWritableMemChunk memChunk = this.workMemTable.getWritableMemChunk(deviceId, measurements[i]);
            if (memChunk == null) {
                chunkMetadataIncrement += ChunkMetadata.calculateRamSize((String)measurements[i], (TSDataType)dataTypes[i]);
                memTableIncrement += TVList.tvListArrayMemCost(dataTypes[i]);
            } else {
                long currentChunkPointNum = memChunk.rowCount();
                if (currentChunkPointNum % (long)PrimitiveArrayManager.ARRAY_SIZE == 0L) {
                    memTableIncrement += memChunk.getWorkingTVList().tvListArrayMemCost();
                }
            }
            if (!dataTypes[i].isBinary() || values[i] == null) continue;
            textDataIncrement += MemUtils.getBinarySize((Binary)values[i]);
        }
        this.updateMemoryInfo(memTableIncrement, chunkMetadataIncrement, textDataIncrement);
        return new long[]{memTableIncrement, textDataIncrement, chunkMetadataIncrement};
    }

    private long[] checkMemCostAndAddToTspInfoForRows(List<InsertRowNode> insertRowNodeList) throws WriteProcessException {
        long memTableIncrement = 0L;
        long textDataIncrement = 0L;
        long chunkMetadataIncrement = 0L;
        HashMap<IDeviceID, Map> increasingMemTableInfo = new HashMap<IDeviceID, Map>();
        for (InsertRowNode insertRowNode : insertRowNodeList) {
            IDeviceID deviceId = insertRowNode.getDeviceID();
            TSDataType[] dataTypes = insertRowNode.getDataTypes();
            Object[] values = insertRowNode.getValues();
            String[] measurements = insertRowNode.getMeasurements();
            for (int i = 0; i < dataTypes.length; ++i) {
                if (dataTypes[i] == null || measurements[i] == null) continue;
                IWritableMemChunk memChunk = this.workMemTable.getWritableMemChunk(deviceId, measurements[i]);
                if (!(memChunk != null || increasingMemTableInfo.containsKey(deviceId) && ((Map)increasingMemTableInfo.get(deviceId)).containsKey(measurements[i]))) {
                    chunkMetadataIncrement += ChunkMetadata.calculateRamSize((String)measurements[i], (TSDataType)dataTypes[i]);
                    memTableIncrement += TVList.tvListArrayMemCost(dataTypes[i]);
                    increasingMemTableInfo.computeIfAbsent(deviceId, k -> new HashMap()).putIfAbsent(measurements[i], 1);
                } else {
                    long currentChunkPointNum;
                    int addingPointNum = increasingMemTableInfo.computeIfAbsent(deviceId, k -> new HashMap()).computeIfAbsent(measurements[i], k -> 0);
                    long l = currentChunkPointNum = memChunk != null ? memChunk.rowCount() : 0L;
                    if ((currentChunkPointNum + (long)addingPointNum) % (long)PrimitiveArrayManager.ARRAY_SIZE == 0L) {
                        memTableIncrement += memChunk != null ? memChunk.getWorkingTVList().tvListArrayMemCost() : TVList.tvListArrayMemCost(dataTypes[i]);
                    }
                    ((Map)increasingMemTableInfo.get(deviceId)).computeIfPresent(measurements[i], (k, v) -> v + 1);
                }
                if (!dataTypes[i].isBinary() || values[i] == null) continue;
                textDataIncrement += MemUtils.getBinarySize((Binary)values[i]);
            }
        }
        this.updateMemoryInfo(memTableIncrement, chunkMetadataIncrement, textDataIncrement);
        return new long[]{memTableIncrement, textDataIncrement, chunkMetadataIncrement};
    }

    private long[] checkAlignedMemCostAndAddToTspInfoForRow(IDeviceID deviceId, String[] measurements, TSDataType[] dataTypes, Object[] values) throws WriteProcessException {
        long memTableIncrement = 0L;
        long textDataIncrement = 0L;
        long chunkMetadataIncrement = 0L;
        IWritableMemChunk memChunk = this.workMemTable.getWritableMemChunk(deviceId, "");
        if (memChunk == null) {
            chunkMetadataIncrement += ChunkMetadata.calculateRamSize((String)"", (TSDataType)TSDataType.VECTOR) * (long)dataTypes.length;
            memTableIncrement += AlignedTVList.alignedTvListArrayMemCost(dataTypes);
            for (int i = 0; i < dataTypes.length; ++i) {
                if (dataTypes[i] == null || measurements[i] == null || !dataTypes[i].isBinary() || values[i] == null) continue;
                textDataIncrement += MemUtils.getBinarySize((Binary)values[i]);
            }
        } else {
            AlignedWritableMemChunk alignedMemChunk = (AlignedWritableMemChunk)memChunk;
            ArrayList<TSDataType> dataTypesInTVList = new ArrayList<TSDataType>();
            for (int i = 0; i < dataTypes.length; ++i) {
                if (dataTypes[i] == null || measurements[i] == null) continue;
                if (!alignedMemChunk.containsMeasurement(measurements[i])) {
                    memTableIncrement += (long)(alignedMemChunk.alignedListSize() / PrimitiveArrayManager.ARRAY_SIZE + 1) * AlignedTVList.valueListArrayMemCost(dataTypes[i]);
                    dataTypesInTVList.add(dataTypes[i]);
                }
                if (!dataTypes[i].isBinary() || values[i] == null) continue;
                textDataIncrement += MemUtils.getBinarySize((Binary)values[i]);
            }
            if (alignedMemChunk.alignedListSize() % PrimitiveArrayManager.ARRAY_SIZE == 0) {
                dataTypesInTVList.addAll(alignedMemChunk.getWorkingTVList().getTsDataTypes());
                memTableIncrement += alignedMemChunk.getWorkingTVList().alignedTvListArrayMemCost();
            }
        }
        this.updateMemoryInfo(memTableIncrement, chunkMetadataIncrement, textDataIncrement);
        return new long[]{memTableIncrement, textDataIncrement, chunkMetadataIncrement};
    }

    private long[] checkAlignedMemCostAndAddToTspInfoForRows(List<InsertRowNode> insertRowNodeList) throws WriteProcessException {
        long memTableIncrement = 0L;
        long textDataIncrement = 0L;
        long chunkMetadataIncrement = 0L;
        HashMap<IDeviceID, Pair> increasingMemTableInfo = new HashMap<IDeviceID, Pair>();
        for (InsertRowNode insertRowNode : insertRowNodeList) {
            IDeviceID deviceId = insertRowNode.getDeviceID();
            TSDataType[] dataTypes = insertRowNode.getDataTypes();
            Object[] values = insertRowNode.getValues();
            String[] measurements = insertRowNode.getMeasurements();
            IWritableMemChunk memChunk = this.workMemTable.getWritableMemChunk(deviceId, "");
            if (memChunk == null && !increasingMemTableInfo.containsKey(deviceId)) {
                chunkMetadataIncrement += ChunkMetadata.calculateRamSize((String)"", (TSDataType)TSDataType.VECTOR) * (long)dataTypes.length;
                memTableIncrement += AlignedTVList.alignedTvListArrayMemCost(dataTypes);
                for (int i = 0; i < dataTypes.length; ++i) {
                    if (dataTypes[i] == null || measurements[i] == null) continue;
                    ((Map)increasingMemTableInfo.computeIfAbsent(deviceId, (Function<IDeviceID, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkAlignedMemCostAndAddToTspInfoForRows$4(org.apache.tsfile.file.metadata.IDeviceID ), (Lorg/apache/tsfile/file/metadata/IDeviceID;)Lorg/apache/tsfile/utils/Pair;)()).left).put(measurements[i], dataTypes[i]);
                    if (!dataTypes[i].isBinary() || values[i] == null) continue;
                    textDataIncrement += MemUtils.getBinarySize((Binary)values[i]);
                }
                continue;
            }
            AlignedWritableMemChunk alignedMemChunk = (AlignedWritableMemChunk)memChunk;
            int currentChunkPointNum = alignedMemChunk == null ? 0 : alignedMemChunk.alignedListSize();
            ArrayList<Object> dataTypesInTVList = new ArrayList<Object>();
            Pair addingPointNumInfo = increasingMemTableInfo.computeIfAbsent(deviceId, k -> new Pair(new HashMap(), (Object)0));
            for (int i = 0; i < dataTypes.length; ++i) {
                boolean currentMemChunkContainsMeasurement;
                if (dataTypes[i] == null || measurements[i] == null) continue;
                int addingPointNum = (Integer)addingPointNumInfo.getRight();
                boolean bl = currentMemChunkContainsMeasurement = alignedMemChunk != null && alignedMemChunk.containsMeasurement(measurements[i]);
                if (!currentMemChunkContainsMeasurement && !((Map)addingPointNumInfo.left).containsKey(measurements[i])) {
                    ((Map)addingPointNumInfo.left).put(measurements[i], dataTypes[i]);
                    int currentArrayNum = (currentChunkPointNum + addingPointNum) / PrimitiveArrayManager.ARRAY_SIZE + ((currentChunkPointNum + addingPointNum) % PrimitiveArrayManager.ARRAY_SIZE > 0 ? 1 : 0);
                    memTableIncrement += (long)currentArrayNum * AlignedTVList.valueListArrayMemCost(dataTypes[i]);
                    ((Map)addingPointNumInfo.left).put(measurements[i], dataTypes[i]);
                }
                if (!dataTypes[i].isBinary() || values[i] == null) continue;
                textDataIncrement += MemUtils.getBinarySize((Binary)values[i]);
            }
            int addingPointNum = (Integer)addingPointNumInfo.right;
            if ((currentChunkPointNum + addingPointNum) % PrimitiveArrayManager.ARRAY_SIZE == 0) {
                if (alignedMemChunk != null) {
                    dataTypesInTVList.addAll(alignedMemChunk.getWorkingTVList().getTsDataTypes());
                }
                dataTypesInTVList.addAll(((Map)addingPointNumInfo.left).values());
                memTableIncrement += alignedMemChunk != null ? alignedMemChunk.getWorkingTVList().alignedTvListArrayMemCost() : AlignedTVList.alignedTvListArrayMemCost(dataTypesInTVList.toArray(new TSDataType[0]));
            }
            addingPointNumInfo.setRight((Object)(addingPointNum + 1));
        }
        this.updateMemoryInfo(memTableIncrement, chunkMetadataIncrement, textDataIncrement);
        return new long[]{memTableIncrement, textDataIncrement, chunkMetadataIncrement};
    }

    private long[] checkMemCostAndAddToTspInfoForTablet(IDeviceID deviceId, String[] measurements, TSDataType[] dataTypes, Object[] columns, int start, int end) throws WriteProcessException {
        if (start >= end) {
            return new long[]{0L, 0L, 0L};
        }
        long[] memIncrements = new long[3];
        for (int i = 0; i < dataTypes.length; ++i) {
            if (dataTypes[i] == null || columns[i] == null || measurements[i] == null) continue;
            this.updateMemCost(dataTypes[i], measurements[i], deviceId, start, end, memIncrements, columns[i]);
        }
        long memTableIncrement = memIncrements[0];
        long textDataIncrement = memIncrements[1];
        long chunkMetadataIncrement = memIncrements[2];
        this.updateMemoryInfo(memTableIncrement, chunkMetadataIncrement, textDataIncrement);
        return memIncrements;
    }

    private long[] checkAlignedMemCostAndAddToTspForTablet(IDeviceID deviceId, String[] measurements, TSDataType[] dataTypes, Object[] columns, int start, int end) throws WriteProcessException {
        if (start >= end) {
            return new long[]{0L, 0L, 0L};
        }
        long[] memIncrements = new long[3];
        this.updateAlignedMemCost(dataTypes, deviceId, measurements, start, end, memIncrements, columns);
        long memTableIncrement = memIncrements[0];
        long textDataIncrement = memIncrements[1];
        long chunkMetadataIncrement = memIncrements[2];
        this.updateMemoryInfo(memTableIncrement, chunkMetadataIncrement, textDataIncrement);
        return memIncrements;
    }

    private void updateMemCost(TSDataType dataType, String measurement, IDeviceID deviceId, int start, int end, long[] memIncrements, Object column) {
        IWritableMemChunk memChunk = this.workMemTable.getWritableMemChunk(deviceId, measurement);
        if (memChunk == null) {
            memIncrements[2] = memIncrements[2] + ChunkMetadata.calculateRamSize((String)measurement, (TSDataType)dataType);
            memIncrements[0] = memIncrements[0] + (long)((end - start) / PrimitiveArrayManager.ARRAY_SIZE + 1) * TVList.tvListArrayMemCost(dataType);
        } else {
            long currentChunkPointNum = memChunk.rowCount();
            if (currentChunkPointNum % (long)PrimitiveArrayManager.ARRAY_SIZE == 0L) {
                memIncrements[0] = memIncrements[0] + (long)((end - start) / PrimitiveArrayManager.ARRAY_SIZE + 1) * memChunk.getWorkingTVList().tvListArrayMemCost();
            } else {
                long acquireArray = ((long)(end - start - 1) + currentChunkPointNum % (long)PrimitiveArrayManager.ARRAY_SIZE) / (long)PrimitiveArrayManager.ARRAY_SIZE;
                if (acquireArray != 0L) {
                    memIncrements[0] = memIncrements[0] + acquireArray * memChunk.getWorkingTVList().tvListArrayMemCost();
                }
            }
        }
        if (dataType.isBinary()) {
            Binary[] binColumn = (Binary[])column;
            memIncrements[1] = memIncrements[1] + MemUtils.getBinaryColumnSize(binColumn, start, end);
        }
    }

    private void updateAlignedMemCost(TSDataType[] dataTypes, IDeviceID deviceId, String[] measurementIds, int start, int end, long[] memIncrements, Object[] columns) {
        IWritableMemChunk memChunk = this.workMemTable.getWritableMemChunk(deviceId, "");
        if (memChunk == null) {
            memIncrements[2] = memIncrements[2] + (long)dataTypes.length * ChunkMetadata.calculateRamSize((String)"", (TSDataType)TSDataType.VECTOR);
            memIncrements[0] = memIncrements[0] + (long)((end - start) / PrimitiveArrayManager.ARRAY_SIZE + 1) * AlignedTVList.alignedTvListArrayMemCost(dataTypes);
            for (int i = 0; i < dataTypes.length; ++i) {
                TSDataType dataType = dataTypes[i];
                String measurement = measurementIds[i];
                Object column = columns[i];
                if (dataType == null || column == null || measurement == null || !dataType.isBinary()) continue;
                Binary[] binColumn = (Binary[])columns[i];
                memIncrements[1] = memIncrements[1] + MemUtils.getBinaryColumnSize(binColumn, start, end);
            }
        } else {
            AlignedWritableMemChunk alignedMemChunk = (AlignedWritableMemChunk)memChunk;
            ArrayList<TSDataType> dataTypesInTVList = new ArrayList<TSDataType>();
            for (int i = 0; i < dataTypes.length; ++i) {
                TSDataType dataType = dataTypes[i];
                String measurement = measurementIds[i];
                Object column = columns[i];
                if (dataType == null || column == null || measurement == null) continue;
                if (!alignedMemChunk.containsMeasurement(measurementIds[i])) {
                    memIncrements[0] = memIncrements[0] + (long)(alignedMemChunk.alignedListSize() / PrimitiveArrayManager.ARRAY_SIZE + 1) * AlignedTVList.valueListArrayMemCost(dataType);
                    dataTypesInTVList.add(dataType);
                }
                if (!dataType.isBinary()) continue;
                Binary[] binColumn = (Binary[])columns[i];
                memIncrements[1] = memIncrements[1] + MemUtils.getBinaryColumnSize(binColumn, start, end);
            }
            long acquireArray = alignedMemChunk.alignedListSize() % PrimitiveArrayManager.ARRAY_SIZE == 0 ? (long)((end - start) / PrimitiveArrayManager.ARRAY_SIZE) + 1L : (long)((end - start - 1 + alignedMemChunk.alignedListSize() % PrimitiveArrayManager.ARRAY_SIZE) / PrimitiveArrayManager.ARRAY_SIZE);
            if (acquireArray != 0L) {
                dataTypesInTVList.addAll(alignedMemChunk.getWorkingTVList().getTsDataTypes());
                memIncrements[0] = memIncrements[0] + acquireArray * alignedMemChunk.getWorkingTVList().alignedTvListArrayMemCost();
            }
        }
    }

    private void updateMemoryInfo(long memTableIncrement, long chunkMetadataIncrement, long textDataIncrement) throws WriteProcessRejectException {
        this.dataRegionInfo.addStorageGroupMemCost(memTableIncrement += textDataIncrement);
        this.tsFileProcessorInfo.addTSPMemCost(chunkMetadataIncrement);
        if (this.dataRegionInfo.needToReportToSystem()) {
            try {
                if (!SystemInfo.getInstance().reportStorageGroupStatus(this.dataRegionInfo, this)) {
                    long startTime = System.currentTimeMillis();
                    while (SystemInfo.getInstance().isRejected() && !this.workMemTable.shouldFlush()) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(this.config.getCheckPeriodWhenInsertBlocked());
                            if (System.currentTimeMillis() - startTime <= (long)this.config.getMaxWaitingTimeWhenInsertBlocked()) continue;
                            throw new WriteProcessRejectException("System rejected over " + (System.currentTimeMillis() - startTime) + "ms");
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }
            catch (WriteProcessRejectException e) {
                this.dataRegionInfo.releaseStorageGroupMemCost(memTableIncrement);
                this.tsFileProcessorInfo.releaseTSPMemCost(chunkMetadataIncrement);
                SystemInfo.getInstance().resetStorageGroupStatus(this.dataRegionInfo);
                throw e;
            }
        }
        this.workMemTable.addTVListRamCost(memTableIncrement);
        this.workMemTable.addTextDataSize(textDataIncrement);
    }

    private void rollbackMemoryInfo(long[] memIncrements) {
        long memTableIncrement = memIncrements[0];
        long textDataIncrement = memIncrements[1];
        long chunkMetadataIncrement = memIncrements[2];
        this.dataRegionInfo.releaseStorageGroupMemCost(memTableIncrement += textDataIncrement);
        this.tsFileProcessorInfo.releaseTSPMemCost(chunkMetadataIncrement);
        SystemInfo.getInstance().resetStorageGroupStatus(this.dataRegionInfo);
        this.workMemTable.releaseTVListRamCost(memTableIncrement);
        this.workMemTable.releaseTextDataSize(textDataIncrement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataInMemory(Deletion deletion, Set<PartialPath> devicePaths) {
        this.flushQueryLock.writeLock().lock();
        this.logFlushQueryWriteLocked();
        try {
            if (this.workMemTable != null) {
                logger.info("[Deletion] Deletion with path: {}, time:{}-{} in workMemTable", new Object[]{deletion.getPath(), deletion.getStartTime(), deletion.getEndTime()});
                for (PartialPath device : devicePaths) {
                    this.workMemTable.delete(deletion.getPath(), device, deletion.getStartTime(), deletion.getEndTime());
                }
            }
            if (!this.flushingMemTables.isEmpty()) {
                this.modsToMemtable.add((Pair<Modification, IMemTable>)new Pair((Object)deletion, (Object)this.flushingMemTables.getLast()));
            }
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            this.logFlushQueryWriteUnlocked();
        }
    }

    public WALFlushListener logDeleteDataNodeInWAL(DeleteDataNode deleteDataNode) {
        ++this.walEntryNum;
        return this.walNode.log(this.workMemTable.getMemTableId(), deleteDataNode);
    }

    public TsFileResource getTsFileResource() {
        return this.tsFileResource;
    }

    public boolean shouldFlush() {
        if (this.workMemTable == null) {
            return false;
        }
        if (this.workMemTable.shouldFlush()) {
            WritingMetrics.getInstance().recordMemControlFlushMemTableCount(1);
            return true;
        }
        return false;
    }

    public void syncClose() throws ExecutionException {
        logger.info("Sync close file: {}, will firstly async close it", (Object)this.tsFileResource.getTsFile().getAbsolutePath());
        if (this.shouldClose) {
            return;
        }
        try {
            this.asyncClose().get();
            logger.info("Start to wait until file {} is closed", (Object)this.tsFileResource);
            while (this.writer != null) {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        logger.info("File {} is closed synchronously", (Object)this.tsFileResource.getTsFile().getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Future<?> asyncClose() {
        this.flushQueryLock.writeLock().lock();
        this.logFlushQueryWriteLocked();
        if (TsFileProcessor.logger.isDebugEnabled()) {
            if (this.workMemTable != null) {
                TsFileProcessor.logger.debug("{}: flush a working memtable in async close tsfile {}, memtable size: {}, tsfile size: {}, plan index: [{}, {}], progress index: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), this.workMemTable.memSize(), this.tsFileResource.getTsFileSize(), this.workMemTable.getMinPlanIndex(), this.workMemTable.getMaxPlanIndex(), this.tsFileResource.getMaxProgressIndex()});
            } else {
                TsFileProcessor.logger.debug("{}: flush a NotifyFlushMemTable in async close tsfile {}, tsfile size: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), this.tsFileResource.getTsFileSize()});
            }
        }
        if (this.shouldClose) {
            var1_1 = CompletableFuture.completedFuture(null);
            this.flushQueryLock.writeLock().unlock();
            this.logFlushQueryWriteUnlocked();
            return var1_1;
        }
        {
            catch (Throwable var4_6) {
                throw var4_6;
            }
            tmpMemTable /* !! */  = this.workMemTable == null ? new NotifyFlushMemTable() : this.workMemTable;
            this.tsFileResource.setGeneratedByPipe(this.isTotallyGeneratedByPipe.get());
            try {
                future = this.addAMemtableIntoFlushingList(tmpMemTable /* !! */ );
                this.shouldClose = true;
                var3_5 = future;
                this.flushQueryLock.writeLock().unlock();
                this.logFlushQueryWriteUnlocked();
                return var3_5;
            }
            catch (Exception e) {}
            ** try [egrp 3[TRYBLOCK] [3 : 293->333)] { 
lbl28:
            // 1 sources

            TsFileProcessor.logger.error("{}: {} async close failed, because", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
            return CompletableFuture.completedFuture(null);
lbl30:
            // 1 sources

            finally {
                this.flushQueryLock.writeLock().unlock();
                this.logFlushQueryWriteUnlocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncFlush() throws IOException {
        IMemTable tmpMemTable;
        this.flushQueryLock.writeLock().lock();
        this.logFlushQueryWriteLocked();
        try {
            IMemTable iMemTable = tmpMemTable = this.workMemTable == null ? new NotifyFlushMemTable() : this.workMemTable;
            if (logger.isDebugEnabled() && tmpMemTable.isSignalMemTable()) {
                logger.debug("{}: {} add a signal memtable into flushing memtable list when sync flush", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
            this.addAMemtableIntoFlushingList(tmpMemTable);
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            this.logFlushQueryWriteUnlocked();
        }
        ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque = this.flushingMemTables;
        synchronized (concurrentLinkedDeque) {
            try {
                long startWait = System.currentTimeMillis();
                while (this.flushingMemTables.contains(tmpMemTable)) {
                    this.flushingMemTables.wait(1000L);
                    if (System.currentTimeMillis() - startWait <= 60000L) continue;
                    logger.warn("has waited for synced flushing a memtable in {} for 60 seconds.", (Object)this.tsFileResource.getTsFile().getAbsolutePath());
                    startWait = System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                logger.error("{}: {} wait flush finished meets error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
                Thread.currentThread().interrupt();
            }
        }
    }

    public void asyncFlush() {
        this.flushQueryLock.writeLock().lock();
        this.logFlushQueryWriteLocked();
        try {
            if (this.workMemTable == null) {
                return;
            }
            logger.info("Async flush a memtable to tsfile: {}", (Object)this.tsFileResource.getTsFile().getAbsolutePath());
            this.addAMemtableIntoFlushingList(this.workMemTable);
        }
        catch (Exception e) {
            logger.error("{}: {} add a memtable into flushing list failed", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            this.logFlushQueryWriteUnlocked();
        }
    }

    private Future<?> addAMemtableIntoFlushingList(IMemTable tobeFlushed) throws IOException {
        Map<IDeviceID, Long> lastTimeForEachDevice = tobeFlushed.getMaxTime();
        if (lastTimeForEachDevice.size() != this.tsFileResource.getDevices().size()) {
            this.tsFileResource.deleteRemovedDeviceAndUpdateEndTime(lastTimeForEachDevice);
        } else if (this.sequence) {
            this.tsFileResource.updateEndTime(lastTimeForEachDevice);
        }
        for (FlushListener flushListener : this.flushListeners) {
            flushListener.onMemTableFlushStarted(tobeFlushed);
        }
        long lastWorkMemtableFlushTime = System.currentTimeMillis();
        this.updateLatestFlushTimeCallback.call(this, lastTimeForEachDevice, lastWorkMemtableFlushTime);
        SystemInfo.getInstance().addFlushingMemTableCost(tobeFlushed.getTVListsRamCost());
        this.flushingMemTables.addLast(tobeFlushed);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} Memtable (signal = {}) is added into the flushing Memtable, queue size = {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), tobeFlushed.isSignalMemTable(), this.flushingMemTables.size()});
        }
        if (!tobeFlushed.isSignalMemTable() && !tobeFlushed.isEmpty()) {
            this.totalMemTableSize += tobeFlushed.memSize();
        }
        WritingMetrics.getInstance().recordMemTableLiveDuration(System.currentTimeMillis() - this.getWorkMemTableCreatedTime());
        WritingMetrics.getInstance().recordActiveMemTableCount(this.dataRegionInfo.getDataRegion().getDataRegionIdString(), -1);
        WritingMetrics.getInstance().recordWALEntryNumForOneTsFile(this.walEntryNum);
        this.workMemTable = null;
        return FlushManager.getInstance().registerTsFileProcessor(this);
    }

    private void releaseFlushedMemTable(IMemTable memTable) {
        this.flushQueryLock.writeLock().lock();
        this.logFlushQueryWriteLocked();
        try {
            this.writer.makeMetadataVisible();
            if (!this.flushingMemTables.remove(memTable)) {
                logger.warn("{}: {} put the memtable (signal={}) out of flushingMemtables but it is not in the queue.", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), memTable.isSignalMemTable()});
            } else if (logger.isDebugEnabled()) {
                logger.debug("{}: {} memtable (signal={}) is removed from the queue. {} left.", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), memTable.isSignalMemTable(), this.flushingMemTables.size()});
            }
            memTable.release();
            MemTableManager.getInstance().decreaseMemtableNumber();
            this.dataRegionInfo.releaseStorageGroupMemCost(memTable.getTVListsRamCost());
            if (logger.isDebugEnabled()) {
                logger.debug("[mem control] {}: {} flush finished, try to reset system mem cost, flushing memtable list size: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), this.flushingMemTables.size()});
            }
            SystemInfo.getInstance().resetStorageGroupStatus(this.dataRegionInfo);
            SystemInfo.getInstance().resetFlushingMemTableCost(memTable.getTVListsRamCost());
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} flush finished, remove a memtable from flushing list, flushing memtable list size: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), this.flushingMemTables.size()});
            }
        }
        catch (Exception e) {
            logger.error("{}: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            this.logFlushQueryWriteUnlocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncReleaseFlushedMemTable(IMemTable memTable) {
        ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque = this.flushingMemTables;
        synchronized (concurrentLinkedDeque) {
            this.releaseFlushedMemTable(memTable);
            this.flushingMemTables.notifyAll();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} released a memtable (signal={}), flushingMemtables size ={}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), memTable.isSignalMemTable(), this.flushingMemTables.size()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOneMemTable() {
        ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque;
        IMemTable memTableToFlush = this.flushingMemTables.getFirst();
        if (!memTableToFlush.isSignalMemTable()) {
            if (memTableToFlush.isEmpty()) {
                logger.info("This normal memtable is empty, skip flush. {}: {}", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            } else {
                try {
                    this.writer.mark();
                    MemTableFlushTask flushTask = new MemTableFlushTask(memTableToFlush, this.writer, this.storageGroupName, this.dataRegionInfo.getDataRegion().getDataRegionIdString());
                    flushTask.syncFlushMemTable();
                    this.memTableFlushPointCount = memTableToFlush.getTotalPointsNum();
                }
                catch (Throwable e) {
                    if (this.writer == null) {
                        logger.info("{}: {} is closed during flush, abandon flush task", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getAbsolutePath());
                        concurrentLinkedDeque = this.flushingMemTables;
                        synchronized (concurrentLinkedDeque) {
                            this.flushingMemTables.notifyAll();
                        }
                    }
                    logger.error("{}: {} meet error when flushing a memtable, change system mode to error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e});
                    CommonDescriptor.getInstance().getConfig().handleUnrecoverableError();
                    try {
                        logger.error("{}: {} IOTask meets error, truncate the corrupted data", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e});
                        this.writer.reset();
                    }
                    catch (IOException e1) {
                        logger.error("{}: {} Truncate corrupted data meets error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e1});
                    }
                    try {
                        this.syncReleaseFlushedMemTable(memTableToFlush);
                        this.tsFileResource.setTimeIndex(this.config.getTimeIndexLevel().getTimeIndex());
                        for (CloseFileListener closeFileListener : this.closeFileListeners) {
                            closeFileListener.onClosed(this);
                        }
                        this.writer.close();
                        this.writer = null;
                        ConcurrentLinkedDeque<IMemTable> e1 = this.flushingMemTables;
                        synchronized (e1) {
                            this.flushingMemTables.notifyAll();
                        }
                    }
                    catch (Exception e1) {
                        logger.error("{}: {} Release resource meets error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e1});
                    }
                    return;
                }
            }
        }
        try {
            this.flushQueryLock.writeLock().lock();
            Iterator<Pair<Modification, IMemTable>> iterator = this.modsToMemtable.iterator();
            while (iterator.hasNext()) {
                Pair<Modification, IMemTable> entry = iterator.next();
                if (!((IMemTable)entry.right).equals(memTableToFlush)) continue;
                ((Modification)entry.left).setFileOffset(this.tsFileResource.getTsFileSize());
                this.tsFileResource.getModFile().write((Modification)entry.left);
                this.tsFileResource.getModFile().close();
                iterator.remove();
                logger.info("[Deletion] Deletion with path: {}, time:{}-{} written when flush memtable", new Object[]{((Modification)entry.left).getPath(), ((Deletion)entry.left).getStartTime(), ((Deletion)entry.left).getEndTime()});
            }
        }
        catch (IOException e) {
            logger.error("Meet error when writing into ModificationFile file of {} ", (Object)this.tsFileResource.getTsFile().getAbsolutePath(), (Object)e);
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} try get lock to release a memtable (signal={})", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), memTableToFlush.isSignalMemTable()});
        }
        this.syncReleaseFlushedMemTable(memTableToFlush);
        try {
            this.writer.getTsFileOutput().force();
        }
        catch (IOException e) {
            logger.error("fsync memTable data to disk error,", (Throwable)e);
        }
        for (FlushListener flushListener : this.flushListeners) {
            flushListener.onMemTableFlushed(memTableToFlush);
        }
        int retryCnt = 0;
        while (this.shouldClose && this.flushingMemTables.isEmpty() && this.writer != null) {
            block42: {
                try {
                    if (this.isEmpty()) {
                        this.endEmptyFile();
                    } else {
                        this.writer.mark();
                        this.updateCompressionRatio();
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: {} flushingMemtables is empty and will close the file", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getAbsolutePath());
                        }
                        this.endFile();
                    }
                    if (!logger.isDebugEnabled()) break block42;
                    logger.debug("{} flushingMemtables is clear", (Object)this.storageGroupName);
                }
                catch (Exception e) {
                    logger.error("{}: {} marking or ending file meet error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e});
                    try {
                        this.writer.reset();
                    }
                    catch (IOException e1) {
                        logger.error("{}: {} truncate corrupted data meets error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e1});
                    }
                    if (retryCnt < 3) {
                        logger.warn("{} meet error when flush FileMetadata to {}, retry it again", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e});
                        ++retryCnt;
                        continue;
                    }
                    logger.error("{} meet error when flush FileMetadata to {}, change system mode to error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e});
                    CommonDescriptor.getInstance().getConfig().handleUnrecoverableError();
                    break;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} try to get flushingMemtables lock.", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getAbsolutePath());
            }
            concurrentLinkedDeque = this.flushingMemTables;
            synchronized (concurrentLinkedDeque) {
                this.flushingMemTables.notifyAll();
            }
        }
    }

    private void updateCompressionRatio() {
        try {
            double compressionRatio = (double)this.totalMemTableSize / (double)this.writer.getPos();
            logger.info("The compression ratio of tsfile {} is {}, totalMemTableSize: {}, the file size: {}", new Object[]{this.writer.getFile().getAbsolutePath(), String.format("%.2f", compressionRatio), this.totalMemTableSize, this.writer.getPos()});
            String dataRegionId = this.dataRegionInfo.getDataRegion().getDataRegionIdString();
            WritingMetrics.getInstance().recordTsFileCompressionRatioOfFlushingMemTable(dataRegionId, compressionRatio);
            CompressionRatio.getInstance().updateRatio(this.totalMemTableSize, this.writer.getPos());
        }
        catch (IOException e) {
            logger.error("{}: {} update compression ratio failed", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
        }
    }

    private void endFile() throws IOException, TsFileProcessorException {
        if (logger.isDebugEnabled()) {
            logger.debug("Start to end file {}", (Object)this.tsFileResource);
        }
        this.writer.endFile();
        PipeInsertionDataNodeListener.getInstance().listenToTsFile(this.dataRegionInfo.getDataRegion().getDataRegionIdString(), this.tsFileResource, false);
        this.tsFileResource.serialize();
        FileTimeIndexCacheRecorder.getInstance().logFileTimeIndex(this.tsFileResource);
        if (logger.isDebugEnabled()) {
            logger.debug("Ended file {}", (Object)this.tsFileResource);
        }
        for (CloseFileListener closeFileListener : this.closeFileListeners) {
            closeFileListener.onClosed(this);
        }
        this.tsFileProcessorInfo.clear();
        this.dataRegionInfo.closeTsFileProcessorAndReportToSystem(this);
        this.writer = null;
    }

    private void endEmptyFile() throws TsFileProcessorException, IOException {
        logger.info("Start to end empty file {}", (Object)this.tsFileResource);
        this.writer.close();
        for (CloseFileListener closeFileListener : this.closeFileListeners) {
            closeFileListener.onClosed(this);
        }
        this.tsFileProcessorInfo.clear();
        this.dataRegionInfo.closeTsFileProcessorAndReportToSystem(this);
        logger.info("Storage group {} close and remove empty file {}", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getAbsoluteFile());
        this.writer = null;
    }

    public boolean isManagedByFlushManager() {
        return this.managedByFlushManager;
    }

    public void setManagedByFlushManager(boolean managedByFlushManager) {
        this.managedByFlushManager = managedByFlushManager;
    }

    public void closeWithoutSettingResourceStatus() throws TsFileProcessorException {
        try {
            this.tsFileResource.closeWithoutSettingStatus();
        }
        catch (IOException e) {
            throw new TsFileProcessorException(e);
        }
    }

    public int getFlushingMemTableSize() {
        return this.flushingMemTables.size();
    }

    RestorableTsFileIOWriter getWriter() {
        return this.writer;
    }

    private void processAlignedChunkMetaDataFromFlushedMemTable(IDeviceID deviceID, AlignedChunkMetadata alignedChunkMetadata, Map<String, List<IChunkMetadata>> measurementToChunkMetaMap, Map<String, List<IChunkHandle>> measurementToChunkHandleMap, String filePath) {
        SharedTimeDataBuffer sharedTimeDataBuffer = new SharedTimeDataBuffer(alignedChunkMetadata.getTimeChunkMetadata());
        for (IChunkMetadata valueChunkMetaData : alignedChunkMetadata.getValueChunkMetadataList()) {
            String measurement = valueChunkMetaData.getMeasurementUid();
            measurementToChunkMetaMap.computeIfAbsent(measurement, k -> new ArrayList()).add(valueChunkMetaData);
            measurementToChunkHandleMap.computeIfAbsent(measurement, k -> new ArrayList()).add(new DiskAlignedChunkHandleImpl(deviceID, measurement, filePath, this.tsFileResource.getTsFileID(), false, valueChunkMetaData.getOffsetOfChunkHeader(), (Statistics<? extends Serializable>)valueChunkMetaData.getStatistics(), sharedTimeDataBuffer));
        }
    }

    private void processChunkMetaDataFromFlushedMemTable(IDeviceID deviceID, ChunkMetadata chunkMetadata, Map<String, List<IChunkMetadata>> measurementToChunkMetaMap, Map<String, List<IChunkHandle>> measurementToChunkHandleMap, String filePath) {
        String measurement = chunkMetadata.getMeasurementUid();
        measurementToChunkMetaMap.computeIfAbsent(measurement, k -> new ArrayList()).add(chunkMetadata);
        measurementToChunkHandleMap.computeIfAbsent(measurement, k -> new ArrayList()).add(new DiskChunkHandleImpl(deviceID, measurement, filePath, this.tsFileResource.getTsFileID(), false, chunkMetadata.getOffsetOfChunkHeader(), (Statistics<? extends Serializable>)chunkMetadata.getStatistics()));
    }

    private void buildChunkHandleForFlushedMemTable(IDeviceID deviceID, List<IChunkMetadata> chunkMetadataList, Map<String, List<IChunkMetadata>> measurementToChunkMetaList, Map<String, List<IChunkHandle>> measurementToChunkHandleList) {
        for (IChunkMetadata chunkMetadata : chunkMetadataList) {
            if (chunkMetadata instanceof AlignedChunkMetadata) {
                this.processAlignedChunkMetaDataFromFlushedMemTable(deviceID, (AlignedChunkMetadata)chunkMetadata, measurementToChunkMetaList, measurementToChunkHandleList, this.tsFileResource.getTsFilePath());
                continue;
            }
            this.processChunkMetaDataFromFlushedMemTable(deviceID, (ChunkMetadata)chunkMetadata, measurementToChunkMetaList, measurementToChunkHandleList, this.tsFileResource.getTsFilePath());
        }
    }

    private int searchTimeChunkMetaDataIndexAndSetModifications(List<List<ChunkMetadata>> chunkMetaDataList, IDeviceID deviceID, List<List<Modification>> modifications, QueryContext context) throws QueryProcessException {
        int timeChunkMetaDataIndex = -1;
        for (int i = 0; i < chunkMetaDataList.size(); ++i) {
            List<ChunkMetadata> chunkMetadata = chunkMetaDataList.get(i);
            String measurement = chunkMetadata.get(0).getMeasurementUid();
            if (measurement.isEmpty()) {
                timeChunkMetaDataIndex = i;
                continue;
            }
            try {
                modifications.add(context.getPathModifications(this.tsFileResource, deviceID, measurement));
                continue;
            }
            catch (IllegalPathException e) {
                throw new QueryProcessException(e.getMessage());
            }
        }
        return timeChunkMetaDataIndex;
    }

    private List<IChunkMetadata> getVisibleMetadataListFromWriterByDeviceID(QueryContext queryContext, IDeviceID deviceID) throws IllegalPathException {
        long timeLowerBound = this.getQueryTimeLowerBound(PathUtils.splitPathToDetachedNodes((String)((PlainDeviceID)deviceID).toStringID()));
        List chunkMetaDataListForDevice = this.writer.getVisibleMetadataList(deviceID, null);
        ArrayList processedChunkMetadataForOneDevice = new ArrayList();
        for (List chunkMetadataList : chunkMetaDataListForDevice) {
            if (chunkMetadataList.isEmpty()) continue;
            ModificationUtils.modifyChunkMetaData(chunkMetadataList, queryContext.getPathModifications(this.tsFileResource, deviceID, ((ChunkMetadata)chunkMetadataList.get(0)).getMeasurementUid()));
            chunkMetadataList.removeIf(x -> x.getEndTime() < timeLowerBound);
            processedChunkMetadataForOneDevice.addAll(chunkMetadataList);
        }
        return new ArrayList<IChunkMetadata>(processedChunkMetadataForOneDevice);
    }

    private List<IChunkMetadata> getAlignedVisibleMetadataListFromWriterByDeviceID(QueryContext queryContext, IDeviceID deviceID) throws QueryProcessException, IllegalPathException {
        ArrayList<AlignedChunkMetadata> alignedChunkMetadataForOneDevice = new ArrayList<AlignedChunkMetadata>();
        ArrayList<List<Modification>> modifications = new ArrayList<List<Modification>>();
        List chunkMetaDataListForDevice = this.writer.getVisibleMetadataList(deviceID, null);
        if (chunkMetaDataListForDevice.isEmpty()) {
            return Collections.emptyList();
        }
        int timeChunkMetadataListIndex = this.searchTimeChunkMetaDataIndexAndSetModifications(chunkMetaDataListForDevice, deviceID, modifications, queryContext);
        if (timeChunkMetadataListIndex == -1) {
            throw new QueryProcessException("TimeChunkMetadata in aligned device should not be empty");
        }
        List timeChunkMetadataList = (List)chunkMetaDataListForDevice.get(timeChunkMetadataListIndex);
        for (int i = 0; i < timeChunkMetadataList.size(); ++i) {
            ArrayList<IChunkMetadata> valuesChunkMetadata = new ArrayList<IChunkMetadata>();
            boolean exits = false;
            for (int j = 0; j < chunkMetaDataListForDevice.size(); ++j) {
                List chunkMetadataList = (List)chunkMetaDataListForDevice.get(j);
                if (j == timeChunkMetadataListIndex || chunkMetadataList.isEmpty()) continue;
                boolean currentExist = i < chunkMetadataList.size();
                exits = exits || currentExist;
                valuesChunkMetadata.add(currentExist ? (IChunkMetadata)chunkMetadataList.get(i) : null);
            }
            if (!exits) continue;
            alignedChunkMetadataForOneDevice.add(new AlignedChunkMetadata((IChunkMetadata)timeChunkMetadataList.get(i), valuesChunkMetadata));
        }
        long timeLowerBound = this.getQueryTimeLowerBound(PathUtils.splitPathToDetachedNodes((String)((PlainDeviceID)deviceID).toStringID()));
        ModificationUtils.modifyAlignedChunkMetaData(alignedChunkMetadataForOneDevice, modifications);
        alignedChunkMetadataForOneDevice.removeIf(x -> x.getEndTime() < timeLowerBound);
        return new ArrayList<AlignedChunkMetadata>(alignedChunkMetadataForOneDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryForSeriesRegionScanWithoutLock(List<PartialPath> pathList, QueryContext queryContext, List<IFileScanHandle> fileScanHandlesForQuery) {
        long startTime = System.nanoTime();
        try {
            HashMap<IDeviceID, Map<String, List<IChunkHandle>>> deviceToMemChunkHandleMap = new HashMap<IDeviceID, Map<String, List<IChunkHandle>>>();
            HashMap<IDeviceID, Map<String, List<IChunkMetadata>>> deviceToChunkMetadataListMap = new HashMap<IDeviceID, Map<String, List<IChunkMetadata>>>();
            try {
                for (PartialPath seriesPath : pathList) {
                    HashMap<String, List<IChunkMetadata>> measurementToChunkMetaList = new HashMap<String, List<IChunkMetadata>>();
                    HashMap<String, List<IChunkHandle>> measurementToChunkHandleList = new HashMap<String, List<IChunkHandle>>();
                    long timeLowerBound = this.getQueryTimeLowerBound(seriesPath.getDevicePath().getNodes());
                    for (IMemTable flushingMemTable : this.flushingMemTables) {
                        if (flushingMemTable.isSignalMemTable()) continue;
                        flushingMemTable.queryForSeriesRegionScan(seriesPath, timeLowerBound, measurementToChunkMetaList, measurementToChunkHandleList, this.modsToMemtable);
                    }
                    if (this.workMemTable != null) {
                        this.workMemTable.queryForSeriesRegionScan(seriesPath, timeLowerBound, measurementToChunkMetaList, measurementToChunkHandleList, null);
                    }
                    IDeviceID deviceID = DeviceIDFactory.getInstance().getDeviceID(seriesPath.getDevice());
                    this.buildChunkHandleForFlushedMemTable(deviceID, ResourceByPathUtils.getResourceInstance(seriesPath).getVisibleMetadataListFromWriter(this.writer, this.tsFileResource, queryContext, timeLowerBound), measurementToChunkMetaList, measurementToChunkHandleList);
                    if (measurementToChunkHandleList.isEmpty() && measurementToChunkMetaList.isEmpty()) continue;
                    deviceToMemChunkHandleMap.computeIfAbsent(deviceID, k -> new HashMap()).putAll(measurementToChunkHandleList);
                    deviceToChunkMetadataListMap.computeIfAbsent(deviceID, k -> new HashMap()).putAll(measurementToChunkMetaList);
                }
                this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("flushing_memtable", this.flushingMemTables.size());
                this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("working_memtable", this.workMemTable != null ? 1 : 0);
            }
            catch (IOException | MetadataException | QueryProcessException e) {
                try {
                    logger.error("{}: {} get ReadOnlyMemChunk has error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("flushing_memtable", this.flushingMemTables.size());
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("working_memtable", this.workMemTable != null ? 1 : 0);
                }
                catch (Throwable throwable) {
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("flushing_memtable", this.flushingMemTables.size());
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("working_memtable", this.workMemTable != null ? 1 : 0);
                    throw throwable;
                }
            }
            if (!deviceToMemChunkHandleMap.isEmpty() || !deviceToChunkMetadataListMap.isEmpty()) {
                fileScanHandlesForQuery.add(new UnclosedFileScanHandleImpl(deviceToChunkMetadataListMap, deviceToMemChunkHandleMap, this.tsFileResource));
            }
        }
        finally {
            this.QUERY_EXECUTION_METRICS.recordExecutionCost("get_query_resource_from_mem", System.nanoTime() - startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryForDeviceRegionScanWithoutLock(Map<IDeviceID, DeviceContext> devicePathsToContext, QueryContext queryContext, List<IFileScanHandle> fileScanHandlesForQuery) {
        long startTime = System.nanoTime();
        try {
            HashMap<IDeviceID, Map<String, List<IChunkHandle>>> deviceToMemChunkHandleMap = new HashMap<IDeviceID, Map<String, List<IChunkHandle>>>();
            HashMap<IDeviceID, Map<String, List<IChunkMetadata>>> deviceToChunkMetadataListMap = new HashMap<IDeviceID, Map<String, List<IChunkMetadata>>>();
            try {
                for (Map.Entry<IDeviceID, DeviceContext> entry : devicePathsToContext.entrySet()) {
                    IDeviceID deviceID = entry.getKey();
                    boolean isAligned = entry.getValue().isAligned();
                    long timeLowerBound = this.getQueryTimeLowerBound(PathUtils.splitPathToDetachedNodes((String)((PlainDeviceID)deviceID).toStringID()));
                    HashMap<String, List<IChunkMetadata>> measurementToChunkMetadataList = new HashMap<String, List<IChunkMetadata>>();
                    HashMap<String, List<IChunkHandle>> measurementToMemChunkHandleList = new HashMap<String, List<IChunkHandle>>();
                    for (IMemTable flushingMemTable : this.flushingMemTables) {
                        if (flushingMemTable.isSignalMemTable()) continue;
                        flushingMemTable.queryForDeviceRegionScan(deviceID, isAligned, timeLowerBound, measurementToChunkMetadataList, measurementToMemChunkHandleList, this.modsToMemtable);
                    }
                    if (this.workMemTable != null) {
                        this.workMemTable.queryForDeviceRegionScan(deviceID, isAligned, timeLowerBound, measurementToChunkMetadataList, measurementToMemChunkHandleList, null);
                    }
                    this.buildChunkHandleForFlushedMemTable(deviceID, isAligned ? this.getAlignedVisibleMetadataListFromWriterByDeviceID(queryContext, deviceID) : this.getVisibleMetadataListFromWriterByDeviceID(queryContext, deviceID), measurementToChunkMetadataList, measurementToMemChunkHandleList);
                    if (measurementToMemChunkHandleList.isEmpty() && measurementToChunkMetadataList.isEmpty()) continue;
                    deviceToMemChunkHandleMap.put(deviceID, measurementToMemChunkHandleList);
                    deviceToChunkMetadataListMap.put(deviceID, measurementToChunkMetadataList);
                }
                this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("flushing_memtable", this.flushingMemTables.size());
                this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("working_memtable", this.workMemTable != null ? 1 : 0);
            }
            catch (IOException | MetadataException | QueryProcessException e) {
                try {
                    logger.error("{}: {} get ReadOnlyMemChunk has error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("flushing_memtable", this.flushingMemTables.size());
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("working_memtable", this.workMemTable != null ? 1 : 0);
                }
                catch (Throwable throwable) {
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("flushing_memtable", this.flushingMemTables.size());
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("working_memtable", this.workMemTable != null ? 1 : 0);
                    throw throwable;
                }
            }
            if (!deviceToMemChunkHandleMap.isEmpty() || !deviceToChunkMetadataListMap.isEmpty()) {
                fileScanHandlesForQuery.add(new UnclosedFileScanHandleImpl(deviceToChunkMetadataListMap, deviceToMemChunkHandleMap, this.tsFileResource));
            }
        }
        finally {
            this.QUERY_EXECUTION_METRICS.recordExecutionCost("get_query_resource_from_mem", System.nanoTime() - startTime);
        }
    }

    public void queryWithoutLock(List<PartialPath> seriesPaths, QueryContext context, List<TsFileResource> tsfileResourcesForQuery, Filter globalTimeFilter) throws IOException {
        this.query(seriesPaths, context, tsfileResourcesForQuery, globalTimeFilter, false);
    }

    public void query(List<PartialPath> seriesPaths, QueryContext context, List<TsFileResource> tsfileResourcesForQuery, Filter globalTimeFilter) throws IOException {
        this.query(seriesPaths, context, tsfileResourcesForQuery, globalTimeFilter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void query(List<PartialPath> seriesPaths, QueryContext context, List<TsFileResource> tsfileResourcesForQuery, Filter globalTimeFilter, boolean needLock) throws IOException {
        long startTime = System.nanoTime();
        try {
            HashMap<PartialPath, List<IChunkMetadata>> pathToChunkMetadataListMap = new HashMap<PartialPath, List<IChunkMetadata>>();
            HashMap<PartialPath, List<ReadOnlyMemChunk>> pathToReadOnlyMemChunkMap = new HashMap<PartialPath, List<ReadOnlyMemChunk>>();
            if (needLock) {
                this.flushQueryLock.readLock().lock();
            }
            try {
                for (PartialPath seriesPath : seriesPaths) {
                    ReadOnlyMemChunk memChunk;
                    ArrayList<ReadOnlyMemChunk> readOnlyMemChunks = new ArrayList<ReadOnlyMemChunk>();
                    long timeLowerBound = this.getQueryTimeLowerBound(seriesPath.getDevicePath().getNodes());
                    for (IMemTable flushingMemTable : this.flushingMemTables) {
                        ReadOnlyMemChunk memChunk2;
                        if (flushingMemTable.isSignalMemTable() || (memChunk2 = flushingMemTable.query(context, seriesPath, timeLowerBound, this.modsToMemtable, globalTimeFilter)) == null) continue;
                        readOnlyMemChunks.add(memChunk2);
                    }
                    if (this.workMemTable != null && (memChunk = this.workMemTable.query(context, seriesPath, timeLowerBound, null, globalTimeFilter)) != null) {
                        readOnlyMemChunks.add(memChunk);
                    }
                    List<IChunkMetadata> chunkMetadataList = ResourceByPathUtils.getResourceInstance(seriesPath).getVisibleMetadataListFromWriter(this.writer, this.tsFileResource, context, timeLowerBound);
                    if (readOnlyMemChunks.isEmpty() && chunkMetadataList.isEmpty()) continue;
                    pathToReadOnlyMemChunkMap.put(seriesPath, readOnlyMemChunks);
                    pathToChunkMetadataListMap.put(seriesPath, chunkMetadataList);
                }
                this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("flushing_memtable", this.flushingMemTables.size());
                this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("working_memtable", this.workMemTable != null ? 1 : 0);
                if (needLock) {
                    this.flushQueryLock.readLock().unlock();
                    this.logFlushQueryReadUnlocked();
                }
            }
            catch (MetadataException | QueryProcessException e) {
                try {
                    logger.error("{}: {} get ReadOnlyMemChunk has error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("flushing_memtable", this.flushingMemTables.size());
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("working_memtable", this.workMemTable != null ? 1 : 0);
                    if (needLock) {
                        this.flushQueryLock.readLock().unlock();
                        this.logFlushQueryReadUnlocked();
                    }
                }
                catch (Throwable throwable) {
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("flushing_memtable", this.flushingMemTables.size());
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("working_memtable", this.workMemTable != null ? 1 : 0);
                    if (needLock) {
                        this.flushQueryLock.readLock().unlock();
                        this.logFlushQueryReadUnlocked();
                    }
                    throw throwable;
                }
            }
            if (!pathToReadOnlyMemChunkMap.isEmpty() || !pathToChunkMetadataListMap.isEmpty()) {
                tsfileResourcesForQuery.add(new TsFileResource(pathToReadOnlyMemChunkMap, pathToChunkMetadataListMap, this.tsFileResource));
            }
        }
        finally {
            this.QUERY_EXECUTION_METRICS.recordExecutionCost("get_query_resource_from_mem", System.nanoTime() - startTime);
        }
    }

    private long getQueryTimeLowerBound(String[] device) {
        long deviceTTL = DataNodeTTLCache.getInstance().getTTL(device);
        return deviceTTL != Long.MAX_VALUE ? CommonDateTimeUtils.currentTime() - deviceTTL : Long.MIN_VALUE;
    }

    public long getTimeRangeId() {
        return this.timeRangeId;
    }

    public void setTimeRangeId(long timeRangeId) {
        this.timeRangeId = timeRangeId;
    }

    public void putMemTableBackAndClose() throws TsFileProcessorException {
        if (this.workMemTable != null) {
            this.workMemTable.release();
            this.dataRegionInfo.releaseStorageGroupMemCost(this.workMemTable.getTVListsRamCost());
            this.workMemTable = null;
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new TsFileProcessorException(e);
        }
        this.tsFileProcessorInfo.clear();
        this.dataRegionInfo.closeTsFileProcessorAndReportToSystem(this);
    }

    public void setTsFileProcessorInfo(TsFileProcessorInfo tsFileProcessorInfo) {
        this.tsFileProcessorInfo = tsFileProcessorInfo;
    }

    public long getWorkMemTableRamCost() {
        return this.workMemTable != null ? this.workMemTable.getTVListsRamCost() : 0L;
    }

    public long getWorkMemTableCreatedTime() {
        return this.workMemTable != null ? this.workMemTable.getCreatedTime() : Long.MAX_VALUE;
    }

    public long getWorkMemTableUpdateTime() {
        return this.workMemTable != null ? this.workMemTable.getUpdateTime() : Long.MAX_VALUE;
    }

    public long getMemTableFlushPointCount() {
        return this.memTableFlushPointCount;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public void setWorkMemTableShouldFlush() {
        this.workMemTable.setShouldFlush();
    }

    public void addCloseFileListener(CloseFileListener listener) {
        this.closeFileListeners.add(listener);
    }

    public void addFlushListeners(Collection<FlushListener> listeners) {
        this.flushListeners.addAll(listeners);
    }

    public void addCloseFileListeners(Collection<CloseFileListener> listeners) {
        this.closeFileListeners.addAll(listeners);
    }

    public void submitAFlushTask() {
        this.dataRegionInfo.getDataRegion().submitAFlushTaskWhenShouldFlush(this);
    }

    public boolean alreadyMarkedClosing() {
        return this.shouldClose;
    }

    public boolean isEmpty() {
        return this.totalMemTableSize == 0L && (this.workMemTable == null || this.workMemTable.getTotalPointsNum() == 0L);
    }

    public IMemTable getWorkMemTable() {
        return this.workMemTable;
    }

    public ConcurrentLinkedDeque<IMemTable> getFlushingMemTable() {
        return this.flushingMemTables;
    }

    public void writeLock() {
        this.flushQueryLock.writeLock().lock();
    }

    public void writeUnlock() {
        this.flushQueryLock.writeLock().unlock();
    }

    public boolean tryReadLock(long waitInMs) throws InterruptedException {
        return this.flushQueryLock.readLock().tryLock(waitInMs, TimeUnit.MILLISECONDS);
    }

    public void readUnLock() {
        this.flushQueryLock.readLock().unlock();
    }

    private void logFlushQueryWriteLocked() {
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
    }

    private void logFlushQueryWriteUnlocked() {
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
    }

    private void logFlushQueryReadUnlocked() {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} release flushQueryLock", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
    }

    private static /* synthetic */ Pair lambda$checkAlignedMemCostAndAddToTspInfoForRows$4(IDeviceID k) {
        return new Pair(new HashMap(), (Object)1);
    }
}

