/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.jetbrains.annotations.Nullable;

public enum ModelChangeStructureVerbMask implements UaEnumeration
{
    NodeAdded(1),
    NodeDeleted(2),
    ReferenceAdded(4),
    ReferenceDeleted(8),
    DataTypeChanged(16);

    private final int value;

    private ModelChangeStructureVerbMask(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static ModelChangeStructureVerbMask from(int value) {
        switch (value) {
            case 1: {
                return NodeAdded;
            }
            case 2: {
                return NodeDeleted;
            }
            case 4: {
                return ReferenceAdded;
            }
            case 8: {
                return ReferenceDeleted;
            }
            case 16: {
                return DataTypeChanged;
            }
        }
        return null;
    }

    public static ExpandedNodeId getTypeId() {
        return ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=11941");
    }

    public static class Codec
    extends GenericDataTypeCodec<ModelChangeStructureVerbMask> {
        @Override
        public Class<ModelChangeStructureVerbMask> getType() {
            return ModelChangeStructureVerbMask.class;
        }

        @Override
        public ModelChangeStructureVerbMask decode(SerializationContext context, UaDecoder decoder) {
            return decoder.readEnum(null, ModelChangeStructureVerbMask.class);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ModelChangeStructureVerbMask value) {
            encoder.writeEnum(null, value);
        }
    }
}

