/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemAlignedChunkLoader;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.MemPointIterator;
import org.apache.iotdb.db.utils.datastructure.MemPointIteratorFactory;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class AlignedReadOnlyMemChunk
extends ReadOnlyMemChunk {
    private final String timeChunkName;
    private final List<String> valueChunkNames;
    private final List<TSDataType> dataTypes;
    private final int floatPrecision;
    private final List<TSEncoding> encodingList;
    private final List<List<TimeRange>> valueColumnsDeletionList;
    private final List<Statistics<? extends Serializable>> timeStatisticsList;
    private final List<Statistics<? extends Serializable>[]> valueStatisticsList;
    protected Map<TVList, Integer> alignedTvListQueryMap;
    private final List<Integer> columnIndexList;
    private MemPointIterator nonStreamingTimeValuePairIterator;

    public AlignedReadOnlyMemChunk(QueryContext context, List<Integer> columnIndexList, IMeasurementSchema schema, Map<TVList, Integer> alignedTvListQueryMap, List<List<TimeRange>> valueColumnsDeletionList) {
        super(context);
        this.timeChunkName = schema.getMeasurementId();
        this.valueChunkNames = schema.getSubMeasurementsList();
        this.dataTypes = schema.getSubMeasurementsTSDataTypeList();
        this.floatPrecision = TSFileDescriptor.getInstance().getConfig().getFloatPrecision();
        this.encodingList = schema.getSubMeasurementsTSEncodingList();
        this.valueColumnsDeletionList = valueColumnsDeletionList;
        this.timeStatisticsList = new ArrayList<Statistics<? extends Serializable>>();
        this.valueStatisticsList = new ArrayList<Statistics<? extends Serializable>[]>();
        this.alignedTvListQueryMap = alignedTvListQueryMap;
        this.columnIndexList = columnIndexList;
        this.context.addTVListToSet(alignedTvListQueryMap);
    }

    @Override
    public void sortTvLists() {
        for (Map.Entry<TVList, Integer> entry : this.getAligendTvListQueryMap().entrySet()) {
            AlignedTVList alignedTvList = (AlignedTVList)entry.getKey();
            int queryRowCount = entry.getValue();
            if (alignedTvList.isSorted() || queryRowCount <= alignedTvList.seqRowCount()) continue;
            alignedTvList.sort();
        }
    }

    @Override
    public void initChunkMetaFromTvLists(Filter globalTimeFilter) {
        Statistics chunkTimeStatistics = Statistics.getStatsByType((TSDataType)TSDataType.VECTOR);
        ChunkMetadata timeChunkMetadata = new ChunkMetadata(this.timeChunkName, TSDataType.VECTOR, 0L, chunkTimeStatistics);
        Statistics[] chunkValueStatistics = new Statistics[this.dataTypes.size()];
        for (int column = 0; column < this.dataTypes.size(); ++column) {
            chunkValueStatistics[column] = Statistics.getStatsByType((TSDataType)this.dataTypes.get(column));
        }
        this.nonStreamingTimeValuePairIterator = this.createMemPointIterator(Ordering.ASC, globalTimeFilter);
        this.nonStreamingTimeValuePairIterator.setStreamingQueryMemChunk(false);
        while (this.nonStreamingTimeValuePairIterator.hasNextBatch()) {
            Statistics pageTimeStatistics = Statistics.getStatsByType((TSDataType)TSDataType.VECTOR);
            pageTimeStatistics.setEmpty(false);
            this.timeStatisticsList.add((Statistics<? extends Serializable>)pageTimeStatistics);
            Statistics[] pageValueStatistics = new Statistics[this.dataTypes.size()];
            for (int column = 0; column < this.dataTypes.size(); ++column) {
                pageValueStatistics[column] = Statistics.getStatsByType((TSDataType)this.dataTypes.get(column));
            }
            this.valueStatisticsList.add(pageValueStatistics);
            TsBlock tsBlock = this.nonStreamingTimeValuePairIterator.nextBatch();
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                pageTimeStatistics.update(tsBlock.getTimeByIndex(i));
                chunkTimeStatistics.update(tsBlock.getTimeByIndex(i));
            }
            for (int column = 0; column < tsBlock.getValueColumnCount(); ++column) {
                Statistics pageValueStats = Statistics.getStatsByType((TSDataType)this.dataTypes.get(column));
                switch (this.dataTypes.get(column)) {
                    case BOOLEAN: {
                        int i;
                        for (i = 0; i < tsBlock.getPositionCount(); ++i) {
                            if (tsBlock.getColumn(column).isNull(i)) continue;
                            pageValueStats.update(tsBlock.getTimeByIndex(i), tsBlock.getColumn(column).getBoolean(i));
                            chunkValueStatistics[column].update(tsBlock.getTimeByIndex(i), tsBlock.getColumn(column).getBoolean(i));
                        }
                        break;
                    }
                    case INT32: 
                    case DATE: {
                        int i;
                        for (i = 0; i < tsBlock.getPositionCount(); ++i) {
                            if (tsBlock.getColumn(column).isNull(i)) continue;
                            pageValueStats.update(tsBlock.getTimeByIndex(i), tsBlock.getColumn(column).getInt(i));
                            chunkValueStatistics[column].update(tsBlock.getTimeByIndex(i), tsBlock.getColumn(column).getInt(i));
                        }
                        break;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        int i;
                        for (i = 0; i < tsBlock.getPositionCount(); ++i) {
                            if (tsBlock.getColumn(column).isNull(i)) continue;
                            pageValueStats.update(tsBlock.getTimeByIndex(i), tsBlock.getColumn(column).getLong(i));
                            chunkValueStatistics[column].update(tsBlock.getTimeByIndex(i), tsBlock.getColumn(column).getLong(i));
                        }
                        break;
                    }
                    case FLOAT: {
                        int i;
                        for (i = 0; i < tsBlock.getPositionCount(); ++i) {
                            if (tsBlock.getColumn(column).isNull(i)) continue;
                            pageValueStats.update(tsBlock.getTimeByIndex(i), tsBlock.getColumn(column).getFloat(i));
                            chunkValueStatistics[column].update(tsBlock.getTimeByIndex(i), tsBlock.getColumn(column).getFloat(i));
                        }
                        break;
                    }
                    case DOUBLE: {
                        int i;
                        for (i = 0; i < tsBlock.getPositionCount(); ++i) {
                            if (tsBlock.getColumn(column).isNull(i)) continue;
                            pageValueStats.update(tsBlock.getTimeByIndex(i), tsBlock.getColumn(column).getDouble(i));
                            chunkValueStatistics[column].update(tsBlock.getTimeByIndex(i), tsBlock.getColumn(column).getDouble(i));
                        }
                        break;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        int i;
                        for (i = 0; i < tsBlock.getPositionCount(); ++i) {
                            if (tsBlock.getColumn(column).isNull(i)) continue;
                            pageValueStats.update(tsBlock.getTimeByIndex(i), tsBlock.getColumn(column).getBinary(i));
                            chunkValueStatistics[column].update(tsBlock.getTimeByIndex(i), tsBlock.getColumn(column).getBinary(i));
                        }
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.dataTypes.get(column)));
                    }
                }
                pageValueStatistics[column] = pageValueStats.isEmpty() ? null : pageValueStats;
            }
        }
        ArrayList<ChunkMetadata> valueChunkMetadataList = new ArrayList<ChunkMetadata>();
        for (int column = 0; column < this.dataTypes.size(); ++column) {
            if (!chunkValueStatistics[column].isEmpty()) {
                ChunkMetadata valueChunkMetadata = new ChunkMetadata(this.valueChunkNames.get(column), this.dataTypes.get(column), 0L, chunkValueStatistics[column]);
                valueChunkMetadataList.add(valueChunkMetadata);
                continue;
            }
            valueChunkMetadataList.add(null);
        }
        AlignedChunkMetadata alignedChunkMetadata = new AlignedChunkMetadata((IChunkMetadata)timeChunkMetadata, valueChunkMetadataList);
        alignedChunkMetadata.setChunkLoader((IChunkLoader)new MemAlignedChunkLoader(this.context, this));
        alignedChunkMetadata.setVersion(Long.MAX_VALUE);
        this.cachedMetaData = alignedChunkMetadata;
    }

    @Override
    public void initChunkMetaFromTVListsWithFakeStatistics() {
        long chunkStartTime = Long.MAX_VALUE;
        long chunkEndTime = Long.MIN_VALUE;
        long rowNum = 0L;
        for (Map.Entry<TVList, Integer> entry : this.alignedTvListQueryMap.entrySet()) {
            TVList tvList = entry.getKey();
            chunkStartTime = Math.min(chunkStartTime, tvList.getMinTime());
            chunkEndTime = Math.max(chunkEndTime, tvList.getMaxTime());
            rowNum += (long)entry.getValue().intValue();
        }
        int pageNum = (int)Math.min(100L, Math.max(1L, rowNum / (long)this.MAX_NUMBER_OF_POINTS_IN_FAKE_PAGE));
        long timeInterval = (chunkEndTime - chunkStartTime + 1L) / (long)pageNum;
        for (int i = 0; i < pageNum; ++i) {
            long pageStartTime = chunkStartTime + (long)i * timeInterval;
            long pageEndTime = i == pageNum - 1 ? chunkEndTime : pageStartTime + timeInterval - 1L;
            Statistics[] pageValueStatistics = new Statistics[this.dataTypes.size()];
            for (int column = 0; column < this.dataTypes.size(); ++column) {
                pageValueStatistics[column] = this.generateFakeStatistics(this.dataTypes.get(column), pageStartTime, pageEndTime);
            }
            this.valueStatisticsList.add(pageValueStatistics);
            Statistics<? extends Serializable> pageTimeStatistics = this.generateFakeStatistics(TSDataType.VECTOR, pageStartTime, pageEndTime);
            this.timeStatisticsList.add(pageTimeStatistics);
        }
        Statistics[] chunkValueStatistics = new Statistics[this.dataTypes.size()];
        for (int column = 0; column < this.dataTypes.size(); ++column) {
            chunkValueStatistics[column] = this.generateFakeStatistics(this.dataTypes.get(column), chunkStartTime, chunkEndTime);
        }
        Statistics<? extends Serializable> chunkTimeStatistics = this.generateFakeStatistics(TSDataType.VECTOR, chunkStartTime, chunkEndTime);
        ChunkMetadata timeChunkMetadata = new ChunkMetadata(this.timeChunkName, TSDataType.VECTOR, 0L, chunkTimeStatistics);
        timeChunkMetadata.setModified(true);
        ArrayList<ChunkMetadata> valueChunkMetadataList = new ArrayList<ChunkMetadata>();
        for (int column = 0; column < this.dataTypes.size(); ++column) {
            ChunkMetadata valueChunkMetadata = new ChunkMetadata(this.valueChunkNames.get(column), this.dataTypes.get(column), 0L, chunkValueStatistics[column]);
            valueChunkMetadata.setModified(true);
            valueChunkMetadataList.add(valueChunkMetadata);
        }
        AlignedChunkMetadata alignedChunkMetadata = new AlignedChunkMetadata((IChunkMetadata)timeChunkMetadata, valueChunkMetadataList);
        alignedChunkMetadata.setChunkLoader((IChunkLoader)new MemAlignedChunkLoader(this.context, this, true));
        alignedChunkMetadata.setVersion(Long.MAX_VALUE);
        alignedChunkMetadata.setModified(true);
        this.cachedMetaData = alignedChunkMetadata;
    }

    private int count() {
        int count = 0;
        for (TVList list : this.alignedTvListQueryMap.keySet()) {
            count += list.count();
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public IPointReader getPointReader() {
        for (Map.Entry<TVList, Integer> entry : this.alignedTvListQueryMap.entrySet()) {
            AlignedTVList tvList = (AlignedTVList)entry.getKey();
            int queryLength = entry.getValue();
            if (tvList.isSorted() || queryLength <= tvList.seqRowCount()) continue;
            tvList.sort();
        }
        TsBlock tsBlock = this.buildTsBlock();
        return tsBlock.getTsBlockAlignedRowIterator();
    }

    private TsBlock buildTsBlock() {
        try {
            TsBlockBuilder builder = new TsBlockBuilder(this.dataTypes);
            this.writeValidValuesIntoTsBlock(builder);
            return builder.build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeValidValuesIntoTsBlock(TsBlockBuilder builder) throws IOException {
        MemPointIterator timeValuePairIterator = this.createMemPointIterator(Ordering.ASC, null);
        while (timeValuePairIterator.hasNextTimeValuePair()) {
            TimeValuePair tvPair = timeValuePairIterator.nextTimeValuePair();
            TsPrimitiveType[] values = tvPair.getValue().getVector();
            builder.getTimeColumnBuilder().writeLong(tvPair.getTimestamp());
            block9: for (int columnIndex = 0; columnIndex < values.length; ++columnIndex) {
                if (values[columnIndex] == null) {
                    builder.getColumnBuilder(columnIndex).appendNull();
                    continue;
                }
                ColumnBuilder valueBuilder = builder.getColumnBuilder(columnIndex);
                switch (this.dataTypes.get(columnIndex)) {
                    case BOOLEAN: {
                        valueBuilder.writeBoolean(values[columnIndex].getBoolean());
                        continue block9;
                    }
                    case INT32: 
                    case DATE: {
                        valueBuilder.writeInt(values[columnIndex].getInt());
                        continue block9;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        valueBuilder.writeLong(values[columnIndex].getLong());
                        continue block9;
                    }
                    case FLOAT: {
                        valueBuilder.writeFloat(values[columnIndex].getFloat());
                        continue block9;
                    }
                    case DOUBLE: {
                        valueBuilder.writeDouble(values[columnIndex].getDouble());
                        continue block9;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        valueBuilder.writeBinary(values[columnIndex].getBinary());
                        continue block9;
                    }
                }
            }
            builder.declarePosition();
        }
    }

    public Map<TVList, Integer> getAligendTvListQueryMap() {
        return this.alignedTvListQueryMap;
    }

    @Override
    public int getFloatPrecision() {
        return this.floatPrecision;
    }

    public List<List<TimeRange>> getValueColumnsDeletionList() {
        return this.valueColumnsDeletionList;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public List<Statistics<? extends Serializable>> getTimeStatisticsList() {
        return this.timeStatisticsList;
    }

    public List<Statistics<? extends Serializable>[]> getValuesStatisticsList() {
        return this.valueStatisticsList;
    }

    @Override
    public MemPointIterator getMemPointIterator() {
        return this.nonStreamingTimeValuePairIterator;
    }

    @Override
    public MemPointIterator createMemPointIterator(Ordering scanOrder, Filter globalTimeFilter) {
        ArrayList<AlignedTVList> tvLists = new ArrayList<AlignedTVList>(this.alignedTvListQueryMap.size());
        ArrayList<Integer> tvListRowCounts = new ArrayList<Integer>(this.alignedTvListQueryMap.size());
        for (Map.Entry<TVList, Integer> entry : this.alignedTvListQueryMap.entrySet()) {
            tvLists.add((AlignedTVList)entry.getKey());
            tvListRowCounts.add(entry.getValue());
        }
        return MemPointIteratorFactory.create(this.dataTypes, this.columnIndexList, tvLists, tvListRowCounts, scanOrder, globalTimeFilter, this.valueColumnsDeletionList, this.floatPrecision, this.encodingList, this.MAX_NUMBER_OF_POINTS_IN_PAGE);
    }
}

