/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.fileSystem.fileInputFactory;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tsfile.fileSystem.FSPath;
import org.apache.tsfile.fileSystem.FSType;
import org.apache.tsfile.fileSystem.fileInputFactory.FileInputFactory;
import org.apache.tsfile.fileSystem.fileInputFactory.HDFSInputFactory;
import org.apache.tsfile.fileSystem.fileInputFactory.LocalFSInputFactory;
import org.apache.tsfile.fileSystem.fileInputFactory.OSFileInputFactory;
import org.apache.tsfile.read.reader.TsFileInput;
import org.apache.tsfile.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridFileInputFactory
implements FileInputFactory {
    private static final Logger logger = LoggerFactory.getLogger(HybridFileInputFactory.class);
    private static final Map<FSType, FileInputFactory> inputFactories = new ConcurrentHashMap<FSType, FileInputFactory>();

    private FileInputFactory getFileInputFactory(FSType fsType) {
        return inputFactories.compute(fsType, (k, v) -> {
            if (v != null) {
                return v;
            }
            switch (fsType) {
                case LOCAL: {
                    return new LocalFSInputFactory();
                }
                case OBJECT_STORAGE: {
                    return new OSFileInputFactory();
                }
                case HDFS: {
                    return new HDFSInputFactory();
                }
            }
            return null;
        });
    }

    @Override
    public TsFileInput getTsFileInput(String filePath) throws IOException {
        FSPath path = FSUtils.parse(filePath);
        return this.getFileInputFactory(path.getFsType()).getTsFileInput(path.getPath());
    }
}

