/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.meta;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeExceptionType;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeRuntimeMetaVersion;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeTaskMeta {
    private final AtomicReference<ProgressIndex> progressIndex = new AtomicReference();
    private final AtomicInteger leaderNodeId = new AtomicInteger(0);
    private final Set<PipeRuntimeException> exceptionMessages = Collections.newSetFromMap(new ConcurrentHashMap());

    public PipeTaskMeta(ProgressIndex progressIndex, int leaderNodeId) {
        this.progressIndex.set(progressIndex);
        this.leaderNodeId.set(leaderNodeId);
    }

    public PipeTaskMeta markAsNewlyAdded() {
        this.leaderNodeId.getAndUpdate(PipeTaskMeta::getRevertedLeader);
        return this;
    }

    public boolean isNewlyAdded() {
        return PipeTaskMeta.isNewlyAdded(this.leaderNodeId.get());
    }

    public int getLeaderNodeId() {
        int result = this.leaderNodeId.get();
        return PipeTaskMeta.isNewlyAdded(result) ? PipeTaskMeta.getRevertedLeader(result) : result;
    }

    public void setLeaderNodeId(int leaderNodeId) {
        this.leaderNodeId.updateAndGet(leaderId -> PipeTaskMeta.isNewlyAdded(leaderId) ? PipeTaskMeta.getRevertedLeader(leaderNodeId) : leaderNodeId);
    }

    public static int getRevertedLeader(int leaderNodeId) {
        return -2 - leaderNodeId;
    }

    public static boolean isNewlyAdded(int leaderNodeId) {
        return leaderNodeId < -1;
    }

    public ProgressIndex getProgressIndex() {
        return this.progressIndex.get();
    }

    public ProgressIndex updateProgressIndex(ProgressIndex updateIndex) {
        return this.progressIndex.updateAndGet(index -> index.updateToMinimumEqualOrIsAfterProgressIndex(updateIndex));
    }

    public synchronized Iterable<PipeRuntimeException> getExceptionMessages() {
        return new ArrayList<PipeRuntimeException>(this.exceptionMessages);
    }

    public synchronized String getExceptionMessagesString() {
        return this.exceptionMessages.toString();
    }

    public synchronized void trackExceptionMessage(PipeRuntimeException exceptionMessage) {
        this.exceptionMessages.clear();
        this.exceptionMessages.add(exceptionMessage);
    }

    public synchronized boolean containsExceptionMessage(PipeRuntimeException exceptionMessage) {
        return this.exceptionMessages.contains((Object)exceptionMessage);
    }

    public synchronized boolean hasExceptionMessages() {
        return !this.exceptionMessages.isEmpty();
    }

    public synchronized void clearExceptionMessages() {
        this.exceptionMessages.clear();
    }

    public synchronized void serialize(OutputStream outputStream) throws IOException {
        this.progressIndex.get().serialize(outputStream);
        ReadWriteIOUtils.write((int)this.leaderNodeId.get(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.exceptionMessages.size(), (OutputStream)outputStream);
        for (PipeRuntimeException pipeRuntimeException : this.exceptionMessages) {
            pipeRuntimeException.serialize(outputStream);
        }
    }

    public static PipeTaskMeta deserialize(PipeRuntimeMetaVersion version, ByteBuffer byteBuffer) {
        ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(byteBuffer);
        int leaderNodeId = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        PipeTaskMeta pipeTaskMeta = new PipeTaskMeta(progressIndex, leaderNodeId);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (int i = 0; i < size; ++i) {
            PipeRuntimeException pipeRuntimeException = PipeRuntimeExceptionType.deserializeFrom(version, byteBuffer);
            pipeTaskMeta.exceptionMessages.add(pipeRuntimeException);
        }
        return pipeTaskMeta;
    }

    public static PipeTaskMeta deserialize(PipeRuntimeMetaVersion version, InputStream inputStream) throws IOException {
        ProgressIndex progressIndex = ProgressIndexType.deserializeFrom(inputStream);
        int leaderNodeId = ReadWriteIOUtils.readInt((InputStream)inputStream);
        PipeTaskMeta pipeTaskMeta = new PipeTaskMeta(progressIndex, leaderNodeId);
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < size; ++i) {
            PipeRuntimeException pipeRuntimeException = PipeRuntimeExceptionType.deserializeFrom(version, inputStream);
            pipeTaskMeta.exceptionMessages.add(pipeRuntimeException);
        }
        return pipeTaskMeta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeTaskMeta that = (PipeTaskMeta)obj;
        return this.progressIndex.get().equals(that.progressIndex.get()) && this.leaderNodeId.get() == that.leaderNodeId.get() && this.exceptionMessages.equals(that.exceptionMessages);
    }

    public int hashCode() {
        return Objects.hash(this.progressIndex.get(), this.leaderNodeId.get(), this.exceptionMessages);
    }

    public String toString() {
        return "PipeTaskMeta{progressIndex='" + this.progressIndex.get() + "', leaderNodeId=" + this.leaderNodeId.get() + ", exceptionMessages='" + this.exceptionMessages + "'}";
    }
}

