/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.fory;

import org.apache.fory.Fory;
import org.apache.fory.ThreadLocalFory;
import org.apache.fory.ThreadSafeFory;
import org.apache.fory.config.CompatibleMode;
import org.apache.fory.config.Language;
import org.apache.seata.core.serializer.SerializerSecurityRegistry;

public class ForySerializerFactory {
    private static final ForySerializerFactory FACTORY = new ForySerializerFactory();
    private static final ThreadSafeFory FORY = new ThreadLocalFory(classLoader -> {
        Fory f = Fory.builder().withLanguage(Language.JAVA).requireClassRegistration(false).withRefTracking(true).withClassLoader(classLoader).withCompatibleMode(CompatibleMode.COMPATIBLE).build();
        f.getClassResolver().setClassChecker((classResolver, className) -> SerializerSecurityRegistry.getAllowClassPattern().contains(className));
        return f;
    });

    public static ForySerializerFactory getInstance() {
        return FACTORY;
    }

    public ThreadSafeFory get() {
        return FORY;
    }
}

