/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.fory.Fory;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.collection.Tuple3;
import org.apache.fory.exception.ForyException;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.reflect.FieldAccessor;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.reflect.TypeRef;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.RefResolver;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.serializer.AbstractObjectSerializer;
import org.apache.fory.serializer.SerializationBinding;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.Serializers;
import org.apache.fory.type.Descriptor;
import org.apache.fory.type.DescriptorGrouper;
import org.apache.fory.type.Generics;
import org.apache.fory.type.TypeUtils;
import org.apache.fory.type.Types;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.record.RecordInfo;
import org.apache.fory.util.record.RecordUtils;

public final class ObjectSerializer<T>
extends AbstractObjectSerializer<T> {
    private final RecordInfo recordInfo;
    private final AbstractObjectSerializer.FinalTypeField[] finalFields;
    private final boolean[] isFinal;
    private final AbstractObjectSerializer.GenericTypeField[] otherFields;
    private final AbstractObjectSerializer.GenericTypeField[] containerFields;
    private final int classVersionHash;
    private final SerializationBinding binding;
    private final TypeResolver typeResolver;

    public ObjectSerializer(Fory fory, Class<T> cls) {
        this(fory, cls, true);
    }

    public ObjectSerializer(Fory fory, Class<T> cls, boolean resolveParent) {
        super(fory, cls);
        List<Descriptor> descriptors;
        this.binding = SerializationBinding.createBinding(fory);
        if (resolveParent) {
            this.classResolver.setSerializerIfAbsent(cls, this);
        }
        this.typeResolver = fory.isCrossLanguage() ? fory.getXtypeResolver() : this.classResolver;
        boolean shareMeta = fory.getConfig().isMetaShareEnabled();
        if (shareMeta) {
            ClassDef classDef = this.classResolver.getClassDef(cls, resolveParent);
            descriptors = classDef.getDescriptors(this.typeResolver, cls);
        } else {
            descriptors = fory.getClassResolver().getFieldDescriptors(cls, resolveParent);
        }
        DescriptorGrouper descriptorGrouper = this.classResolver.createDescriptorGrouper(descriptors, false);
        descriptors = descriptorGrouper.getSortedDescriptors();
        if (this.isRecord) {
            List<String> fieldNames = descriptors.stream().map(Descriptor::getName).collect(Collectors.toList());
            this.recordInfo = new RecordInfo(cls, fieldNames);
        } else {
            this.recordInfo = null;
        }
        this.classVersionHash = fory.checkClassVersion() ? ObjectSerializer.computeStructHash(fory, descriptors) : 0;
        Tuple3<Tuple2<AbstractObjectSerializer.FinalTypeField[], boolean[]>, AbstractObjectSerializer.GenericTypeField[], AbstractObjectSerializer.GenericTypeField[]> infos = ObjectSerializer.buildFieldInfos(fory, descriptorGrouper);
        this.finalFields = (AbstractObjectSerializer.FinalTypeField[])((Tuple2)infos.f0).f0;
        this.isFinal = (boolean[])((Tuple2)infos.f0).f1;
        this.otherFields = (AbstractObjectSerializer.GenericTypeField[])infos.f1;
        this.containerFields = (AbstractObjectSerializer.GenericTypeField[])infos.f2;
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        Fory fory = this.fory;
        RefResolver refResolver = this.refResolver;
        if (fory.checkClassVersion()) {
            buffer.writeInt32(this.classVersionHash);
        }
        this.writeFinalFields(buffer, value, fory, refResolver, this.typeResolver);
        this.writeOtherFields(buffer, value);
        this.writeContainerFields(buffer, value, fory, refResolver, this.typeResolver);
    }

    private void writeOtherFields(MemoryBuffer buffer, T value) {
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            Object fieldValue = fieldAccessor.getObject(value);
            if (fieldInfo.trackingRef) {
                this.binding.writeRef(buffer, fieldValue, fieldInfo.classInfoHolder);
                continue;
            }
            this.binding.writeNullable(buffer, fieldValue, fieldInfo.classInfoHolder, fieldInfo.nullable);
        }
    }

    @Override
    public void xwrite(MemoryBuffer buffer, T value) {
        this.write(buffer, value);
    }

    private void writeFinalFields(MemoryBuffer buffer, T value, Fory fory, RefResolver refResolver, TypeResolver typeResolver) {
        AbstractObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        boolean metaShareEnabled = fory.getConfig().isMetaShareEnabled();
        for (int i = 0; i < finalFields.length; ++i) {
            boolean writeBasicObjectResult;
            AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            boolean nullable = fieldInfo.nullable;
            short classId = fieldInfo.classId;
            if (!ObjectSerializer.writePrimitiveFieldValueFailed(fory, buffer, value, fieldAccessor, classId)) continue;
            Object fieldValue = fieldAccessor.getObject(value);
            boolean bl = writeBasicObjectResult = nullable ? ObjectSerializer.writeBasicNullableObjectFieldValueFailed(fory, buffer, fieldValue, classId) : ObjectSerializer.writeBasicObjectFieldValueFailed(fory, buffer, fieldValue, classId);
            if (!writeBasicObjectResult) continue;
            Serializer serializer = fieldInfo.classInfo.getSerializer();
            if (!metaShareEnabled || this.isFinal[i]) {
                if (!fieldInfo.trackingRef) {
                    this.binding.writeNullable(buffer, fieldValue, serializer, nullable);
                    continue;
                }
                this.binding.writeRef(buffer, fieldValue, serializer);
                continue;
            }
            if (fieldInfo.trackingRef && serializer.needToWriteRef()) {
                if (refResolver.writeRefOrNull(buffer, fieldValue)) continue;
                typeResolver.writeClassInfo(buffer, fieldInfo.classInfo);
                this.binding.write(buffer, serializer, fieldValue);
                continue;
            }
            this.binding.writeNullable(buffer, fieldValue, serializer, nullable);
        }
    }

    private void writeContainerFields(MemoryBuffer buffer, T value, Fory fory, RefResolver refResolver, TypeResolver typeResolver) {
        Generics generics = fory.getGenerics();
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            Object fieldValue = fieldAccessor.getObject(value);
            ObjectSerializer.writeContainerFieldValue(this.binding, refResolver, typeResolver, generics, fieldInfo, buffer, fieldValue);
        }
    }

    static void writeContainerFieldValue(SerializationBinding binding, RefResolver refResolver, TypeResolver typeResolver, Generics generics, AbstractObjectSerializer.GenericTypeField fieldInfo, MemoryBuffer buffer, Object fieldValue) {
        if (fieldInfo.trackingRef) {
            if (!refResolver.writeRefOrNull(buffer, fieldValue)) {
                ClassInfo classInfo = typeResolver.getClassInfo(fieldValue.getClass(), fieldInfo.classInfoHolder);
                generics.pushGenericType(fieldInfo.genericType);
                binding.writeContainerFieldValue(buffer, fieldValue, classInfo);
                generics.popGenericType();
            }
        } else {
            if (fieldInfo.nullable) {
                if (fieldValue == null) {
                    buffer.writeByte((byte)-3);
                    return;
                }
                buffer.writeByte((byte)-1);
            }
            generics.pushGenericType(fieldInfo.genericType);
            binding.writeContainerFieldValue(buffer, fieldValue, typeResolver.getClassInfo(fieldValue.getClass(), fieldInfo.classInfoHolder));
            generics.popGenericType();
        }
    }

    @Override
    public T read(MemoryBuffer buffer) {
        if (this.isRecord) {
            Object[] fields = this.readFields(buffer);
            fields = RecordUtils.remapping(this.recordInfo, fields);
            try {
                Object obj = this.constructor.invokeWithArguments(fields);
                Arrays.fill(this.recordInfo.getRecordComponents(), null);
                return (T)obj;
            }
            catch (Throwable e) {
                Platform.throwException(e);
            }
        }
        Object obj = this.newBean();
        this.refResolver.reference(obj);
        return this.readAndSetFields(buffer, obj);
    }

    @Override
    public T xread(MemoryBuffer buffer) {
        return this.read(buffer);
    }

    public Object[] readFields(MemoryBuffer buffer) {
        Object fieldValue;
        Fory fory = this.fory;
        RefResolver refResolver = this.refResolver;
        TypeResolver typeResolver = this.typeResolver;
        if (fory.checkClassVersion()) {
            int hash = buffer.readInt32();
            ObjectSerializer.checkClassVersion(fory, hash, this.classVersionHash);
        }
        Object[] fieldValues = new Object[this.finalFields.length + this.otherFields.length + this.containerFields.length];
        int counter = 0;
        AbstractObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        boolean metaShareEnabled = fory.getConfig().isMetaShareEnabled();
        for (int i = 0; i < finalFields.length; ++i) {
            AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = !metaShareEnabled || this.isFinal[i];
            short classId = fieldInfo.classId;
            if (classId >= 5 && classId <= 12) {
                fieldValues[counter++] = Serializers.readPrimitiveValue(fory, buffer, classId);
                continue;
            }
            fieldValue = ObjectSerializer.readFinalObjectFieldValue(this.binding, refResolver, typeResolver, fieldInfo, isFinal, buffer);
            fieldValues[counter++] = fieldValue;
        }
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            fieldValue = ObjectSerializer.readOtherFieldValue(this.binding, fieldInfo, buffer);
            fieldValues[counter++] = fieldValue;
        }
        Generics generics = fory.getGenerics();
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            Object fieldValue2 = ObjectSerializer.readContainerFieldValue(this.binding, generics, fieldInfo, buffer);
            fieldValues[counter++] = fieldValue2;
        }
        return fieldValues;
    }

    public T readAndSetFields(MemoryBuffer buffer, T obj) {
        Fory fory = this.fory;
        RefResolver refResolver = this.refResolver;
        TypeResolver typeResolver = this.typeResolver;
        if (fory.checkClassVersion()) {
            int hash = buffer.readInt32();
            ObjectSerializer.checkClassVersion(fory, hash, this.classVersionHash);
        }
        AbstractObjectSerializer.FinalTypeField[] finalFields = this.finalFields;
        boolean metaShareEnabled = fory.getConfig().isMetaShareEnabled();
        for (int i = 0; i < finalFields.length; ++i) {
            AbstractObjectSerializer.FinalTypeField fieldInfo = finalFields[i];
            boolean isFinal = !metaShareEnabled || this.isFinal[i];
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            boolean nullable = fieldInfo.nullable;
            short classId = fieldInfo.classId;
            if (!ObjectSerializer.readPrimitiveFieldValueFailed(fory, buffer, obj, fieldAccessor, classId) || !(nullable ? ObjectSerializer.readBasicNullableObjectFieldValueFailed(fory, buffer, obj, fieldAccessor, classId) : ObjectSerializer.readBasicObjectFieldValueFailed(fory, buffer, obj, fieldAccessor, classId))) continue;
            Object fieldValue = ObjectSerializer.readFinalObjectFieldValue(this.binding, refResolver, typeResolver, fieldInfo, isFinal, buffer);
            fieldAccessor.putObject(obj, fieldValue);
        }
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.otherFields) {
            Object fieldValue = ObjectSerializer.readOtherFieldValue(this.binding, fieldInfo, buffer);
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            fieldAccessor.putObject(obj, fieldValue);
        }
        Generics generics = fory.getGenerics();
        for (AbstractObjectSerializer.GenericTypeField fieldInfo : this.containerFields) {
            Object fieldValue = ObjectSerializer.readContainerFieldValue(this.binding, generics, fieldInfo, buffer);
            FieldAccessor fieldAccessor = fieldInfo.fieldAccessor;
            fieldAccessor.putObject(obj, fieldValue);
        }
        return obj;
    }

    public static int computeStructHash(Fory fory, Collection<Descriptor> descriptors) {
        int hash = 17;
        for (Descriptor descriptor : descriptors) {
            hash = ObjectSerializer.computeFieldHash(hash, fory, descriptor.getTypeRef());
        }
        Preconditions.checkState(hash != 0);
        return hash;
    }

    private static int computeFieldHash(int hash, Fory fory, TypeRef<?> typeRef) {
        long newHash;
        int id;
        if (typeRef.isSubtypeOf((Type)((Object)List.class))) {
            id = 21;
        } else if (typeRef.isSubtypeOf((Type)((Object)Map.class))) {
            id = 23;
        } else {
            try {
                ClassInfo classInfo;
                int xtypeId;
                TypeResolver resolver = fory.isCrossLanguage() ? fory.getXtypeResolver() : fory.getClassResolver();
                Class<?> cls = typeRef.getRawType();
                id = ReflectionUtils.isAbstract(cls) || cls.isInterface() ? 0 : (Types.isStructType((byte)(xtypeId = (classInfo = resolver.getClassInfo(typeRef.getRawType())).getXtypeId())) ? TypeUtils.computeStringHash(classInfo.decodeNamespace() + classInfo.decodeTypeName()) : Math.abs(xtypeId));
            }
            catch (Exception e) {
                id = 0;
            }
        }
        for (newHash = (long)hash * 31L + (long)id; newHash >= Integer.MAX_VALUE; newHash /= 7L) {
        }
        return (int)newHash;
    }

    public static void checkClassVersion(Fory fory, int readHash, int classVersionHash) {
        if (readHash != classVersionHash) {
            throw new ForyException(String.format("Read class %s version %s is not consistent with %s", fory.getClassResolver().getCurrentReadClass(), readHash, classVersionHash));
        }
    }
}

