/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.mcp.core.props;

import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerProperties;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerSseProperties;
import org.springframework.ai.mcp.server.common.autoconfigure.properties.McpServerStreamableHttpProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class MCPProperties {
    private final Environment env;
    private Long queryDuration = TimeUnit.DAYS.toMillis(1L);
    private final McpServerProperties mcpServerProperties;
    private final McpServerSseProperties mcpServerSseProperties;
    private final McpServerStreamableHttpProperties mcpServerStreamableHttpProperties;
    private final List<String> endpoints = new ArrayList<String>();
    private final Logger logger = LoggerFactory.getLogger(MCPProperties.class);

    @Autowired
    public MCPProperties(@Nullable McpServerProperties mcpServerProperties, Environment env, @Nullable McpServerSseProperties serverSseProperties, @Nullable McpServerStreamableHttpProperties serverStreamableHttpProperties) {
        this.mcpServerProperties = mcpServerProperties;
        this.env = env;
        this.mcpServerSseProperties = serverSseProperties;
        this.mcpServerStreamableHttpProperties = serverStreamableHttpProperties;
    }

    public List<String> getEndpoints() {
        return Collections.unmodifiableList(this.endpoints);
    }

    public Long getQueryDuration() {
        return this.queryDuration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostConstruct
    public void init() {
        String maxQueryDurationStr = this.env.getProperty("seata.mcp.query.max-query-duration", "86400000");
        try {
            this.queryDuration = Long.parseLong(maxQueryDurationStr);
        }
        catch (NumberFormatException ex) {
            this.queryDuration = TimeUnit.DAYS.toMillis(1L);
        }
        if (this.mcpServerProperties != null) {
            McpServerProperties.ServerProtocol protocol = this.mcpServerProperties.getProtocol();
            if (protocol == McpServerProperties.ServerProtocol.SSE && this.mcpServerSseProperties != null) {
                this.endpoints.add(this.mcpServerSseProperties.getSseEndpoint());
                this.endpoints.add(this.mcpServerSseProperties.getSseMessageEndpoint());
                return;
            } else {
                if (protocol != McpServerProperties.ServerProtocol.STREAMABLE || this.mcpServerStreamableHttpProperties == null) throw new IllegalStateException("MCP server properties not properly configured or unsupported protocol");
                this.endpoints.add(this.mcpServerStreamableHttpProperties.getMcpEndpoint());
            }
            return;
        } else {
            this.logger.warn("MCP server properties not properly configured");
        }
    }
}

