/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


import type { Id } from '../identifier.utils.js';
import type { ClientProvider } from '../../client/index.js';
import { createTopic } from './create-topic.command.js';
import { getTopic } from './get-topic.command.js';


/**
 * Creates a virtual command that ensures a topic exists.
 * If the topic does not exist, it will be created with default settings.
 *
 * @param c - Client provider function
 * @returns Function that ensures a topic exists by name
 */
export const ensureTopic = (c: ClientProvider) =>
  async function ensureTopic(
    streamId: Id,
    topicName: string,
    partitionCount = 1,
    compressionAlgorithm = 1
  ) {
    const topic = await getTopic(c)({ streamId, topicId: topicName });
    return topic === null ?
      createTopic(c)({
        streamId, name: topicName, partitionCount, compressionAlgorithm
      }) : topic;
  };
