/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.HiveInputCounters;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostExecTezSummaryPrinter
implements ExecuteWithHookContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)PostExecTezSummaryPrinter.class.getName());

    @Override
    public void run(HookContext hookContext) throws Exception {
        assert (hookContext.getHookType() == HookContext.HookType.POST_EXEC_HOOK);
        HiveConf conf = hookContext.getConf();
        if (!"tez".equals(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
            return;
        }
        LOG.info("Executing post execution hook to print tez summary..");
        SessionState ss = SessionState.get();
        SessionState.LogHelper console = ss.getConsole();
        QueryPlan plan = hookContext.getQueryPlan();
        if (plan == null) {
            return;
        }
        List<TezTask> rootTasks = Utilities.getTezTasks(plan.getRootTasks());
        for (TezTask tezTask : rootTasks) {
            LOG.info("Printing summary for tez task: " + tezTask.getName());
            TezCounters counters = tezTask.getTezCounters();
            if (counters == null) continue;
            String hiveCountersGroup = HiveConf.getVar(conf, HiveConf.ConfVars.HIVECOUNTERGROUP);
            for (CounterGroup group : counters) {
                if (hiveCountersGroup.equals(group.getDisplayName())) {
                    console.printInfo(tezTask.getId() + " HIVE COUNTERS:", false);
                    for (TezCounter counter : group) {
                        console.printInfo("   " + counter.getDisplayName() + ": " + counter.getValue(), false);
                    }
                    continue;
                }
                if (group.getName().equals(HiveInputCounters.class.getName())) {
                    console.printInfo(tezTask.getId() + " INPUT COUNTERS:", false);
                    for (TezCounter counter : group) {
                        console.printInfo("   " + counter.getDisplayName() + ": " + counter.getValue(), false);
                    }
                    continue;
                }
                if (group.getName().equals(FileSystemCounter.class.getName())) {
                    console.printInfo(tezTask.getId() + " FILE SYSTEM COUNTERS:", false);
                    for (TezCounter counter : group) {
                        if (!counter.getName().contains("HDFS")) continue;
                        console.printInfo("   " + counter.getDisplayName() + ": " + counter.getValue(), false);
                    }
                    continue;
                }
                if (!group.getName().equals(LlapIOCounters.class.getName())) continue;
                console.printInfo(tezTask.getId() + " LLAP IO COUNTERS:", false);
                List<String> testSafeCounters = LlapIOCounters.testSafeCounterNames();
                for (TezCounter counter : group) {
                    if (!testSafeCounters.contains(counter.getDisplayName())) continue;
                    console.printInfo("   " + counter.getDisplayName() + ": " + counter.getValue(), false);
                }
            }
        }
    }
}

