/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.builder;

import java.util.Collection;
import java.util.List;
import org.apache.hugegraph.loader.builder.ElementBuilder;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.filter.util.ShortIdConfig;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.mapping.VertexMapping;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.structure.schema.SchemaLabel;
import org.apache.hugegraph.structure.schema.VertexLabel;
import org.apache.hugegraph.util.E;

public class VertexBuilder
extends ElementBuilder<Vertex> {
    private final VertexMapping mapping;
    private final VertexLabel vertexLabel;
    private final Collection<String> nonNullKeys;
    private final ShortIdConfig shortIdConfig;

    public VertexBuilder(LoadContext context, InputStruct struct, VertexMapping mapping) {
        super(context, struct);
        this.mapping = mapping;
        this.vertexLabel = this.getVertexLabel(this.mapping.label());
        this.shortIdConfig = context.options().getShortIdConfig(this.mapping.label());
        this.nonNullKeys = this.nonNullableKeys((SchemaLabel)this.vertexLabel);
        this.checkIdField();
    }

    @Override
    public VertexMapping mapping() {
        return this.mapping;
    }

    @Override
    public List<Vertex> build(String[] names, Object[] values) {
        ElementBuilder.VertexKVPairs kvPairs = null;
        kvPairs = this.verifyOlapVertexBuilder() ? new ElementBuilder.VertexOlapKVPairs(this.vertexLabel) : this.newKVPairs(this.vertexLabel, this.mapping.unfold());
        kvPairs.headerCaseSensitive(this.headerCaseSensitive());
        kvPairs.extractFromVertex(names, values);
        return kvPairs.buildVertices(true);
    }

    @Override
    protected SchemaLabel schemaLabel() {
        return this.vertexLabel;
    }

    @Override
    protected Collection<String> nonNullableKeys() {
        return this.nonNullKeys;
    }

    @Override
    protected boolean isIdField(String fieldName) {
        if (this.headerCaseSensitive()) {
            return fieldName.equals(this.mapping.idField());
        }
        return fieldName.equalsIgnoreCase(this.mapping.idField());
    }

    private void checkIdField() {
        if (this.verifyOlapVertexBuilder()) {
            return;
        }
        String name = this.vertexLabel.name();
        if (this.vertexLabel.idStrategy().isCustomize()) {
            E.checkState((this.mapping.idField() != null || this.shortIdConfig != null ? 1 : 0) != 0, (String)"The id field can't be empty or null when id strategy is '%s' for vertex label '%s'", (Object[])new Object[]{this.vertexLabel.idStrategy(), name});
        } else if (this.vertexLabel.idStrategy().isPrimaryKey()) {
            E.checkState((this.mapping.idField() == null ? 1 : 0) != 0, (String)"The id field must be empty or null when id strategy is '%s' for vertex label '%s'", (Object[])new Object[]{this.vertexLabel.idStrategy(), name});
        } else {
            throw new IllegalArgumentException("Unsupported AUTOMATIC id strategy for hugegraph-loader");
        }
    }

    public boolean verifyOlapVertexBuilder() {
        return "__OLAP_VERTEX_ID__".equals(this.mapping.idField());
    }
}

