/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination;

import com.baomidou.mybatisplus.core.toolkit.Assert;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.session.Configuration;

public class DialectModel {
    private static final String FIRST_PARAM_NAME = "mybatis_plus_first";
    private static final String SECOND_PARAM_NAME = "mybatis_plus_second";
    private final String dialectSql;
    private Configuration configuration;
    private Consumer<List<ParameterMapping>> firstParamConsumer = i -> {};
    private Consumer<Map<String, Object>> firstParamMapConsumer = i -> {};
    private Consumer<List<ParameterMapping>> secondParamConsumer = i -> {};
    private Consumer<Map<String, Object>> secondParamMapConsumer = i -> {};
    private final long firstParam;
    private final long secondParam;

    public DialectModel(String dialectSql, long firstParam, long secondParam) {
        this.dialectSql = dialectSql;
        this.firstParam = firstParam;
        this.secondParam = secondParam;
    }

    public DialectModel setConsumer(boolean isFirstParam, Function<List<ParameterMapping>, Integer> function) {
        if (isFirstParam) {
            this.firstParamConsumer = i -> i.add((Integer)function.apply((List<ParameterMapping>)i), new ParameterMapping.Builder(this.configuration, FIRST_PARAM_NAME, Long.TYPE).build());
        } else {
            this.secondParamConsumer = i -> i.add((Integer)function.apply((List<ParameterMapping>)i), new ParameterMapping.Builder(this.configuration, SECOND_PARAM_NAME, Long.TYPE).build());
        }
        this.setParamMapConsumer(isFirstParam);
        return this;
    }

    public DialectModel setConsumer(boolean isFirstParam) {
        if (isFirstParam) {
            this.firstParamConsumer = i -> i.add(new ParameterMapping.Builder(this.configuration, FIRST_PARAM_NAME, Long.TYPE).build());
        } else {
            this.secondParamConsumer = i -> i.add(new ParameterMapping.Builder(this.configuration, SECOND_PARAM_NAME, Long.TYPE).build());
        }
        this.setParamMapConsumer(isFirstParam);
        return this;
    }

    public DialectModel setConsumerChain() {
        return this.setConsumer(true).setConsumer(false);
    }

    public void consumers(List<ParameterMapping> parameterMappings, Configuration configuration, Map<String, Object> additionalParameters) {
        Assert.notNull((Object)configuration, (String)"configuration must notNull !", (Object[])new Object[0]);
        Assert.notNull(parameterMappings, (String)"parameterMappings must notNull !", (Object[])new Object[0]);
        Assert.notNull(additionalParameters, (String)"additionalParameters must notNull !", (Object[])new Object[0]);
        this.configuration = configuration;
        this.firstParamConsumer.accept(parameterMappings);
        this.secondParamConsumer.accept(parameterMappings);
        this.firstParamMapConsumer.accept(additionalParameters);
        this.secondParamMapConsumer.accept(additionalParameters);
    }

    private void setParamMapConsumer(boolean isFirstParam) {
        if (isFirstParam) {
            this.firstParamMapConsumer = i -> i.put(FIRST_PARAM_NAME, this.firstParam);
        } else {
            this.secondParamMapConsumer = i -> i.put(SECOND_PARAM_NAME, this.secondParam);
        }
    }

    public String getDialectSql() {
        return this.dialectSql;
    }
}

