/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.driver;

import org.apache.hugegraph.api.gremlin.CypherAPI;
import org.apache.hugegraph.api.job.CypherJobAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.driver.GraphManager;
import org.apache.hugegraph.structure.gremlin.Response;
import org.apache.hugegraph.structure.gremlin.ResultSet;

public class CypherManager {
    private final GraphManager graphManager;
    private final CypherJobAPI cypherJobAPI;
    private final String graphSpace;
    private final String graph;
    private final CypherAPI cypherAPI;

    public CypherManager(RestClient client, String graphSpace, String graph, GraphManager graphManager) {
        this.graphManager = graphManager;
        this.cypherAPI = new CypherAPI(client);
        this.cypherJobAPI = new CypherJobAPI(client, graphSpace, graph);
        this.graphSpace = graphSpace;
        this.graph = graph;
    }

    public ResultSet cypher(String cypher) {
        return this.execute(cypher);
    }

    public ResultSet execute(String cypher) {
        Response response = this.cypherAPI.post(this.graphSpace, this.graph, cypher);
        response.graphManager(this.graphManager);
        return response.result();
    }

    public long executeAsTask(String cypher) {
        return this.cypherJobAPI.execute(cypher);
    }
}

