/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Incremental Minimum Spanning Tree algorithm performance test - medium graph
 * Test performance on medium-sized graphs
 */
CREATE TABLE inc_mst_perf_medium_result (
  srcId int,
  targetId int,
  weight double
) WITH (
    type='file',
    geaflow.dsl.file.path = '${target}'
);

USE GRAPH medium_graph;

INSERT INTO inc_mst_perf_medium_result
CALL IncMST(50, 0.001, 'mst_perf_medium_edges') YIELD (srcId, targetId, weight)
RETURN srcId, targetId, weight;
