/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.JniBasedUnixGroupsMapping;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.PerformanceAdvisory;

public class JniBasedUnixGroupsMappingWithFallback
implements GroupMappingServiceProvider {
    private static final Log LOG = LogFactory.getLog(JniBasedUnixGroupsMappingWithFallback.class);
    private GroupMappingServiceProvider impl;

    public JniBasedUnixGroupsMappingWithFallback() {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            this.impl = new JniBasedUnixGroupsMapping();
        } else {
            PerformanceAdvisory.LOG.debug("Falling back to shell based");
            this.impl = new ShellBasedUnixGroupsMapping();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Group mapping impl=" + this.impl.getClass().getName());
        }
    }

    @Override
    public List<String> getGroups(String user) throws IOException {
        return this.impl.getGroups(user);
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
        this.impl.cacheGroupsRefresh();
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
        this.impl.cacheGroupsAdd(groups);
    }
}

