/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import org.apache.flink.shaded.hadoop2.com.google.common.base.Preconditions;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;

class BlockToMarkCorrupt {
    private final BlockInfo corrupted;
    private final BlockInfo stored;
    private final String reason;
    private final CorruptReplicasMap.Reason reasonCode;

    BlockToMarkCorrupt(BlockInfo corrupted, BlockInfo stored, String reason, CorruptReplicasMap.Reason reasonCode) {
        Preconditions.checkNotNull(corrupted, "corrupted is null");
        Preconditions.checkNotNull(stored, "stored is null");
        this.corrupted = corrupted;
        this.stored = stored;
        this.reason = reason;
        this.reasonCode = reasonCode;
    }

    BlockToMarkCorrupt(BlockInfo stored, String reason, CorruptReplicasMap.Reason reasonCode) {
        this(stored, stored, reason, reasonCode);
    }

    BlockToMarkCorrupt(BlockInfo stored, long gs, String reason, CorruptReplicasMap.Reason reasonCode) {
        this((BlockInfo)new BlockInfoContiguous((BlockInfoContiguous)stored), stored, reason, reasonCode);
        this.corrupted.setGenerationStamp(gs);
    }

    public boolean isCorruptedDuringWrite() {
        return this.stored.getGenerationStamp() > this.corrupted.getGenerationStamp();
    }

    public BlockInfo getCorrupted() {
        return this.corrupted;
    }

    public BlockInfo getStored() {
        return this.stored;
    }

    public String getReason() {
        return this.reason;
    }

    public CorruptReplicasMap.Reason getReasonCode() {
        return this.reasonCode;
    }

    public String toString() {
        return this.corrupted + "(" + (this.corrupted == this.stored ? "same as stored" : "stored=" + this.stored) + ")";
    }
}

