/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.metrics.prometheus;

import io.prometheus.client.exporter.HTTPServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Iterator;
import org.apache.fluss.metrics.prometheus.AbstractPrometheusReporter;
import org.apache.fluss.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusReporter
extends AbstractPrometheusReporter {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusReporter.class);
    private HTTPServer httpServer;
    private int port;

    int getPort() {
        Preconditions.checkState((this.httpServer != null ? 1 : 0) != 0, (Object)"Server has not been initialized.");
        return this.port;
    }

    PrometheusReporter(Iterator<Integer> ports) {
        while (ports.hasNext()) {
            this.port = ports.next();
            try {
                this.httpServer = new HTTPServer(new InetSocketAddress(this.port), this.registry);
                LOG.info("Started PrometheusReporter HTTP server on port {}.", (Object)this.port);
                break;
            }
            catch (IOException ioe) {
                LOG.debug("Could not start PrometheusReporter HTTP server on port {}.", (Object)this.port, (Object)ioe);
            }
        }
        if (this.httpServer == null) {
            throw new RuntimeException("Could not start PrometheusReporter HTTP server on any configured port. Ports: " + ports);
        }
    }

    @Override
    public void close() {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        super.close();
    }
}

