/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.DNSSEC;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.base16;
import org.xbill.DNS.utils.base64;

public class HIPRecord
extends Record {
    private byte[] hit;
    private int pkAlgorithm;
    private byte[] publicKey;
    private List<Name> rvServers = new ArrayList<Name>();

    HIPRecord() {
    }

    public HIPRecord(Name name, int dclass, long ttl, byte[] hit, int alg, byte[] key, List<Name> servers) {
        super(name, 55, dclass, ttl);
        this.hit = hit;
        this.pkAlgorithm = alg;
        this.publicKey = key;
        if (servers != null) {
            this.rvServers.addAll(servers);
        }
    }

    public HIPRecord(Name name, int dclass, long ttl, byte[] hit, int alg, byte[] key) {
        this(name, dclass, ttl, hit, alg, key, null);
    }

    public HIPRecord(Name name, int dclass, long ttl, byte[] hit, int alg, PublicKey key, List<Name> servers) throws DNSSEC.DNSSECException {
        this(name, dclass, ttl, hit, alg, DNSSEC.fromPublicKey(key, HIPRecord.mapAlgTypeToDnssec(alg)), servers);
    }

    public HIPRecord(Name name, int dclass, long ttl, byte[] hit, int alg, PublicKey key) throws DNSSEC.DNSSECException {
        this(name, dclass, ttl, hit, alg, key, null);
    }

    public byte[] getHit() {
        return this.hit;
    }

    public int getAlgorithm() {
        return this.pkAlgorithm;
    }

    public byte[] getKey() {
        return this.publicKey;
    }

    public PublicKey getPublicKey() throws DNSSEC.DNSSECException {
        return DNSSEC.toPublicKey((int)HIPRecord.mapAlgTypeToDnssec(this.pkAlgorithm), (byte[])this.publicKey, (Record)this);
    }

    public List<Name> getRvServers() {
        return Collections.unmodifiableList(this.rvServers);
    }

    private static int mapAlgTypeToDnssec(int alg) throws DNSSEC.UnsupportedAlgorithmException {
        switch (alg) {
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
        }
        throw new DNSSEC.UnsupportedAlgorithmException(alg);
    }

    @Override
    protected String rrToString() {
        StringBuilder sb = new StringBuilder();
        if (Options.check("multiline")) {
            sb.append("( ");
        }
        String separator = Options.check("multiline") ? "\n\t" : " ";
        sb.append(this.pkAlgorithm);
        sb.append(" ");
        sb.append(base16.toString(this.hit));
        sb.append(separator);
        sb.append(base64.toString(this.publicKey));
        if (!this.rvServers.isEmpty()) {
            sb.append(separator);
        }
        sb.append(this.rvServers.stream().map(Name::toString).collect(Collectors.joining(separator)));
        if (Options.check("multiline")) {
            sb.append(" )");
        }
        return sb.toString();
    }

    @Override
    protected void rdataFromString(Tokenizer st, Name origin) throws IOException {
        Tokenizer.Token t2;
        this.pkAlgorithm = st.getUInt8();
        this.hit = st.getHexString();
        this.publicKey = base64.fromString(st.getString());
        while ((t2 = st.get()).isString()) {
            this.rvServers.add(new Name(t2.value));
        }
    }

    @Override
    protected void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeU8(this.hit.length);
        out.writeU8(this.pkAlgorithm);
        out.writeU16(this.publicKey.length);
        out.writeByteArray(this.hit);
        out.writeByteArray(this.publicKey);
        this.rvServers.forEach(n -> n.toWire(out, null, canonical));
    }

    @Override
    protected void rrFromWire(DNSInput in) throws IOException {
        int hitLength = in.readU8();
        this.pkAlgorithm = in.readU8();
        int pkLength = in.readU16();
        this.hit = in.readByteArray(hitLength);
        this.publicKey = in.readByteArray(pkLength);
        while (in.remaining() > 0) {
            this.rvServers.add(new Name(in));
        }
    }
}

