/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.shaded.hadoop3.com.google.re2j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fluss.fs.shaded.hadoop3.com.google.re2j.Inst;
import org.apache.fluss.fs.shaded.hadoop3.com.google.re2j.MachineInput;
import org.apache.fluss.fs.shaded.hadoop3.com.google.re2j.Prog;
import org.apache.fluss.fs.shaded.hadoop3.com.google.re2j.RE2;
import org.apache.fluss.fs.shaded.hadoop3.com.google.re2j.Utils;

class Machine {
    private RE2 re2;
    private final Prog prog;
    private final Queue q0;
    private final Queue q1;
    private List<Thread> pool = new ArrayList<Thread>();
    private boolean matched;
    private int[] matchcap;

    Machine(RE2 re2) {
        this.prog = re2.prog;
        this.re2 = re2;
        this.q0 = new Queue(this.prog.numInst());
        this.q1 = new Queue(this.prog.numInst());
        this.matchcap = new int[this.prog.numCap < 2 ? 2 : this.prog.numCap];
    }

    void init(int ncap) {
        for (Thread t2 : this.pool) {
            t2.cap = new int[ncap];
        }
        this.matchcap = new int[ncap];
    }

    int[] submatches() {
        if (this.matchcap.length == 0) {
            return Utils.EMPTY_INTS;
        }
        int[] cap = new int[this.matchcap.length];
        System.arraycopy(this.matchcap, 0, cap, 0, this.matchcap.length);
        return cap;
    }

    private Thread alloc(Inst inst) {
        int n = this.pool.size();
        Thread t2 = n > 0 ? this.pool.remove(n - 1) : new Thread(this.matchcap.length);
        t2.inst = inst;
        return t2;
    }

    private void free(Thread t2) {
        this.pool.add(t2);
    }

    boolean match(MachineInput in, int pos, int anchor) {
        int startCond = this.re2.cond;
        if (startCond == -1) {
            return false;
        }
        if ((anchor == 1 || anchor == 2) && pos != 0) {
            return false;
        }
        this.matched = false;
        Arrays.fill(this.matchcap, -1);
        Queue runq = this.q0;
        Queue nextq = this.q1;
        int r = in.step(pos);
        int rune = r >> 3;
        int width = r & 7;
        int rune1 = -1;
        int width1 = 0;
        if (r != -8) {
            r = in.step(pos + width);
            rune1 = r >> 3;
            width1 = r & 7;
        }
        int flag = pos == 0 ? Utils.emptyOpContext(-1, rune) : in.context(pos);
        while (true) {
            if (runq.isEmpty()) {
                if ((startCond & 4) != 0 && pos != 0 || this.matched) break;
                if (!this.re2.prefix.isEmpty() && rune1 != this.re2.prefixRune && in.canCheckPrefix()) {
                    int advance = in.index(this.re2, pos);
                    if (advance < 0) break;
                    r = in.step(pos += advance);
                    rune = r >> 3;
                    width = r & 7;
                    r = in.step(pos + width);
                    rune1 = r >> 3;
                    width1 = r & 7;
                }
            }
            if (!(this.matched || pos != 0 && anchor != 0)) {
                if (this.matchcap.length > 0) {
                    this.matchcap[0] = pos;
                }
                this.add(runq, this.prog.start, pos, this.matchcap, flag, null);
            }
            flag = Utils.emptyOpContext(rune, rune1);
            this.step(runq, nextq, pos, pos + width, rune, flag, anchor, pos == in.endPos());
            if (width == 0 || this.matchcap.length == 0 && this.matched) break;
            pos += width;
            rune = rune1;
            width = width1;
            if (rune != -1) {
                r = in.step(pos + width);
                rune1 = r >> 3;
                width1 = r & 7;
            }
            Queue tmpq = runq;
            runq = nextq;
            nextq = tmpq;
        }
        nextq.clear(this.pool);
        return this.matched;
    }

    private void step(Queue runq, Queue nextq, int pos, int nextPos, int c, int nextCond, int anchor, boolean atEnd) {
        boolean longest = this.re2.longest;
        for (int j = 0; j < runq.size; ++j) {
            Thread t2;
            Queue.Entry entry = runq.dense[j];
            if (entry == null || (t2 = entry.thread) == null) continue;
            if (longest && this.matched && t2.cap.length > 0 && this.matchcap[0] < t2.cap[0]) {
                this.pool.add(t2);
                continue;
            }
            Inst i = t2.inst;
            boolean add = false;
            switch (i.op) {
                case MATCH: {
                    if (anchor == 2 && !atEnd) break;
                    if (!(t2.cap.length <= 0 || longest && this.matched && this.matchcap[1] >= pos)) {
                        t2.cap[1] = pos;
                        System.arraycopy(t2.cap, 0, this.matchcap, 0, t2.cap.length);
                    }
                    if (!longest) {
                        for (int k = j + 1; k < runq.size; ++k) {
                            Queue.Entry d = runq.dense[k];
                            if (d.thread == null) continue;
                            this.pool.add(d.thread);
                        }
                        runq.size = 0;
                    }
                    this.matched = true;
                    break;
                }
                case RUNE: {
                    add = i.matchRune(c);
                    break;
                }
                case RUNE1: {
                    add = c == i.runes[0];
                    break;
                }
                case RUNE_ANY: {
                    add = true;
                    break;
                }
                case RUNE_ANY_NOT_NL: {
                    add = c != 10;
                    break;
                }
                default: {
                    throw new IllegalStateException("bad inst");
                }
            }
            if (add) {
                t2 = this.add(nextq, i.out, nextPos, t2.cap, nextCond, t2);
            }
            if (t2 == null) continue;
            this.pool.add(t2);
        }
        runq.size = 0;
    }

    private Thread add(Queue q, int pc, int pos, int[] cap, int cond, Thread t2) {
        if (pc == 0) {
            return t2;
        }
        if (q.contains(pc)) {
            return t2;
        }
        Queue.Entry d = q.add(pc);
        Inst inst = this.prog.getInst(pc);
        switch (inst.op()) {
            default: {
                throw new IllegalStateException("unhandled");
            }
            case FAIL: {
                break;
            }
            case ALT: 
            case ALT_MATCH: {
                t2 = this.add(q, inst.out, pos, cap, cond, t2);
                t2 = this.add(q, inst.arg, pos, cap, cond, t2);
                break;
            }
            case EMPTY_WIDTH: {
                if ((inst.arg & ~cond) != 0) break;
                t2 = this.add(q, inst.out, pos, cap, cond, t2);
                break;
            }
            case NOP: {
                t2 = this.add(q, inst.out, pos, cap, cond, t2);
                break;
            }
            case CAPTURE: {
                if (inst.arg < cap.length) {
                    int opos = cap[inst.arg];
                    cap[inst.arg] = pos;
                    this.add(q, inst.out, pos, cap, cond, null);
                    cap[inst.arg] = opos;
                    break;
                }
                t2 = this.add(q, inst.out, pos, cap, cond, t2);
                break;
            }
            case MATCH: 
            case RUNE: 
            case RUNE1: 
            case RUNE_ANY: 
            case RUNE_ANY_NOT_NL: {
                if (t2 == null) {
                    t2 = this.alloc(inst);
                } else {
                    t2.inst = inst;
                }
                if (cap.length > 0 && t2.cap != cap) {
                    System.arraycopy(cap, 0, t2.cap, 0, cap.length);
                }
                d.thread = t2;
                t2 = null;
            }
        }
        return t2;
    }

    private static class Queue {
        final Entry[] dense;
        final int[] sparse;
        int size;

        Queue(int n) {
            this.sparse = new int[n];
            this.dense = new Entry[n];
        }

        boolean contains(int pc) {
            int j = this.sparse[pc];
            if (j >= this.size) {
                return false;
            }
            Entry d = this.dense[j];
            return d != null && d.pc == pc;
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        Entry add(int pc) {
            int j;
            this.sparse[pc] = j = this.size++;
            Entry e = this.dense[j];
            if (e == null) {
                e = this.dense[j] = new Entry();
            }
            e.thread = null;
            e.pc = pc;
            return e;
        }

        void clear(List<Thread> freePool) {
            for (int i = 0; i < this.size; ++i) {
                Entry entry = this.dense[i];
                if (entry == null || entry.thread == null) continue;
                freePool.add(entry.thread);
            }
            this.size = 0;
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append('{');
            for (int i = 0; i < this.size; ++i) {
                if (i != 0) {
                    out.append(", ");
                }
                out.append(this.dense[i].pc);
            }
            out.append('}');
            return out.toString();
        }

        static class Entry {
            int pc;
            Thread thread;

            Entry() {
            }
        }
    }

    private static class Thread {
        int[] cap;
        Inst inst;

        Thread(int n) {
            this.cap = new int[n];
        }
    }
}

