/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.oss.token;

import com.aliyun.oss.common.auth.DefaultCredentials;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.sts.AssumeRoleRequest;
import com.aliyuncs.auth.sts.AssumeRoleResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.UUID;
import org.apache.fluss.fs.token.Credentials;
import org.apache.fluss.fs.token.CredentialsJsonSerde;
import org.apache.fluss.fs.token.ObtainedSecurityToken;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.aliyun.oss.AliyunOSSUtils;

public class OSSSecurityTokenProvider {
    private static final String ROLE_ARN_KEY = "fs.oss.roleArn";
    private static final String STS_ENDPOINT_KEY = "fs.oss.sts.endpoint";
    private final String endpoint;
    private final String region;
    private final DefaultAcsClient acsClient;
    private final String roleArn;

    public OSSSecurityTokenProvider(Configuration conf) throws IOException {
        this.endpoint = AliyunOSSUtils.getValueWithKey(conf, "fs.oss.endpoint");
        String accessKeyId = AliyunOSSUtils.getValueWithKey(conf, "fs.oss.accessKeyId");
        String accessKeySecret = AliyunOSSUtils.getValueWithKey(conf, "fs.oss.accessKeySecret");
        String endpoint = AliyunOSSUtils.getValueWithKey(conf, STS_ENDPOINT_KEY);
        this.region = AliyunOSSUtils.getValueWithKey(conf, "fs.oss.region");
        DefaultProfile.addEndpoint("", "Sts", endpoint);
        DefaultProfile profile = DefaultProfile.getProfile("", accessKeyId, accessKeySecret);
        this.acsClient = new DefaultAcsClient(profile);
        this.roleArn = conf.get(ROLE_ARN_KEY);
    }

    public ObtainedSecurityToken obtainSecurityToken(String scheme) throws Exception {
        AssumeRoleRequest request = new AssumeRoleRequest();
        request.setSysMethod(MethodType.POST);
        request.setRoleArn(this.roleArn);
        request.setRoleSessionName("fluss-" + UUID.randomUUID());
        AssumeRoleResponse response = this.acsClient.getAcsResponse(request);
        AssumeRoleResponse.Credentials credentials = response.getCredentials();
        DefaultCredentials defaultCredentials = new DefaultCredentials(response.getCredentials().getAccessKeyId(), response.getCredentials().getAccessKeySecret(), response.getCredentials().getSecurityToken());
        HashMap<String, String> additionInfo = new HashMap<String, String>();
        additionInfo.put("fs.oss.endpoint", this.endpoint);
        additionInfo.put("fs.oss.region", this.region);
        return new ObtainedSecurityToken(scheme, this.toJson(defaultCredentials), Long.valueOf(Instant.parse(credentials.getExpiration()).toEpochMilli()), additionInfo);
    }

    private byte[] toJson(DefaultCredentials defaultCredentials) {
        Credentials credentials = new Credentials(defaultCredentials.getAccessKeyId(), defaultCredentials.getSecretAccessKey(), defaultCredentials.getSecurityToken());
        return CredentialsJsonSerde.toJson((Credentials)credentials);
    }
}

