/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal.signer;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.ServiceSignature;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.internal.SignUtils;
import com.aliyun.oss.internal.signer.OSSSignerBase;
import com.aliyun.oss.internal.signer.OSSSignerParams;

public class OSSV1Signer
extends OSSSignerBase {
    public OSSV1Signer(OSSSignerParams signerParams) {
        super(signerParams);
    }

    @Override
    protected void addAuthorizationHeader(RequestMessage request) {
        Credentials cred = this.signerParams.getCredentials();
        String accessKeyId = cred.getAccessKeyId();
        String secretAccessKey = cred.getSecretAccessKey();
        String signature = SignUtils.buildSignature(secretAccessKey, request.getMethod().toString(), this.signerParams.getResourcePath(), request);
        request.addHeader("Authorization", SignUtils.composeRequestAuthorization(accessKeyId, signature));
    }

    @Override
    public void presign(RequestMessage request) throws ClientException {
        Credentials cred = this.signerParams.getCredentials();
        String accessKeyId = cred.getAccessKeyId();
        String secretAccessKey = cred.getSecretAccessKey();
        String canonicalResource = this.signerParams.getResourcePath();
        String expires = String.valueOf(this.signerParams.getExpiration().getTime() / 1000L);
        if (cred.useSecurityToken()) {
            request.addParameter("security-token", cred.getSecurityToken());
        }
        request.addHeader("Date", expires);
        String canonicalString = SignUtils.buildCanonicalString(request.getMethod().toString(), canonicalResource, request, expires);
        String signature = ServiceSignature.create().computeSignature(secretAccessKey, canonicalString);
        request.addParameter("Expires", expires);
        request.addParameter("OSSAccessKeyId", accessKeyId);
        request.addParameter("Signature", signature);
    }
}

