/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.ITtlTimeProvider;
import org.apache.hadoop.fs.s3a.s3guard.MetastoreInstrumentation;
import org.apache.hadoop.fs.s3a.s3guard.MetastoreInstrumentationImpl;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.RenameTracker;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface MetadataStore
extends Closeable {
    public void initialize(FileSystem var1, ITtlTimeProvider var2) throws IOException;

    public void initialize(Configuration var1, ITtlTimeProvider var2) throws IOException;

    public void delete(Path var1, @Nullable BulkOperationState var2) throws IOException;

    @VisibleForTesting
    public void forgetMetadata(Path var1) throws IOException;

    public void deleteSubtree(Path var1, @Nullable BulkOperationState var2) throws IOException;

    public void deletePaths(Collection<Path> var1, @Nullable BulkOperationState var2) throws IOException;

    public PathMetadata get(Path var1) throws IOException;

    public PathMetadata get(Path var1, boolean var2) throws IOException;

    public DirListingMetadata listChildren(Path var1) throws IOException;

    public void addAncestors(Path var1, @Nullable BulkOperationState var2) throws IOException;

    public void move(@Nullable Collection<Path> var1, @Nullable Collection<PathMetadata> var2, @Nullable BulkOperationState var3) throws IOException;

    public void put(PathMetadata var1) throws IOException;

    public void put(PathMetadata var1, @Nullable BulkOperationState var2) throws IOException;

    public void put(Collection<? extends PathMetadata> var1, @Nullable BulkOperationState var2) throws IOException;

    public void put(DirListingMetadata var1, List<Path> var2, @Nullable BulkOperationState var3) throws IOException;

    public void destroy() throws IOException;

    public void prune(PruneMode var1, long var2) throws IOException, UnsupportedOperationException;

    public long prune(PruneMode var1, long var2, String var4) throws IOException, UnsupportedOperationException;

    public Map<String, String> getDiagnostics() throws IOException;

    public void updateParameters(Map<String, String> var1) throws IOException;

    default public int markAsAuthoritative(Path dest, BulkOperationState operationState) throws IOException {
        return 0;
    }

    public RenameTracker initiateRenameOperation(StoreContext var1, Path var2, S3AFileStatus var3, Path var4) throws IOException;

    default public BulkOperationState initiateBulkWrite(BulkOperationState.OperationType operation, Path dest) throws IOException {
        return new BulkOperationState(operation);
    }

    public void setTtlTimeProvider(ITtlTimeProvider var1);

    default public MetastoreInstrumentation getInstrumentation() {
        return new MetastoreInstrumentationImpl();
    }

    public static enum PruneMode {
        ALL_BY_MODTIME,
        TOMBSTONES_BY_LASTUPDATED;

    }
}

