/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.lance;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.lance.LanceTable;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.types.RowType;

public class LanceTableImpl
implements ReadonlyTable,
LanceTable {
    private final Identifier identifier;
    private final FileIO fileIO;
    private final RowType rowType;
    private final String location;
    private final Map<String, String> options;
    @Nullable
    private final String comment;

    public LanceTableImpl(Identifier identifier, FileIO fileIO, RowType rowType, String location, Map<String, String> options, @Nullable String comment) {
        this.identifier = identifier;
        this.fileIO = fileIO;
        this.rowType = rowType;
        this.location = location;
        this.options = options;
        this.comment = comment;
    }

    @Override
    public String name() {
        return this.identifier.getTableName();
    }

    @Override
    public String fullName() {
        return this.identifier.getFullName();
    }

    @Override
    public RowType rowType() {
        return this.rowType;
    }

    @Override
    public List<String> partitionKeys() {
        return Collections.emptyList();
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Optional<String> comment() {
        return Optional.ofNullable(this.comment);
    }

    @Override
    public Optional<Statistics> statistics() {
        return ReadonlyTable.super.statistics();
    }

    @Override
    public FileIO fileIO() {
        return this.fileIO;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public LanceTable copy(Map<String, String> dynamicOptions) {
        HashMap<String, String> newOptions = new HashMap<String, String>(this.options);
        newOptions.putAll(dynamicOptions);
        return new LanceTableImpl(this.identifier, this.fileIO, this.rowType, this.location, newOptions, this.comment);
    }

    @Override
    public InnerTableScan newScan() {
        throw new UnsupportedOperationException("LanceTable does not support InnerTableScan. Use newRead() instead.");
    }

    @Override
    public InnerTableRead newRead() {
        throw new UnsupportedOperationException("LanceTable does not support InnerTableRead. Use newScan() instead.");
    }
}

