/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.hc.client5.http.protocol;

import java.io.IOException;
import org.apache.paimon.shade.hc.client5.http.RouteInfo;
import org.apache.paimon.shade.hc.client5.http.auth.AuthCache;
import org.apache.paimon.shade.hc.client5.http.auth.AuthExchange;
import org.apache.paimon.shade.hc.client5.http.auth.AuthScheme;
import org.apache.paimon.shade.hc.client5.http.auth.CredentialsProvider;
import org.apache.paimon.shade.hc.client5.http.impl.RequestSupport;
import org.apache.paimon.shade.hc.client5.http.protocol.HttpClientContext;
import org.apache.paimon.shade.hc.core5.annotation.Contract;
import org.apache.paimon.shade.hc.core5.annotation.ThreadingBehavior;
import org.apache.paimon.shade.hc.core5.http.EntityDetails;
import org.apache.paimon.shade.hc.core5.http.HttpException;
import org.apache.paimon.shade.hc.core5.http.HttpHost;
import org.apache.paimon.shade.hc.core5.http.HttpRequest;
import org.apache.paimon.shade.hc.core5.http.HttpRequestInterceptor;
import org.apache.paimon.shade.hc.core5.http.protocol.HttpContext;
import org.apache.paimon.shade.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestAuthCache
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestAuthCache.class);

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        AuthScheme authScheme;
        AuthExchange proxyAuthExchange;
        HttpHost proxy;
        String pathPrefix;
        AuthScheme authScheme2;
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        HttpClientContext clientContext = HttpClientContext.cast(context);
        String exchangeId = clientContext.getExchangeId();
        AuthCache authCache = clientContext.getAuthCache();
        if (authCache == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Auth cache not set in the context", (Object)exchangeId);
            }
            return;
        }
        CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
        if (credsProvider == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Credentials provider not set in the context", (Object)exchangeId);
            }
            return;
        }
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Route info not set in the context", (Object)exchangeId);
            }
            return;
        }
        HttpHost target = new HttpHost(request.getScheme(), request.getAuthority());
        AuthExchange targetAuthExchange = clientContext.getAuthExchange(target);
        if (targetAuthExchange.getState() == AuthExchange.State.UNCHALLENGED && (authScheme2 = authCache.get(target, pathPrefix = RequestSupport.extractPathPrefix(request))) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Re-using cached '{}' auth scheme for {}", new Object[]{exchangeId, authScheme2.getName(), target});
            }
            targetAuthExchange.select(authScheme2);
        }
        if ((proxy = route.getProxyHost()) != null && (proxyAuthExchange = clientContext.getAuthExchange(proxy)).getState() == AuthExchange.State.UNCHALLENGED && (authScheme = authCache.get(proxy, null)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} Re-using cached '{}' auth scheme for {}", new Object[]{exchangeId, authScheme.getName(), proxy});
            }
            proxyAuthExchange.select(authScheme);
        }
    }
}

