/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import javax.annotation.Nullable;
import org.apache.paimon.utils.BiFilter;
import org.apache.paimon.utils.Filter;

public class BucketFilter {
    private final boolean onlyReadRealBuckets;
    @Nullable
    private final Integer specifiedBucket;
    @Nullable
    private final Filter<Integer> bucketFilter;
    @Nullable
    private final BiFilter<Integer, Integer> totalAwareBucketFilter;

    public BucketFilter(boolean onlyReadRealBuckets, @Nullable Integer specifiedBucket, @Nullable Filter<Integer> bucketFilter, @Nullable BiFilter<Integer, Integer> totalAwareBucketFilter) {
        this.onlyReadRealBuckets = onlyReadRealBuckets;
        this.specifiedBucket = specifiedBucket;
        this.bucketFilter = bucketFilter;
        this.totalAwareBucketFilter = totalAwareBucketFilter;
    }

    @Nullable
    public static BucketFilter create(boolean onlyReadRealBuckets, @Nullable Integer specifiedBucket, @Nullable Filter<Integer> bucketFilter, @Nullable BiFilter<Integer, Integer> totalAwareBucketFilter) {
        if (!onlyReadRealBuckets && specifiedBucket == null && bucketFilter == null && totalAwareBucketFilter == null) {
            return null;
        }
        return new BucketFilter(onlyReadRealBuckets, specifiedBucket, bucketFilter, totalAwareBucketFilter);
    }

    @Nullable
    public Integer specifiedBucket() {
        return this.specifiedBucket;
    }

    public boolean test(int bucket, int totalBucket) {
        if (this.onlyReadRealBuckets && bucket < 0) {
            return false;
        }
        if (this.specifiedBucket != null && bucket != this.specifiedBucket) {
            return false;
        }
        if (this.bucketFilter != null && !this.bucketFilter.test(bucket)) {
            return false;
        }
        return this.totalAwareBucketFilter == null || this.totalAwareBucketFilter.test(bucket, totalBucket);
    }
}

