/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.FileReaderFactory;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.SimpleStatsEvolution;
import org.apache.paimon.stats.SimpleStatsEvolutions;
import org.apache.paimon.table.PrimaryKeyTableUtils;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordLevelExpire {
    private static final Logger LOG = LoggerFactory.getLogger(RecordLevelExpire.class);
    private final long expireTime;
    private final Function<InternalRow, Optional<Long>> fieldGetter;
    private final ConcurrentMap<Long, TableSchema> tableSchemas;
    private final TableSchema schema;
    private final SchemaManager schemaManager;
    private final SimpleStatsEvolutions fieldValueStatsConverters;

    @Nullable
    public static RecordLevelExpire create(CoreOptions options, TableSchema schema, SchemaManager schemaManager) {
        Duration expireTime = options.recordLevelExpireTime();
        if (expireTime == null) {
            return null;
        }
        String timeFieldName = options.recordLevelTimeField();
        if (timeFieldName == null) {
            throw new IllegalArgumentException("You should set time field for record-level expire.");
        }
        RowType rowType = schema.logicalRowType();
        int fieldIndex = rowType.getFieldIndex(timeFieldName);
        if (fieldIndex == -1) {
            throw new IllegalArgumentException(String.format("Can not find time field %s for record level expire.", timeFieldName));
        }
        DataType dataType = rowType.getField(timeFieldName).type();
        Function<InternalRow, Optional<Long>> fieldGetter = RecordLevelExpire.createFieldGetterAndConvertToSecond(dataType, fieldIndex);
        LOG.info("Create RecordExpire. expireTime is {}s,timeField is {}", (Object)expireTime.getSeconds(), (Object)timeFieldName);
        return new RecordLevelExpire(expireTime.getSeconds(), fieldGetter, schema, schemaManager);
    }

    private RecordLevelExpire(long expireTime, Function<InternalRow, Optional<Long>> fieldGetter, TableSchema schema, SchemaManager schemaManager) {
        this.expireTime = expireTime;
        this.fieldGetter = fieldGetter;
        this.tableSchemas = new ConcurrentHashMap<Long, TableSchema>();
        this.schema = schema;
        this.schemaManager = schemaManager;
        PrimaryKeyTableUtils.PrimaryKeyFieldsExtractor extractor = PrimaryKeyTableUtils.PrimaryKeyFieldsExtractor.EXTRACTOR;
        this.fieldValueStatsConverters = new SimpleStatsEvolutions(sid -> extractor.valueFields(this.scanTableSchema((long)sid)), schema.id());
    }

    public boolean isExpireFile(DataFileMeta file) {
        InternalRow minValues = file.valueStats().minValues();
        if (file.schemaId() != this.schema.id() || file.valueStatsCols() != null) {
            SimpleStatsEvolution.Result result = this.fieldValueStatsConverters.getOrCreate(file.schemaId()).evolution(file.valueStats(), (Long)file.rowCount(), file.valueStatsCols());
            minValues = result.minValues();
        }
        long currentTime = System.currentTimeMillis() / 1000L;
        Optional<Long> minTime = this.fieldGetter.apply(minValues);
        if (LOG.isDebugEnabled()) {
            LOG.debug("expire time is {}, currentTime is {}, file min time for time field is {}. file name is {}, file level is {}, file schema id is {}, file valueStatsCols is {}", new Object[]{this.expireTime, currentTime, minTime.isPresent() ? minTime.get() : "empty", file.fileName(), file.level(), file.schemaId(), file.valueStatsCols()});
        }
        return minTime.map(minValue -> currentTime - this.expireTime > minValue).orElse(false);
    }

    public FileReaderFactory<KeyValue> wrap(FileReaderFactory<KeyValue> readerFactory) {
        return file -> this.wrap(readerFactory.createRecordReader(file));
    }

    @VisibleForTesting
    public static Function<InternalRow, Optional<Long>> createFieldGetterAndConvertToSecond(DataType dataType, int fieldIndex) {
        Function<InternalRow, Optional<Long>> fieldGetter;
        if (dataType instanceof IntType) {
            fieldGetter = row -> row.isNullAt(fieldIndex) ? Optional.empty() : Optional.of(Long.valueOf(row.getInt(fieldIndex)));
        } else if (dataType instanceof BigIntType) {
            fieldGetter = row -> {
                if (row.isNullAt(fieldIndex)) {
                    return Optional.empty();
                }
                long value = row.getLong(fieldIndex);
                return Optional.of(value >= 1000000000000L ? value / 1000L : value);
            };
        } else if (dataType instanceof TimestampType || dataType instanceof LocalZonedTimestampType) {
            int precision = DataTypeChecks.getPrecision(dataType);
            fieldGetter = row -> row.isNullAt(fieldIndex) ? Optional.empty() : Optional.of(row.getTimestamp(fieldIndex, precision).getMillisecond() / 1000L);
        } else {
            throw new IllegalArgumentException(String.format("The record level time field type should be one of INT, BIGINT, or TIMESTAMP, but field type is %s.", dataType));
        }
        return fieldGetter;
    }

    private RecordReader<KeyValue> wrap(RecordReader<KeyValue> reader) {
        long currentTime = System.currentTimeMillis() / 1000L;
        return reader.filter(keyValue -> this.fieldGetter.apply(keyValue.value()).map(integer -> currentTime <= integer + this.expireTime).orElse(true));
    }

    private TableSchema scanTableSchema(long id) {
        return this.tableSchemas.computeIfAbsent(id, key -> key.longValue() == this.schema.id() ? this.schema : this.schemaManager.schema(id));
    }
}

