/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors.append;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.BucketedDvMaintainer;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.deletionvectors.append.AppendDeleteFileMaintainer;
import org.apache.paimon.deletionvectors.append.BucketedAppendDeleteFileMaintainer;
import org.apache.paimon.index.DeletionVectorMeta;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.table.source.DeletionFile;
import org.apache.paimon.utils.Preconditions;

public interface BaseAppendDeleteFileMaintainer {
    public BinaryRow getPartition();

    public int getBucket();

    public void notifyNewDeletionVector(String var1, DeletionVector var2);

    public List<IndexManifestEntry> persist();

    public static BucketedAppendDeleteFileMaintainer forBucketedAppend(IndexFileHandler indexFileHandler, @Nullable Snapshot snapshot, BinaryRow partition, int bucket) {
        List<IndexFileMeta> indexFiles = indexFileHandler.scan(snapshot, "DELETION_VECTORS", partition, bucket);
        BucketedDvMaintainer maintainer = BucketedDvMaintainer.factory(indexFileHandler).create(partition, bucket, indexFiles);
        return new BucketedAppendDeleteFileMaintainer(partition, bucket, maintainer);
    }

    public static AppendDeleteFileMaintainer forUnawareAppend(IndexFileHandler indexFileHandler, @Nullable Snapshot snapshot, BinaryRow partition) {
        List<IndexManifestEntry> manifestEntries = indexFileHandler.scan(snapshot, "DELETION_VECTORS").stream().filter(e -> e.partition().equals(partition)).collect(Collectors.toList());
        HashMap<String, DeletionFile> deletionFiles = new HashMap<String, DeletionFile>();
        for (IndexManifestEntry file : manifestEntries) {
            LinkedHashMap<String, DeletionVectorMeta> dvMetas = file.indexFile().dvRanges();
            Preconditions.checkNotNull(dvMetas);
            for (DeletionVectorMeta dvMeta : dvMetas.values()) {
                deletionFiles.put(dvMeta.dataFileName(), new DeletionFile(indexFileHandler.filePath(file).toString(), dvMeta.offset(), dvMeta.length(), dvMeta.cardinality()));
            }
        }
        return new AppendDeleteFileMaintainer(indexFileHandler.dvIndex(partition, 0), partition, manifestEntries, deletionFiles);
    }
}

