/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.variant;

import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.data.variant.GenericVariant;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

public class VariantSchema {
    public int typedIdx;
    public int variantIdx;
    public final int topLevelMetadataIdx;
    public final int numFields;
    public final ScalarType scalarSchema;
    public final ObjectField[] objectSchema;
    public final Map<String, Integer> objectSchemaMap;
    public final VariantSchema arraySchema;
    private byte[] metadata;

    public VariantSchema(int typedIdx, int variantIdx, int topLevelMetadataIdx, int numFields, ScalarType scalarSchema, ObjectField[] objectSchema, VariantSchema arraySchema) {
        this.typedIdx = typedIdx;
        this.numFields = numFields;
        this.variantIdx = variantIdx;
        this.topLevelMetadataIdx = topLevelMetadataIdx;
        this.scalarSchema = scalarSchema;
        this.objectSchema = objectSchema;
        if (objectSchema != null) {
            this.objectSchemaMap = new HashMap<String, Integer>();
            for (int i = 0; i < objectSchema.length; ++i) {
                this.objectSchemaMap.put(objectSchema[i].fieldName, i);
            }
        } else {
            this.objectSchemaMap = null;
        }
        this.arraySchema = arraySchema;
    }

    public void setTypedIdx(int typedIdx) {
        this.typedIdx = typedIdx;
        this.variantIdx = -1;
        this.setMetadata();
    }

    public byte[] getMetadata() {
        return this.metadata;
    }

    public void setMetadata() {
        try {
            String s = new ObjectMapper().writeValueAsString(this.objectSchemaMap);
            this.metadata = GenericVariant.fromJson(s).metadata();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isUnshredded() {
        return this.topLevelMetadataIdx >= 0 && this.variantIdx >= 0 && this.typedIdx < 0;
    }

    public String toString() {
        return "VariantSchema{typedIdx=" + this.typedIdx + ", variantIdx=" + this.variantIdx + ", topLevelMetadataIdx=" + this.topLevelMetadataIdx + ", numFields=" + this.numFields + ", scalarSchema=" + this.scalarSchema + ", objectSchema=" + this.objectSchema + ", arraySchema=" + this.arraySchema + '}';
    }

    public static final class UuidType
    extends ScalarType {
    }

    public static final class TimestampNTZType
    extends ScalarType {
    }

    public static final class TimestampType
    extends ScalarType {
    }

    public static final class DateType
    extends ScalarType {
    }

    public static final class DecimalType
    extends ScalarType {
        public final int precision;
        public final int scale;

        public DecimalType(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }
    }

    public static final class BinaryType
    extends ScalarType {
    }

    public static final class BooleanType
    extends ScalarType {
    }

    public static final class DoubleType
    extends ScalarType {
    }

    public static final class FloatType
    extends ScalarType {
    }

    public static final class IntegralType
    extends ScalarType {
        public final IntegralSize size;

        public IntegralType(IntegralSize size) {
            this.size = size;
        }
    }

    public static enum IntegralSize {
        BYTE,
        SHORT,
        INT,
        LONG;

    }

    public static final class StringType
    extends ScalarType {
    }

    public static abstract class ScalarType {
    }

    public static final class ObjectField {
        public final String fieldName;
        public final VariantSchema schema;

        public ObjectField(String fieldName, VariantSchema schema) {
            this.fieldName = fieldName;
            this.schema = schema;
        }

        public String toString() {
            return "ObjectField{fieldName=" + this.fieldName + ", schema=" + this.schema + '}';
        }
    }
}

