/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.utils.StringUtils;

public class PagedList<T> {
    private final List<T> elements;
    @Nullable
    private final String nextPageToken;

    public PagedList(List<T> elements, @Nullable String nextPageToken) {
        this.elements = elements;
        this.nextPageToken = nextPageToken;
    }

    public List<T> getElements() {
        return this.elements;
    }

    @Nullable
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public static <T> List<T> listAllFromPagedApi(Function<String, PagedList<T>> pagedApi) {
        List<T> elements;
        ArrayList<T> results = new ArrayList<T>();
        String pageToken = null;
        do {
            PagedList<T> response = pagedApi.apply(pageToken);
            pageToken = response.getNextPageToken();
            elements = response.getElements();
            if (elements == null) continue;
            results.addAll(elements);
        } while (pageToken != null && elements != null && !elements.isEmpty() && StringUtils.isNotEmpty(pageToken));
        return results;
    }
}

