/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ZKFCProtocol;
import org.apache.hadoop.ha.proto.ZKFCProtocolProtos;
import org.apache.hadoop.ha.protocolPB.ZKFCProtocolPB;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;

public class ZKFCProtocolClientSideTranslatorPB
implements ZKFCProtocol,
Closeable,
ProtocolTranslator {
    private static final RpcController NULL_CONTROLLER = null;
    private final ZKFCProtocolPB rpcProxy;

    public ZKFCProtocolClientSideTranslatorPB(InetSocketAddress addr, Configuration conf, SocketFactory socketFactory, int timeout2) throws IOException {
        RPC.setProtocolEngine(conf, ZKFCProtocolPB.class, ProtobufRpcEngine2.class);
        this.rpcProxy = RPC.getProxy(ZKFCProtocolPB.class, RPC.getProtocolVersion(ZKFCProtocolPB.class), addr, UserGroupInformation.getCurrentUser(), conf, socketFactory, timeout2);
    }

    @Override
    public void cedeActive(int millisToCede) throws IOException, AccessControlException {
        try {
            ZKFCProtocolProtos.CedeActiveRequestProto req = ZKFCProtocolProtos.CedeActiveRequestProto.newBuilder().setMillisToCede(millisToCede).build();
            this.rpcProxy.cedeActive(NULL_CONTROLLER, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void gracefulFailover() throws IOException, AccessControlException {
        try {
            this.rpcProxy.gracefulFailover(NULL_CONTROLLER, ZKFCProtocolProtos.GracefulFailoverRequestProto.getDefaultInstance());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException(e);
        }
    }

    @Override
    public void close() {
        RPC.stopProxy(this.rpcProxy);
    }

    @Override
    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }
}

