/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.source;

import java.math.BigDecimal;
import org.apache.fluss.lake.paimon.source.FlussMapAsPaimonMap;
import org.apache.fluss.lake.paimon.source.FlussRowAsPaimonRow;
import org.apache.fluss.row.Decimal;
import org.apache.fluss.row.InternalArray;
import org.apache.fluss.row.InternalMap;
import org.apache.fluss.row.InternalRow;
import org.apache.fluss.row.TimestampLtz;
import org.apache.fluss.row.TimestampNtz;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;

public class FlussArrayAsPaimonArray
implements org.apache.paimon.data.InternalArray {
    private final InternalArray flussArray;
    private final DataType elementType;

    public FlussArrayAsPaimonArray(InternalArray flussArray, DataType elementType) {
        this.flussArray = flussArray;
        this.elementType = elementType;
    }

    public int size() {
        return this.flussArray.size();
    }

    public boolean isNullAt(int pos) {
        return this.flussArray.isNullAt(pos);
    }

    public boolean getBoolean(int pos) {
        return this.flussArray.getBoolean(pos);
    }

    public byte getByte(int pos) {
        return this.flussArray.getByte(pos);
    }

    public short getShort(int pos) {
        return this.flussArray.getShort(pos);
    }

    public int getInt(int pos) {
        return this.flussArray.getInt(pos);
    }

    public long getLong(int pos) {
        return this.flussArray.getLong(pos);
    }

    public float getFloat(int pos) {
        return this.flussArray.getFloat(pos);
    }

    public double getDouble(int pos) {
        return this.flussArray.getDouble(pos);
    }

    public BinaryString getString(int pos) {
        return BinaryString.fromBytes((byte[])this.flussArray.getString(pos).toBytes());
    }

    public org.apache.paimon.data.Decimal getDecimal(int pos, int precision, int scale) {
        Decimal flussDecimal = this.flussArray.getDecimal(pos, precision, scale);
        if (flussDecimal.isCompact()) {
            return org.apache.paimon.data.Decimal.fromUnscaledLong((long)flussDecimal.toUnscaledLong(), (int)precision, (int)scale);
        }
        return org.apache.paimon.data.Decimal.fromBigDecimal((BigDecimal)flussDecimal.toBigDecimal(), (int)precision, (int)scale);
    }

    public Timestamp getTimestamp(int pos, int precision) {
        switch (this.elementType.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                if (TimestampNtz.isCompact((int)precision)) {
                    return Timestamp.fromEpochMillis((long)this.flussArray.getTimestampNtz(pos, precision).getMillisecond());
                }
                TimestampNtz timestampNtz = this.flussArray.getTimestampNtz(pos, precision);
                return Timestamp.fromEpochMillis((long)timestampNtz.getMillisecond(), (int)timestampNtz.getNanoOfMillisecond());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                if (TimestampLtz.isCompact((int)precision)) {
                    return Timestamp.fromEpochMillis((long)this.flussArray.getTimestampLtz(pos, precision).getEpochMillisecond());
                }
                TimestampLtz timestampLtz = this.flussArray.getTimestampLtz(pos, precision);
                return Timestamp.fromEpochMillis((long)timestampLtz.getEpochMillisecond(), (int)timestampLtz.getNanoOfMillisecond());
            }
        }
        throw new UnsupportedOperationException("Unsupported array element type for getTimestamp. Only TIMESTAMP_WITHOUT_TIME_ZONE and TIMESTAMP_WITH_LOCAL_TIME_ZONE are supported, but got: " + this.elementType.getTypeRoot() + " (" + this.elementType + ").");
    }

    public byte[] getBinary(int pos) {
        return this.flussArray.getBytes(pos);
    }

    public Variant getVariant(int pos) {
        throw new UnsupportedOperationException("getVariant is not supported for Fluss array currently.");
    }

    public org.apache.paimon.data.InternalArray getArray(int pos) {
        InternalArray innerArray = this.flussArray.getArray(pos);
        return innerArray == null ? null : new FlussArrayAsPaimonArray(innerArray, ((ArrayType)this.elementType).getElementType());
    }

    public org.apache.paimon.data.InternalMap getMap(int pos) {
        InternalMap flussMap = this.flussArray.getMap(pos);
        if (flussMap == null) {
            return null;
        }
        MapType mapType = (MapType)this.elementType;
        return new FlussMapAsPaimonMap(flussMap, mapType.getKeyType(), mapType.getValueType());
    }

    public org.apache.paimon.data.InternalRow getRow(int pos, int numFields) {
        InternalRow nestedFlussRow = this.flussArray.getRow(pos, numFields);
        return nestedFlussRow == null ? null : new FlussRowAsPaimonRow(nestedFlussRow, (RowType)this.elementType);
    }

    public boolean[] toBooleanArray() {
        return this.flussArray.toBooleanArray();
    }

    public byte[] toByteArray() {
        return this.flussArray.toByteArray();
    }

    public short[] toShortArray() {
        return this.flussArray.toShortArray();
    }

    public int[] toIntArray() {
        return this.flussArray.toIntArray();
    }

    public long[] toLongArray() {
        return this.flussArray.toLongArray();
    }

    public float[] toFloatArray() {
        return this.flussArray.toFloatArray();
    }

    public double[] toDoubleArray() {
        return this.flussArray.toDoubleArray();
    }
}

