/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.fluss.annotation.VisibleForTesting;
import org.apache.fluss.config.Configuration;
import org.apache.fluss.exception.InvalidAlterTableException;
import org.apache.fluss.exception.TableAlreadyExistException;
import org.apache.fluss.exception.TableNotExistException;
import org.apache.fluss.lake.lakestorage.LakeCatalog;
import org.apache.fluss.lake.paimon.utils.PaimonConversions;
import org.apache.fluss.lake.paimon.utils.PaimonTableValidation;
import org.apache.fluss.metadata.TableChange;
import org.apache.fluss.metadata.TableDescriptor;
import org.apache.fluss.metadata.TablePath;
import org.apache.fluss.utils.IOUtils;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaimonLakeCatalog
implements LakeCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(PaimonLakeCatalog.class);
    public static final LinkedHashMap<String, DataType> SYSTEM_COLUMNS = new LinkedHashMap();
    private final Catalog paimonCatalog;

    public PaimonLakeCatalog(Configuration configuration) {
        this.paimonCatalog = CatalogFactory.createCatalog((CatalogContext)CatalogContext.create((Options)Options.fromMap((Map)configuration.toMap())));
    }

    @VisibleForTesting
    protected Catalog getPaimonCatalog() {
        return this.paimonCatalog;
    }

    public void createTable(TablePath tablePath, TableDescriptor tableDescriptor, LakeCatalog.Context context) throws TableAlreadyExistException {
        Schema paimonSchema = PaimonConversions.toPaimonSchema(tableDescriptor);
        try {
            this.createTable(tablePath, paimonSchema, context.isCreatingFlussTable());
        }
        catch (Catalog.DatabaseNotExistException e) {
            this.createDatabase(tablePath.getDatabaseName());
            try {
                this.createTable(tablePath, paimonSchema, context.isCreatingFlussTable());
            }
            catch (Catalog.DatabaseNotExistException t) {
                throw new RuntimeException(String.format("Fail to create table %s in Paimon, because Database %s still doesn't exist although create database successfully, please try again.", tablePath, tablePath.getDatabaseName()));
            }
        }
    }

    public void alterTable(TablePath tablePath, List<TableChange> tableChanges, LakeCatalog.Context context) throws TableNotExistException {
        try {
            List<SchemaChange> paimonSchemaChanges;
            Table table = this.paimonCatalog.getTable(PaimonConversions.toPaimon(tablePath));
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            Schema currentPaimonSchema = fileStoreTable.schema().toSchema();
            if (PaimonTableValidation.isPaimonSchemaCompatible(currentPaimonSchema, PaimonConversions.toPaimonSchema(context.getCurrentTable()))) {
                paimonSchemaChanges = PaimonConversions.toPaimonSchemaChanges(tableChanges);
            } else if (PaimonTableValidation.isPaimonSchemaCompatible(currentPaimonSchema, PaimonConversions.toPaimonSchema(context.getExpectedTable()))) {
                paimonSchemaChanges = PaimonConversions.toPaimonSchemaChanges(tableChanges.stream().filter(tableChange -> !(tableChange instanceof TableChange.AddColumn)).collect(Collectors.toList()));
            } else {
                throw new InvalidAlterTableException(String.format("Paimon schema is not compatible with Fluss schema: Paimon schema: %s, Fluss schema: %s. therefore you need to add the diff columns all at once, rather than applying other table changes: %s.", currentPaimonSchema, context.getCurrentTable().getSchema(), tableChanges));
            }
            if (!paimonSchemaChanges.isEmpty()) {
                this.paimonCatalog.alterTable(PaimonConversions.toPaimon(tablePath), paimonSchemaChanges, false);
            }
        }
        catch (Catalog.ColumnAlreadyExistException | Catalog.ColumnNotExistException e) {
            throw new InvalidAlterTableException(e.getMessage());
        }
        catch (Catalog.TableNotExistException e) {
            throw new TableNotExistException("Table " + tablePath + " does not exist.");
        }
    }

    private void createTable(TablePath tablePath, Schema schema, boolean isCreatingFlussTable) throws Catalog.DatabaseNotExistException {
        Identifier paimonPath = PaimonConversions.toPaimon(tablePath);
        try {
            this.paimonCatalog.createTable(paimonPath, schema, false);
        }
        catch (Catalog.TableAlreadyExistException e) {
            try {
                Table table = this.paimonCatalog.getTable(paimonPath);
                FileStoreTable fileStoreTable = (FileStoreTable)table;
                Schema existingSchema = fileStoreTable.schema().toSchema();
                if (!PaimonTableValidation.isPaimonSchemaCompatible(existingSchema, schema)) {
                    throw new TableAlreadyExistException(String.format("The table %s already exists in Paimon catalog, but the table schema is not compatible. Existing schema: %s, new schema: %s. Please first drop the table in Paimon catalog or use a new table name.", paimonPath.getEscapedFullName(), existingSchema, schema));
                }
                if (isCreatingFlussTable) {
                    PaimonTableValidation.checkTableIsEmpty(tablePath, fileStoreTable);
                }
            }
            catch (Catalog.TableNotExistException tableNotExistException) {
                throw new InvalidAlterTableException(String.format("Failed to create table %s in Paimon. The table already existed during the initial creation attempt, but subsequently could not be found when trying to get it. Please check whether the Paimon table was manually deleted, and try again.", tablePath));
            }
        }
    }

    private void createDatabase(String databaseName) {
        try {
            this.paimonCatalog.createDatabase(databaseName, true);
        }
        catch (Catalog.DatabaseAlreadyExistException databaseAlreadyExistException) {
            // empty catch block
        }
    }

    public void close() {
        IOUtils.closeQuietly((AutoCloseable)this.paimonCatalog, (String)"paimon catalog");
    }

    static {
        SYSTEM_COLUMNS.put("__bucket", (DataType)DataTypes.INT());
        SYSTEM_COLUMNS.put("__offset", (DataType)DataTypes.BIGINT());
        SYSTEM_COLUMNS.put("__timestamp", (DataType)DataTypes.TIMESTAMP_LTZ_MILLIS());
    }
}

