/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.trafficgovernor;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.bifromq.basecrdt.service.ICRDTService;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceLandscape;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceServerRegister;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficGovernor;
import org.apache.bifromq.baserpc.trafficgovernor.IRPCServiceTrafficService;
import org.apache.bifromq.baserpc.trafficgovernor.NameUtil;
import org.apache.bifromq.baserpc.trafficgovernor.RPCServiceTrafficManager;

class RPCServiceTrafficService
implements IRPCServiceTrafficService {
    private final ICRDTService crdtService;
    private Map<String, RPCServiceTrafficManager> trafficManagerMap = new ConcurrentHashMap<String, RPCServiceTrafficManager>();

    public RPCServiceTrafficService(ICRDTService crdtService) {
        this.crdtService = crdtService;
    }

    @Override
    public Observable<Set<String>> services() {
        return this.crdtService.aliveCRDTs().map(crdtUris -> crdtUris.stream().filter(NameUtil::isLandscapeURI).map(NameUtil::parseServiceUniqueName).collect(Collectors.toSet())).distinctUntilChanged().observeOn(Schedulers.single());
    }

    @Override
    public IRPCServiceLandscape getServiceLandscape(String serviceUniqueName) {
        return this.getTrafficManager(serviceUniqueName);
    }

    @Override
    public IRPCServiceServerRegister getServerRegister(String serviceUniqueName) {
        return this.getTrafficManager(serviceUniqueName);
    }

    @Override
    public IRPCServiceTrafficGovernor getTrafficGovernor(String serviceUniqueName) {
        return this.getTrafficManager(serviceUniqueName);
    }

    private RPCServiceTrafficManager getTrafficManager(String serviceUniqueName) {
        return this.trafficManagerMap.computeIfAbsent(serviceUniqueName, k -> new RPCServiceTrafficManager(serviceUniqueName, this.crdtService));
    }

    @Override
    public void close() {
        this.trafficManagerMap.values().forEach(RPCServiceTrafficManager::close);
    }
}

