/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.server.scheduler;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCall;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.inbox.rpc.proto.SubReply;
import org.apache.bifromq.inbox.rpc.proto.SubRequest;
import org.apache.bifromq.inbox.storage.proto.BatchSubReply;
import org.apache.bifromq.inbox.storage.proto.BatchSubRequest;
import org.apache.bifromq.inbox.storage.proto.InboxServiceRWCoProcInput;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchSubCall
extends BatchMutationCall<SubRequest, SubReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchSubCall.class);

    protected BatchSubCall(IMutationPipeline pipeline, MutationCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected BatchMutationCall.MutationCallTaskBatch<SubRequest, SubReply> newBatch(long ver) {
        return new BatchSubCallTask(ver);
    }

    protected RWCoProcInput makeBatch(Iterable<ICallTask<SubRequest, SubReply, MutationCallBatcherKey>> callTasks) {
        BatchSubRequest.Builder reqBuilder = BatchSubRequest.newBuilder();
        callTasks.forEach(call -> {
            SubRequest request = (SubRequest)call.call();
            BatchSubRequest.Params.Builder paramsBuilder = BatchSubRequest.Params.newBuilder().setTenantId(request.getTenantId()).setInboxId(request.getInboxId()).setVersion(request.getVersion()).setTopicFilter(request.getTopicFilter()).setMaxTopicFilters(request.getMaxTopicFilters()).setOption(request.getOption()).setNow(request.getNow());
            reqBuilder.addParams(paramsBuilder.build());
        });
        long reqId = System.nanoTime();
        return RWCoProcInput.newBuilder().setInboxService(InboxServiceRWCoProcInput.newBuilder().setReqId(reqId).setBatchSub(reqBuilder.build()).build()).build();
    }

    protected void handleOutput(Queue<ICallTask<SubRequest, SubReply, MutationCallBatcherKey>> batchedTasks, RWCoProcOutput output) {
        ICallTask<SubRequest, SubReply, MutationCallBatcherKey> task;
        assert (batchedTasks.size() == output.getInboxService().getBatchSub().getCodeCount());
        int i = 0;
        block7: while ((task = batchedTasks.poll()) != null) {
            SubReply.Builder replyBuilder = SubReply.newBuilder().setReqId(((SubRequest)task.call()).getReqId());
            BatchSubReply.Code code = output.getInboxService().getBatchSub().getCode(i++);
            switch (code) {
                case OK: {
                    task.resultPromise().complete(replyBuilder.setCode(SubReply.Code.OK).build());
                    continue block7;
                }
                case EXISTS: {
                    task.resultPromise().complete(replyBuilder.setCode(SubReply.Code.EXISTS).build());
                    continue block7;
                }
                case NO_INBOX: {
                    task.resultPromise().complete(replyBuilder.setCode(SubReply.Code.NO_INBOX).build());
                    continue block7;
                }
                case EXCEED_LIMIT: {
                    task.resultPromise().complete(replyBuilder.setCode(SubReply.Code.EXCEED_LIMIT).build());
                    continue block7;
                }
                case CONFLICT: {
                    task.resultPromise().complete(replyBuilder.setCode(SubReply.Code.CONFLICT).build());
                    continue block7;
                }
            }
            log.error("Unknown error code: {}", (Object)code);
            task.resultPromise().complete(replyBuilder.setCode(SubReply.Code.ERROR).build());
        }
    }

    protected void handleException(ICallTask<SubRequest, SubReply, MutationCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(SubReply.newBuilder().setReqId(((SubRequest)callTask.call()).getReqId()).setCode(SubReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(SubReply.newBuilder().setReqId(((SubRequest)callTask.call()).getReqId()).setCode(SubReply.Code.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(SubReply.newBuilder().setReqId(((SubRequest)callTask.call()).getReqId()).setCode(SubReply.Code.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }

    private static class BatchSubCallTask
    extends BatchMutationCall.MutationCallTaskBatch<SubRequest, SubReply> {
        private final Map<String, Set<InboxVersion>> inboxes = new HashMap<String, Set<InboxVersion>>();

        private BatchSubCallTask(long ver) {
            super(ver);
        }

        protected void add(ICallTask<SubRequest, SubReply, MutationCallBatcherKey> callTask) {
            super.add(callTask);
            this.inboxes.computeIfAbsent(((SubRequest)callTask.call()).getTenantId(), k -> new HashSet()).add(((SubRequest)callTask.call()).getVersion());
        }

        protected boolean isBatchable(ICallTask<SubRequest, SubReply, MutationCallBatcherKey> callTask) {
            return !this.inboxes.getOrDefault(((SubRequest)callTask.call()).getTenantId(), Collections.emptySet()).contains(((SubRequest)callTask.call()).getVersion());
        }
    }
}

