/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.AbstractIterator;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import org.apache.bifromq.basecrdt.core.api.IRWORSet;
import org.apache.bifromq.basecrdt.core.api.RWORSetOperation;
import org.apache.bifromq.basecrdt.core.internal.CausalCRDT;
import org.apache.bifromq.basecrdt.core.internal.DotMap;
import org.apache.bifromq.basecrdt.core.internal.DotSet;
import org.apache.bifromq.basecrdt.core.internal.IDotMap;
import org.apache.bifromq.basecrdt.proto.Replica;

class RWORSet
extends CausalCRDT<IDotMap, RWORSetOperation>
implements IRWORSet {
    public static final ByteString TRUE = ByteString.copyFrom((byte[])new byte[]{-1});
    public static final ByteString FALSE = ByteString.copyFrom((byte[])new byte[]{0});

    RWORSet(Replica replica, CausalCRDT.DotStoreAccessor<IDotMap> dotStoreAccessor, CausalCRDT.CRDTOperationExecutor<RWORSetOperation> executor) {
        super(replica, dotStoreAccessor, executor);
    }

    @Override
    public boolean contains(ByteString element) {
        IDotMap dotStore = (IDotMap)this.dotStoreAccessor.fetch();
        IDotMap valueDotMap = dotStore.subDotMap(element).orElse(DotMap.BOTTOM);
        if (valueDotMap.subDotSet(FALSE).orElse(DotSet.BOTTOM).isBottom()) {
            return !valueDotMap.subDotSet(TRUE).orElse(DotSet.BOTTOM).isBottom();
        }
        return false;
    }

    @Override
    public Iterator<ByteString> elements() {
        return new AbstractIterator<ByteString>(){
            private final Iterator<ByteString> dotMapKeys;
            {
                this.dotMapKeys = ((IDotMap)RWORSet.this.dotStoreAccessor.fetch()).dotMapKeys(new ByteString[0]);
            }

            protected ByteString computeNext() {
                if (this.dotMapKeys.hasNext()) {
                    ByteString element = this.dotMapKeys.next();
                    if (RWORSet.this.contains(element)) {
                        return element;
                    }
                    return this.computeNext();
                }
                return (ByteString)this.endOfData();
            }
        };
    }
}

