/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler.ws;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import org.apache.bifromq.mqtt.handler.ConditionalRejectHandler;
import org.apache.bifromq.mqtt.handler.MQTTMessageDebounceHandler;
import org.apache.bifromq.mqtt.handler.MQTTPreludeHandler;
import org.apache.bifromq.mqtt.handler.condition.DirectMemPressureCondition;
import org.apache.bifromq.mqtt.handler.condition.HeapMemPressureCondition;
import org.apache.bifromq.mqtt.handler.condition.ORCondition;
import org.apache.bifromq.mqtt.handler.ws.ByteBufToWebSocketFrameEncoder;
import org.apache.bifromq.mqtt.handler.ws.WebSocketFrameToByteBufDecoder;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;

public class MqttOverWSHandler
extends ChannelInboundHandlerAdapter {
    private final int maxMQTTConnectPacketSize;
    private final int connectTimeoutSeconds;
    private final IEventCollector eventCollector;

    public MqttOverWSHandler(int maxMQTTConnectPacketSize, int connectTimeoutSeconds, IEventCollector eventCollector) {
        this.maxMQTTConnectPacketSize = maxMQTTConnectPacketSize;
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        this.eventCollector = eventCollector;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
            ChannelPipeline pipeline = ctx.pipeline();
            pipeline.addLast("ws2bytebufDecoder", (ChannelHandler)new WebSocketFrameToByteBufDecoder());
            pipeline.addLast("bytebuf2wsEncoder", (ChannelHandler)new ByteBufToWebSocketFrameEncoder());
            pipeline.addLast(MqttEncoder.class.getName(), (ChannelHandler)MqttEncoder.INSTANCE);
            pipeline.addLast(MqttDecoder.class.getName(), (ChannelHandler)new MqttDecoder(this.maxMQTTConnectPacketSize));
            pipeline.addLast("MQTTMessageDebounceHandler", (ChannelHandler)new MQTTMessageDebounceHandler());
            pipeline.addLast("ConditionalRejectHandler", (ChannelHandler)new ConditionalRejectHandler(ORCondition.or(DirectMemPressureCondition.INSTANCE, HeapMemPressureCondition.INSTANCE), this.eventCollector));
            pipeline.addLast("MqttPreludeHandler", (ChannelHandler)new MQTTPreludeHandler(this.connectTimeoutSeconds));
            ctx.pipeline().remove((ChannelHandler)this);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

